<?php
namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http; 
use App\Models\Customer;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class GoogleLoginController extends Controller
{
    public function redirectToGoogle()
    {
        $query = http_build_query([
            'client_id' => env('GOOGLE_CLIENT_ID'),
            'redirect_uri' => env('GOOGLE_REDIRECT_URI'),
            'response_type' => 'code',
            'scope' => 'openid email profile',
            'access_type' => 'offline',
            'prompt' => 'consent',
        ]);

        return redirect('https://accounts.google.com/o/oauth2/v2/auth?' . $query);
    }

    public function handleCallback(Request $request)
    {
        $code = $request->get('code');

        $response = Http::asForm()->post('https://oauth2.googleapis.com/token', [
            'code' => $code,
            'client_id' => env('GOOGLE_CLIENT_ID'),
            'client_secret' => env('GOOGLE_CLIENT_SECRET'),
            'redirect_uri' => env('GOOGLE_REDIRECT_URI'),
            'grant_type' => 'authorization_code',
        ]);

        $tokenData = $response->json();
        $accessToken = $tokenData['access_token'];

        $userData = Http::withToken($accessToken)->get('https://www.googleapis.com/oauth2/v3/userinfo')->json();

        $customer = Customer::where('email', $userData['email'])->first();

        if (!$customer) {
            $customer = Customer::create([
                'name' => $userData['name'],
                'phone' => '010000000000',
                'email' => $userData['email'],
                'password' => bcrypt(Str::random(16)),
            ]);
        }

        Auth::guard('customer')->login($customer);

        return redirect('/')->with('success', 'Logged in successfully!');
    }
}
