<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Brand extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'slug', 'image'];

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($brand) {
            if (! $brand->slug) {
                $brand->slug = Str::slug($brand->name);
            }
        });

        static::updating(function ($brand) {
            if (! $brand->slug) {
                $brand->slug = Str::slug($brand->name);
            }
        });

        static::deleting(function ($brand) {
            if ($brand->products()->count() > 0) {
                throw new \Exception('Cannot delete this brand because it has products.');
            }
        });
    }
}