<?php

use App\Http\Middleware\CheckBlockedIp;
use App\Http\Middleware\ClearBuyNow;
use App\Http\Middleware\Customer;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->prepend(ClearBuyNow::class);
        $middleware->prepend(CheckBlockedIp::class);
        
        $middleware->alias([
            'customer.auth' => Customer::class,
        ]);
        
        $middleware->redirectUsersTo(fn () => route('admin.dashboard'));
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })
    ->create();
