<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Portal | Dashboard Login</title>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
        }

        .login-card {
            background: #111827;
            border: 1px solid #1f2937;
        }
    </style>
</head>

<style>
    html,
    body,
    main,
    aside nav {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }

    html::-webkit-scrollbar,
    body::-webkit-scrollbar,
    main::-webkit-scrollbar,
    aside nav::-webkit-scrollbar {
        display: none !important;
    }
</style>

<body class="bg-[#0b0f1a] flex items-center justify-center p-4 relative">

    <div class="absolute top-[-10%] left-[-10%] w-[40%] h-[40%] bg-cyan-500/10 rounded-full blur-[120px]"></div>
    <div class="absolute bottom-[-10%] right-[-10%] w-[40%] h-[40%] bg-purple-500/10 rounded-full blur-[120px]"></div>

    <div class="relative z-10 w-full max-w-[440px] animate-in fade-in zoom-in duration-500">

        <div class="text-center mb-8">
            <div
                class="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-gradient-to-br from-cyan-400 to-blue-600 shadow-lg shadow-cyan-500/20 mb-4 transform -rotate-6">
                <i class="ri-shield-user-fill text-3xl text-white"></i>
            </div>
            <h2 class="text-3xl font-extrabold text-white tracking-tight">Admin <span
                    class="text-cyan-400">Portal</span></h2>
            <p class="text-gray-500 text-sm mt-2 font-medium">Please enter your credentials to continue</p>
        </div>

        <div class="login-card p-8 md:p-10 rounded-[2rem] shadow-2xl">

            @if (session()->has('error'))
                <div
                    class="bg-red-500/10 border border-red-500/20 text-red-400 py-3 px-4 mb-6 rounded-xl text-sm flex items-center gap-3">
                    <i class="ri-error-warning-fill text-lg"></i>
                    <span class="font-medium">{{ session()->get('error') }}</span>
                </div>
            @endif

            <form action="{{ route('login') }}" method="POST" class="space-y-6">
                @csrf
                <input type="text" name="fakeusernameremembered" class="hidden">
                <input type="password" name="fakepasswordremembered" class="hidden">

                <div class="space-y-2">
                    <label for="email"
                        class="text-[11px] font-bold text-gray-400 uppercase tracking-widest ml-1">Work Email</label>
                    <div class="relative group">
                        <div
                            class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-500 group-focus-within:text-cyan-400 transition-colors">
                            <i class="ri-mail-send-line text-lg"></i>
                        </div>
                        <input type="email" name="email" id="email" required placeholder="admin@company.com"
                            class="w-full pl-11 pr-4 py-3.5 bg-gray-900/50 border border-gray-800 text-white placeholder-gray-600 rounded-xl focus:outline-none focus:border-cyan-500 focus:ring-1 focus:ring-cyan-500 transition-all font-medium @error('email') border-red-500 @enderror"
                            value="{{ old('email') }}">
                    </div>
                    @error('email')
                        <p class="text-[11px] text-red-400 font-bold mt-1 ml-1 uppercase">{{ $message }}</p>
                    @enderror
                </div>

                <div class="space-y-2">
                    <div class="flex justify-between items-center px-1">
                        <label for="password"
                            class="text-[11px] font-bold text-gray-400 uppercase tracking-widest">Secret Token</label>
                        <a href="#"
                            class="text-[10px] font-bold text-cyan-400 uppercase hover:text-cyan-300 transition">Forgot?</a>
                    </div>
                    <div class="relative group">
                        <div
                            class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-500 group-focus-within:text-cyan-400 transition-colors">
                            <i class="ri-lock-password-line text-lg"></i>
                        </div>
                        <input type="password" name="password" id="password" required placeholder="••••••••••••"
                            class="w-full pl-11 pr-4 py-3.5 bg-gray-900/50 border border-gray-800 text-white placeholder-gray-600 rounded-xl focus:outline-none focus:border-cyan-500 focus:ring-1 focus:ring-cyan-500 transition-all font-medium @error('password') border-red-500 @enderror">
                    </div>
                    @error('password')
                        <p class="text-[11px] text-red-400 font-bold mt-1 ml-1 uppercase">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center gap-2 px-1">
                    <input type="checkbox" id="remember"
                        class="w-4 h-4 rounded border-gray-800 bg-gray-900 text-cyan-500 focus:ring-offset-gray-900 focus:ring-cyan-500">
                    <label for="remember" class="text-xs font-semibold text-gray-500 cursor-pointer select-none">Keep me
                        logged in</label>
                </div>

                <button type="submit"
                    class="w-full bg-gradient-to-r from-cyan-500 to-blue-600 hover:from-cyan-400 hover:to-blue-500 text-white font-bold py-4 rounded-xl shadow-lg shadow-cyan-500/20 active:scale-[0.98] transition-all flex items-center justify-center gap-3 uppercase tracking-widest text-xs">
                    Authorize Access <i class="ri-arrow-right-line text-lg"></i>
                </button>
            </form>
        </div>

        <p class="text-center text-[10px] font-bold text-gray-600 mt-8 uppercase tracking-[3px]">
            &copy; {{ date('Y') }} Secure Admin Infrastructure
        </p>
    </div>

</body>

</html>
