@extends('backend.layouts.app')
@section('title', 'Coupon Management')
@section('content')
    <div class="w-full mb-6">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center pb-4 border-b rounded-md mb-4">
            <div class="flex flex-col gap-3 w-full md:w-2/3">
                <h1 class="text-xl font-bold text-gray-800">Coupon Management</h1>
                <p class="text-sm text-gray-500">Manage your discount coupons easily</p>
            </div>
            <div class="flex flex-row gap-2 mt-3 md:mt-0 w-full md:w-auto items-start sm:items-center">
                <a href="{{ route('admin.coupons.create') }}"
                    class="flex items-center gap-2 h-10 bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] hover:bg-[{{ $theme->theme_hover }}] px-5 py-2 rounded-md shadow font-medium transition-all duration-200">
                    <i class="ri-add-line text-lg"></i> Add Coupon
                </a>
            </div>
        </div>

        <form method="GET" action="{{ route('admin.coupons.index') }}"
            class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 gap-2 sm:gap-4">
            <div class="flex flex-col sm:flex-row w-full sm:w-2/3 gap-2">
                <div class="relative w-full sm:w-1/2">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search coupon code..."
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 pl-10 pr-3 py-2
                        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200" />
                    <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 text-lg pointer-events-none">
                        <i class="ri-search-line"></i>
                    </span>
                </div>
                <button type="submit"
                    class="flex justify-center items-center px-4 py-2 h-10 rounded-md bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] hover:bg-[{{ $theme->theme_hover }}] font-medium transition-all duration-150 mt-2 sm:mt-0">
                    <i class="ri-search-line mr-1"></i> Search
                </button>
            </div>
            <a href="{{ route('admin.coupons.index') }}"
                class="flex justify-center items-center px-4 py-2 h-10 md:w-auto w-full rounded-md bg-gray-500 hover:bg-gray-600 text-white font-medium transition-all duration-150 mt-2 sm:mt-0">
                Reset
            </a>
        </form>

        <div class="overflow-x-auto bg-white rounded shadow">
            <table class="min-w-full table-auto text-sm">
                <thead class="bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] font-semibold">
                    <tr>
                        <th class="px-4 py-3 text-center">#</th>
                        <th class="px-4 py-3 text-left">Code</th>
                        <th class="px-4 py-3 text-left">Type</th>
                        <th class="px-4 py-3 text-left">Value</th>
                        <th class="px-4 py-3 text-left">Min Purchase</th>
                        <th class="px-4 py-3 text-left">Category</th>
                        <th class="px-4 py-3 text-left">Expiry</th>
                        <th class="px-4 py-3 text-center">Status</th>
                        <th class="px-4 py-3 text-right pr-8">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-gray-700 divide-y divide-gray-200">
                    @forelse ($coupons as $index => $coupon)
                        <tr class="hover:bg-gray-50 transition-colors">
                            <td class="px-4 py-3 text-center">{{ $index + 1 }}</td>
                            <td class="px-4 py-3 font-medium">{{ $coupon->code }}</td>
                            <td class="px-4 py-3 capitalize">{{ $coupon->type }}</td>
                            <td class="px-4 py-3">
                                {{ $coupon->type == 'percent' ? $coupon->value . '%' : '৳' . number_format($coupon->value, 2) }}
                            </td>
                            <td class="px-4 py-3">
                                {{ $coupon->min_purchase ? '৳' . number_format($coupon->min_purchase, 2) : '-' }}
                            </td>
                            <td class="px-4 py-3">
                                {{ $coupon->category ? $coupon->category->name : 'All Categories' }}
                            </td>
                            <td class="px-4 py-3">
                                {{ $coupon->expiry_date ? date('d M Y', strtotime($coupon->expiry_date)) : 'No Expiry' }}
                            </td>
                            <td class="px-4 py-3 text-center">
                                <span
                                    class="px-2 py-1 rounded {{ $coupon->status ? 'bg-green-500' : 'bg-red-500' }} text-white text-xs">
                                    {{ $coupon->status ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-right">
                                <div class="flex justify-end items-center gap-2">
                                    <a href="{{ route('admin.coupons.edit', $coupon->id) }}"
                                        class="relative group inline-flex items-center justify-center w-8 h-8 bg-blue-500 text-white rounded-full shadow hover:bg-blue-600 transition-all">
                                        <i class="ri-edit-2-line"></i>
                                        <span
                                            class="absolute -top-8 left-1/2 -translate-x-1/2 scale-0 group-hover:scale-100 transition-transform duration-200 bg-gray-800 text-white text-[10px] px-2 py-1 rounded whitespace-nowrap">Edit</span>
                                    </a>
                                    <form action="{{ route('admin.coupons.destroy', $coupon->id) }}" method="POST"
                                        onsubmit="return confirm('Delete this coupon?');">
                                        @csrf @method('DELETE')
                                        <button type="submit"
                                            class="relative group inline-flex items-center justify-center w-8 h-8 bg-red-500 text-white rounded-full shadow hover:bg-red-600 transition-all">
                                            <i class="ri-delete-bin-6-line"></i>
                                            <span
                                                class="absolute -top-8 left-1/2 -translate-x-1/2 scale-0 group-hover:scale-100 transition-transform duration-200 bg-gray-800 text-white text-[10px] px-2 py-1 rounded whitespace-nowrap">Delete</span>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="py-4 text-center text-gray-400">No coupons found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if ($coupons->hasPages())
            <div class="mt-4 flex justify-end gap-2">
                @if ($coupons->onFirstPage())
                    <span class="px-4 py-2 rounded-md bg-gray-100 text-gray-500 cursor-not-allowed">Previous</span>
                @else
                    <a href="{{ $coupons->previousPageUrl() }}"
                        class="px-4 py-2 rounded-md bg-white border border-gray-300 hover:bg-gray-50">Previous</a>
                @endif
                @if ($coupons->hasMorePages())
                    <a href="{{ $coupons->nextPageUrl() }}"
                        class="px-4 py-2 rounded-md bg-white border border-gray-300 hover:bg-gray-50">Next</a>
                @else
                    <span class="px-4 py-2 rounded-md bg-gray-100 text-gray-500 cursor-not-allowed">Next</span>
                @endif
            </div>
        @endif
    </div>
@endsection
