@extends('backend.layouts.app')
@section('title', 'Dashboard')
@section('content')
    <div class="p-6 bg-[#f8fafc] min-h-screen">

        <div class="flex flex-col md:flex-row md:items-center justify-between mb-8 gap-4">
            <div>
                <h1 class="text-2xl font-extrabold text-gray-900 tracking-tight">Welcome back, {{ auth()->user()->name }}! 👋
                </h1>
                <p class="text-gray-500 text-sm mt-1">Here's what's happening with your store today.</p>
            </div>
            <div class="flex items-center gap-3">
                <span
                    class="flex items-center gap-1 text-xs font-medium bg-white border px-3 py-1.5 rounded-full shadow-sm text-gray-600">
                    <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span> Live System
                </span>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <div onclick="window.location.href='{{ route('admin.orders.index') }}'"
                class="group bg-white p-6 rounded-2xl border border-gray-100 shadow-sm hover:shadow-md hover:border-blue-200 transition-all cursor-pointer">
                <div class="flex items-center justify-between">
                    <div
                        class="p-3 bg-blue-50 text-blue-600 rounded-xl group-hover:bg-blue-600 group-hover:text-white transition-colors">
                        <i class="ri-shopping-cart-2-line text-2xl"></i>
                    </div>
                    <span class="text-xs font-medium text-green-600 bg-green-50 px-2 py-1 rounded-lg">+12%</span>
                </div>
                <div class="mt-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Total Orders</p>
                    <h2 class="text-3xl font-bold text-gray-800 mt-1">{{ $ordersCount['all order'] ?? 0 }}</h2>
                </div>
            </div>

            <div onclick="window.location.href='{{ route('admin.products.index') }}'"
                class="group bg-white p-6 rounded-2xl border border-gray-100 shadow-sm hover:shadow-md hover:border-indigo-200 transition-all cursor-pointer">
                <div class="flex items-center justify-between">
                    <div
                        class="p-3 bg-indigo-50 text-indigo-600 rounded-xl group-hover:bg-indigo-600 group-hover:text-white transition-colors">
                        <i class="ri-box-3-line text-2xl"></i>
                    </div>
                </div>
                <div class="mt-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Active Products</p>
                    <h2 class="text-3xl font-bold text-gray-800 mt-1">{{ $productCount ?? 0 }}</h2>
                </div>
            </div>

            <div onclick="window.location.href='{{ route('admin.categories.index') }}'"
                class="group bg-white p-6 rounded-2xl border border-gray-100 shadow-sm hover:shadow-md hover:border-green-200 transition-all cursor-pointer">
                <div class="flex items-center justify-between">
                    <div
                        class="p-3 bg-green-50 text-green-600 rounded-xl group-hover:bg-green-600 group-hover:text-white transition-colors">
                        <i class="ri-folder-4-line text-2xl"></i>
                    </div>
                </div>
                <div class="mt-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Categories</p>
                    <h2 class="text-3xl font-bold text-gray-800 mt-1">{{ $categoryCount ?? 0 }}</h2>
                </div>
            </div>

            <div onclick="window.location.href='{{ route('admin.orders.report') }}'"
                class="group bg-white p-6 rounded-2xl border border-gray-100 shadow-sm hover:shadow-md hover:border-teal-200 transition-all cursor-pointer">
                <div class="flex items-center justify-between">
                    <div
                        class="p-3 bg-teal-50 text-teal-600 rounded-xl group-hover:bg-teal-600 group-hover:text-white transition-colors">
                        <i class="ri-money-dollar-circle-line text-2xl"></i>
                    </div>
                </div>
                <div class="mt-4">
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Monthly Sales</p>
                    <h2 class="text-2xl font-bold text-gray-800 mt-1">৳ {{ number_format($monthlySales ?? 0, 0) }}</h2>
                </div>
            </div>
        </div>

        <div class="mb-6 flex items-center justify-between">
            <h2 class="text-lg font-bold text-gray-800 flex items-center gap-2">
                <i class="ri-pie-chart-line text-indigo-500"></i> Order Status Overview
            </h2>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-5">
            @php
                $statusConfigs = [
                    'pending' => ['color' => 'bg-amber-500', 'icon' => 'ri-time-line', 'light' => 'bg-amber-50'],
                    'confirmed' => [
                        'color' => 'bg-blue-500',
                        'icon' => 'ri-checkbox-circle-line',
                        'light' => 'bg-blue-50',
                    ],
                    'ready' => ['color' => 'bg-purple-500', 'icon' => 'ri-refresh-line', 'light' => 'bg-purple-50'],
                    'shipped' => ['color' => 'bg-cyan-500', 'icon' => 'ri-truck-line', 'light' => 'bg-cyan-50'],
                    'delivered' => [
                        'color' => 'bg-emerald-500',
                        'icon' => 'ri-check-double-line',
                        'light' => 'bg-emerald-50',
                    ],
                    'cancelled' => [
                        'color' => 'bg-rose-500',
                        'icon' => 'ri-close-circle-line',
                        'light' => 'bg-rose-50',
                    ],
                    'refunded' => ['color' => 'bg-gray-600', 'icon' => 'ri-refund-2-line', 'light' => 'bg-gray-100'],
                ];
            @endphp

            @foreach ($ordersCount as $status => $count)
                @php
                    $key = strtolower(str_replace(' ', '', $status));
                    $config = $statusConfigs[$key] ?? [
                        'color' => 'bg-indigo-500',
                        'icon' => 'ri-stack-line',
                        'light' => 'bg-indigo-50',
                    ];
                @endphp

                <div
                    class="bg-white p-5 rounded-2xl border border-gray-100 shadow-sm hover:shadow-lg transition-all border-b-4 border-b-{{ str_replace('bg-', '', $config['color']) }}">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 {{ $config['light'] }} flex items-center justify-center rounded-xl">
                            <i
                                class="{{ $config['icon'] }} {{ str_replace('bg-', 'text-', $config['color']) }} text-xl"></i>
                        </div>
                        <div>
                            <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">{{ $status }}</p>
                            <h3 class="text-2xl font-black text-gray-800">{{ $count }}</h3>
                        </div>
                    </div>
                    <div class="w-full bg-gray-100 h-1.5 rounded-full mt-4 overflow-hidden">
                        <div class="{{ $config['color'] }} h-full"
                            style="width: {{ min(($count / max(array_sum($ordersCount), 1)) * 100, 100) }}%"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <style>
        /* Custom Scrollbar for better UI */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>
@endsection
