@extends('backend.layouts.app')
@section('title', 'IP Management')
@section('content')
    <div class="w-full mb-6">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center pb-4 border-b rounded-md mb-4">
            <div class="flex flex-col gap-1 w-full md:w-2/3">
                <h1 class="text-xl font-bold text-gray-800">IP Management</h1>
                <p class="text-sm text-gray-500 italic">Manage and unblock restricted IP addresses</p>
            </div>
        </div>

        <form method="GET" action="{{ route('admin.ip_block.index') }}"
            class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-3">

            <div class="flex flex-col sm:flex-row w-full sm:w-2/3 gap-2">
                <div class="relative w-full sm:w-1/2">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search IPs..."
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 pl-10 pr-3 py-2
                    text-sm outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200" />
                    <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 text-lg pointer-events-none">
                        <i class="ri-search-line"></i>
                    </span>
                </div>

                <button type="submit"
                    class="flex justify-center items-center px-6 py-2 h-10 rounded-md bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] hover:bg-[{{ $theme->theme_hover }}] font-medium transition-all duration-150">
                    Search
                </button>
            </div>

            <a href="{{ route('admin.ip_block.index') }}"
                class="flex justify-center items-center px-4 py-2 h-10 md:w-auto w-full rounded-md bg-gray-500 hover:bg-gray-600 text-white font-medium transition-all duration-150">
                <i class="ri-refresh-line mr-1"></i> Reset
            </a>
        </form>

        <div class="overflow-x-auto bg-white rounded shadow-sm border border-gray-100">
            <table class="min-w-full table-auto">
                <thead class="bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] text-sm">
                    <tr>
                        <th class="px-4 py-3 text-center w-12">#</th>
                        <th class="px-4 py-3 text-left whitespace-nowrap">IP Address</th>
                        <th class="px-4 py-3 text-left">Reason / Device Info</th>
                        <th class="px-4 py-3 text-center whitespace-nowrap">Blocked Date</th>
                        <th class="px-4 py-3 text-right pr-8">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm text-gray-700 divide-y divide-gray-200">
                    @forelse ($blockedIps as $index => $ip)
                        <tr class="hover:bg-red-50/30 transition-colors">
                            <td class="px-4 py-4 text-center text-gray-400 font-mono">{{ $index + 1 }}</td>
                            <td class="px-4 py-4 font-bold text-red-600 font-mono tracking-tight">
                                {{ $ip->ip_address }}
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex flex-col">
                                    <span class="font-medium text-gray-800">{{ $ip->reason ?? 'System Blocked' }}</span>
                                    <span class="text-[11px] text-gray-400 truncate max-w-xs md:max-w-md"
                                        title="{{ $ip->user_agent }}">
                                        {{ $ip->user_agent }}
                                    </span>
                                </div>
                            </td>
                            <td class="px-4 py-4 text-center whitespace-nowrap text-gray-500">
                                {{ $ip->created_at->format('d M, Y') }} <br>
                                <span class="text-[10px]">{{ $ip->created_at->format('h:i A') }}</span>
                            </td>
                            <td class="px-4 py-4 text-right">
                                <form action="{{ route('admin.ip_block.destroy', $ip->id) }}" method="POST"
                                    onsubmit="return confirm('Release this IP from blocklist?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                        class="inline-flex items-center justify-center px-4 py-1.5 bg-green-600 hover:bg-green-700 text-white rounded-md shadow-sm text-xs font-medium transition-all">
                                        <i class="ri-shield-user-line mr-1"></i> Unblock
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-12 px-3 text-center">
                                <div class="flex flex-col items-center opacity-30">
                                    <i class="ri-shield-check-line text-5xl"></i>
                                    <p class="mt-2 text-lg">No blocked IPs found.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if ($blockedIps->hasPages())
            <div class="mt-6">
                {{ $blockedIps->links() }}
            </div>
        @endif
    </div>
@endsection
