@extends('backend.layouts.app')
@section('title', 'Edit Product')
@section('content')
    <link href="https://cdn.jsdelivr.net/npm/tom-select/dist/css/tom-select.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>

    <style>
        .ts-control {
            border: 1px solid #d0d0d0;
            padding: 11px 12px;
            width: 100%;
            overflow: hidden;
            position: relative;
            z-index: 1;
            box-sizing: border-box;
            box-shadow: none;
            border-radius: 6px;
            display: flex;
            flex-wrap: wrap;
        }
    </style>

    <div class="w-full flex flex-col gap-4 mb-20">
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Edit Products</h2>
                <a href="{{ route('admin.products.index') }}"
                    class="block md:hidden bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] px-4 py-2 rounded text-sm font-medium hover:bg-[{{ $theme->theme_hover }}] transition">
                    All Products
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="{{ route('admin.dashboard') }}" class="text-blue-600 hover:underline">Home</a> / Product /
                    Edit
                </p>
                <a href="{{ route('admin.products.index') }}"
                    class="hidden md:inline-flex items-center bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] px-4 py-2 rounded text-base font-medium hover:bg-[{{ $theme->theme_hover }}] transition">
                    All Products
                </a>
            </div>
        </div>

        <div class="w-full bg-white rounded shadow px-6 py-6">
            <form id="productForm" action="{{ route('admin.products.update', $product->id) }}" method="POST"
                enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-5 md:gap-6">
                @csrf
                @method('PUT')

                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Name</label>
                    <input type="text" name="name" placeholder="Product Name" id="productName"
                        value="{{ old('name', $product->name) }}"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>

                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Description</label>
                    <textarea id="productDescription" name="description"
                        class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm sm:text-base">{{ old('description', $product->desc) }}</textarea>
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">SKU</label>
                    <input type="text" name="sku" placeholder="SKU" value="{{ old('sku', $product->sku) }}"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Select Brand</label>
                    <select name="brand_id" id="brand" required
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Brand --</option>
                        @foreach ($brands as $brand)
                            <option value="{{ $brand->id }}"
                                {{ old('brand_id', $product->brand_id) == $brand->id ? 'selected' : '' }}>
                                {{ $brand->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Stock</label>
                    <input type="number" name="stock" placeholder="Stock" value="{{ old('stock', $product->stock) }}"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Select Category</label>
                    <select name="category_id" id="category" required
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Category --</option>
                        @foreach ($categories as $category)
                            <option value="{{ $category->id }}"
                                {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Select Subcategory</label>
                    <select name="subcategory_id" id="subcategory"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Subcategory --</option>
                    </select>
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Buy Price</label>
                    <input type="number" name="buy_price" placeholder="Enter Buy Price"
                        value="{{ old('buy_price', $product->buy_price) }}"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Old Price</label>
                    <input type="number" name="old_price" placeholder="Enter Old Price"
                        value="{{ old('old_price', $product->old_price) }}"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">New Price</label>
                    <input type="number" name="new_price" placeholder="Enter New Price"
                        value="{{ old('new_price', $product->new_price) }}"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>

                <div class="col-span-2">
                    <label class="block text-md font-medium text-gray-700 mb-2">Product Images</label>

                    <div class="flex flex-wrap gap-4 p-4 bg-gray-50 rounded-lg border border-dashed border-gray-300">

                        @foreach ($product->images as $img)
                            <div class="relative w-24 h-24 group preview-box" id="img-container-{{ $img->id }}">
                                <img src="{{ asset('public/uploads/products/' . $img->image) }}"
                                    class="w-full h-full object-cover rounded-lg border shadow-sm">

                                <div
                                    class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity rounded-lg">
                                    <button type="button" onclick="deletePermanentImage({{ $img->id }})"
                                        class="text-white bg-red-500 rounded-full p-1.5 hover:bg-red-600 transition shadow-lg">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        @endforeach

                        <div id="new-image-preview-wrapper" class="flex flex-wrap gap-4"></div>

                        <div
                            class="relative w-24 h-24 flex flex-col items-center justify-center border-2 border-dashed border-gray-300 rounded-lg hover:border-[{{ $theme->theme_bg }}] hover:bg-gray-100 transition-all cursor-pointer group">
                            <input type="file" name="image[]" id="edit-image-input" accept="image/*" multiple
                                class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-10">
                            <svg xmlns="http://www.w3.org/2000/svg"
                                class="h-8 w-8 text-gray-400 group-hover:text-[{{ $theme->theme_bg }}]" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 4v16m8-8H4" />
                            </svg>
                            <span class="text-[10px] text-gray-400 font-bold uppercase mt-1">Add New</span>
                        </div>
                    </div>
                </div>

                <div class="col-span-2 mt-4">
                    <label class="block text-md font-medium text-gray-700 mb-2">Product Video</label>

                    <div class="flex gap-6 mb-4">
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="radio" name="video_type" value="upload"
                                {{ $product->video_file ? 'checked' : '' }}
                                class="video-option w-4 h-4 text-orange-500 focus:ring-orange-500">
                            <span class="text-sm text-gray-600">Upload Video</span>
                        </label>
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="radio" name="video_type" value="youtube"
                                {{ $product->video_url ? 'checked' : '' }}
                                class="video-option w-4 h-4 text-orange-500 focus:ring-orange-500">
                            <span class="text-sm text-gray-600">Youtube Link</span>
                        </label>
                    </div>

                    <div id="upload_container"
                        class="video-field-wrapper w-full bg-[#f8faff] rounded-xl p-6 border-2 border-dashed border-gray-200 {{ $product->video_url ? 'hidden' : '' }}">

                        <div id="default-design"
                            class="flex flex-col items-center justify-center py-4 cursor-pointer {{ $product->video_file ? 'hidden' : '' }}"
                            onclick="document.getElementById('video_input').click()">
                            <div class="w-16 h-16 bg-white rounded-full flex items-center justify-center shadow-sm mb-3">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-500" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                                </svg>
                            </div>
                            <p class="text-sm font-medium text-gray-700">Click to upload new video</p>
                        </div>

                        <div id="preview-design"
                            class="{{ $product->video_file ? '' : 'hidden' }} flex flex-col md:flex-row items-center gap-5">
                            <div class="relative w-full md:w-48 h-32 bg-black rounded-lg overflow-hidden shadow-lg">
                                <video id="video-preview-player" class="w-full h-full object-cover" controls>
                                    @if ($product->video_file)
                                        <source
                                            src="{{ asset('public/uploads/products/videos/' . $product->video_file) }}"
                                            type="video/mp4">
                                    @endif
                                </video>
                            </div>
                            <div class="flex-1">
                                <p id="file-info" class="text-sm font-mono text-blue-600 font-bold truncate mb-1">
                                    {{ $product->video_file ? $product->video_file : 'No video file' }}
                                </p>
                                <button type="button" id="change-video"
                                    onclick="document.getElementById('video_input').click()"
                                    class="mt-3 text-xs bg-blue-50 text-blue-500 px-3 py-1.5 rounded-md hover:bg-blue-500 hover:text-white transition">
                                    Change Video
                                </button>
                            </div>
                        </div>

                        <input type="file" name="video_file" id="video_input" accept="video/*" class="hidden">
                    </div>

                    <div id="youtube_field" class="video-field-wrapper {{ $product->video_url ? '' : 'hidden' }} mt-2">
                        <input type="url" name="video_url" value="{{ $product->video_url }}"
                            placeholder="Enter Youtube URL here..."
                            class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                    </div>
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Status</label>
                    <select name="status"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200 border-gray-300">
                        <option value="1" {{ old('status', $product->status) == 1 ? 'selected' : '' }}>Active
                        </option>
                        <option value="0" {{ old('status', $product->status) == 0 ? 'selected' : '' }}>Inactive
                        </option>
                    </select>
                </div>

                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Type</label>
                    <select name="type"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200 border-gray-300">
                        <option value="0" {{ old('type', $product->type) == 0 ? 'selected' : '' }}>Normal</option>
                        <option value="1" {{ old('type', $product->type) == 1 ? 'selected' : '' }}>Variable</option>
                    </select>
                </div>

                <div class="col-span-2 md:col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium"><i
                            class="ri-fire-fill text-orange-500"></i> Hot Deals</label>
                    <select name="hot_deal"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200 border-gray-300">
                        <option value="1" {{ old('hot_deal', $product->hot_deal) == 1 ? 'selected' : '' }}>On
                        </option>
                        <option value="0" {{ old('hot_deal', $product->hot_deal) == 0 ? 'selected' : '' }}>Off
                        </option>
                    </select>
                </div>

                <div class="col-span-2" id="variableProductsSection" style="display: none;">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Variants</label>
                    <div id="variableProductsContainer" class="flex flex-col gap-3"></div>
                    <button type="button" id="addVariantBtn"
                        class="mt-2 px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 transition">
                        + Add Variant
                    </button>
                </div>

                <div class="col-span-2 mt-4">
                    <button type="submit"
                        class="w-full rounded-md bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] hover:bg-[{{ $theme->theme_hover }}] py-2.5 text-base transition-all duration-200">
                        Update Product
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const videoInput = document.getElementById('video_input');
            const youtubeInput = document.querySelector('input[name="video_link"]');
            const defaultDesign = document.getElementById('default-design');
            const previewDesign = document.getElementById('preview-design');
            const previewPlayer = document.getElementById('video-preview-player');
            const videoOptions = document.querySelectorAll('.video-option');
            const uploadContainer = document.getElementById('upload_container');
            const youtubeField = document.getElementById('youtube_field');

            videoOptions.forEach(radio => {
                radio.addEventListener('change', function() {
                    if (this.value === 'upload') {
                        uploadContainer.classList.remove('hidden');
                        youtubeField.classList.add('hidden');
                        youtubeInput.value = '';
                    } else {
                        youtubeField.classList.remove('hidden');
                        uploadContainer.classList.add('hidden');
                        videoInput.value = '';
                        previewPlayer.pause();
                    }
                });
            });

            videoInput.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const fileURL = URL.createObjectURL(file);
                    previewPlayer.src = fileURL;
                    document.getElementById('file-info').innerText = file.name;

                    defaultDesign.classList.add('hidden');
                    previewDesign.classList.remove('hidden');
                    youtubeInput.value = '';
                }
            });

            document.getElementById('change-video').addEventListener('click', function() {
                videoInput.value = '';
                previewPlayer.src = '';
                defaultDesign.classList.remove('hidden');
                previewDesign.classList.add('hidden');
            });
        });
    </script>


    <script>
        document.getElementById('edit-image-input').addEventListener('change', function(event) {
            const wrapper = document.getElementById('new-image-preview-wrapper');
            const files = event.target.files;

            for (let i = 0; i < files.length; i++) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = "relative w-24 h-24 group animate-pulse";
                    div.innerHTML = `
                        <img src="${e.target.result}" class="w-full h-full object-cover rounded-lg border-2 border-blue-400">
                        <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity rounded-lg">
                            <button type="button" class="text-white bg-red-500 rounded-full w-7 h-7 remove-btn">×</button>
                        </div>
                        <span class="absolute -top-2 -left-2 bg-blue-500 text-white text-[9px] px-1.5 rounded-full shadow-md">New</span>
                    `;
                    div.querySelector('.remove-btn').onclick = () => div.remove();
                    wrapper.appendChild(div);
                    setTimeout(() => div.classList.remove('animate-pulse'), 500);
                }
                reader.readAsDataURL(files[i]);
            }
        });

        function deletePermanentImage(imageId) {
            if (confirm('Are you sure? This will delete the image from server!')) {
                $.ajax({
                    url: "{{ url('/admin/product-image') }}/" + imageId + "/delete",
                    type: 'DELETE',
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(res) {
                        $('#img-container-' + imageId).fadeOut(400, function() {
                            $(this).remove();
                        });
                    },
                    error: function() {
                        alert('Error deleting image. Try again.');
                    }
                });
            }
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const productType = document.querySelector('select[name="type"]');
            const variableSection = document.getElementById('variableProductsSection');
            const container = document.getElementById('variableProductsContainer');
            const addBtn = document.getElementById('addVariantBtn');
            let variantIndex = 0;

            function createVariantRow(index = null, oldData = null) {
                variantIndex = index !== null ? index : variantIndex + 1;

                const row = document.createElement('div');
                row.classList.add(
                    'bg-gray-50', 'p-5', 'rounded-lg', 'shadow-sm', 'border',
                    'border-gray-200', 'space-y-4', 'variant-row'
                );

                const attrId = `attribute_${variantIndex}`;
                const valId = `attributeValue_${variantIndex}`;

                row.innerHTML = `
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Attributes</label>
                    <select id="${attrId}" name="variants[${variantIndex}][attribute_ids][]" multiple class="w-full">
                        @foreach ($attributes as $attr)
                            <option value="{{ $attr->id }}">{{ $attr->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Attribute Values</label>
                    <select id="${valId}" name="variants[${variantIndex}][attribute_value_ids][]" multiple class="w-full"></select>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Buy Price</label>
                    <input type="number" name="variants[${variantIndex}][buy_price]" placeholder="Buy Price" value="${oldData?.buy_price ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Old Price</label>
                    <input type="number" name="variants[${variantIndex}][old_price]" placeholder="Old Price" value="${oldData?.old_price ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">New Price</label>
                    <input type="number" name="variants[${variantIndex}][new_price]" placeholder="New Price" value="${oldData?.new_price ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Stock</label>
                    <input type="number" name="variants[${variantIndex}][stock]" placeholder="Stock" value="${oldData?.stock ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}] transition-all duration-200">
                </div>
             <div>
                <label class="block text-sm text-gray-700 mb-1 font-medium">Variant Image</label>
                <input type="file" name="variants[${variantIndex}][image]" accept="image/*" class="w-full rounded-md border border-gray-300 text-gray-900 focus:ring-2 focus:ring-[{{ $theme->theme_bg }}]
           file:bg-indigo-600 file:text-white file:border-0 file:rounded-l file:px-3 file:py-2 file:cursor-pointer
           hover:file:bg-indigo-700 transition-all duration-200">
            </div>
            <div class="w-full">
                <label class="block text-sm text-gray-700 mb-1 font-medium">Variant Close</label>
                <button type="button" class="removeVariantBtn bg-red-500 text-white px-4 py-2 w-full rounded-md hover:bg-red-600 transition">✕ Remove Variant</button>
            </div>
            </div>
        `;

                if (oldData?.id) {
                    const hidden = document.createElement('input');
                    hidden.type = 'hidden';
                    hidden.name = `variants[${variantIndex}][id]`;
                    hidden.value = oldData.id;
                    row.appendChild(hidden);
                }

                container.appendChild(row);

                row.querySelector('.removeVariantBtn').addEventListener('click', () => row.remove());

                const attrSelect = new TomSelect(`#${attrId}`, {
                    plugins: ['remove_button'],
                    placeholder: "Select Attributes",
                    create: false,
                    dropdownParent: 'body',
                });

                const valSelect = new TomSelect(`#${valId}`, {
                    plugins: ['remove_button'],
                    placeholder: "Select Attribute Values",
                    create: false,
                    dropdownParent: 'body',
                });

                if (oldData?.attributes) {
                    const attrIds = oldData.attributes.map(a => a.attribute_id);
                    attrIds.forEach(id => attrSelect.addItem(id));

                    oldData.attributes.forEach(attr => {
                        attr.value_ids.forEach((vId, index) => {
                            valSelect.addOption({
                                value: vId,
                                text: attr.values[index] ?? ''
                            });
                            valSelect.addItem(vId);
                        });
                    });
                }

                attrSelect.on('change', function(values) {
                    if (!values.length) return valSelect.clearOptions();
                    fetch(`/admin/get-attribute-values?ids=${values.join(',')}`)
                        .then(res => res.json())
                        .then(data => {
                            valSelect.clearOptions();
                            Object.keys(data).forEach(group => {
                                data[group].forEach(item => {
                                    valSelect.addOption({
                                        value: item.id,
                                        text: item.value
                                    });
                                });
                            });
                            valSelect.refreshOptions(false);
                        })
                        .catch(err => console.error(err));
                });
            }

            productType.addEventListener('change', () => {
                if (productType.value === "1") {
                    variableSection.style.display = 'block';
                    if (container.children.length === 0) createVariantRow();
                } else {
                    variableSection.style.display = 'none';
                    container.innerHTML = '';
                }
            });

            addBtn.addEventListener('click', () => createVariantRow());

            @if ($product->type == 1 && $variants->count())
                variableSection.style.display = 'block';
                const existingVariants = @json($variants);
                existingVariants.forEach((variant, idx) => createVariantRow(idx, variant));
            @endif

            @if (old('variants'))
                const oldVariants = @json(old('variants'));
                variableSection.style.display = 'block';
                Object.values(oldVariants).forEach(v => createVariantRow(null, v));
            @endif
        });
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const category = document.getElementById('category');
            const subcategory = document.getElementById('subcategory');
            const selectedSubcat = @json(old('subcategory_id', $product->subcategory_id));

            function loadSubcategories(catId, preselect = null) {
                if (!catId) {
                    subcategory.innerHTML = '<option value="">-- Select Subcategory --</option>';
                    return;
                }
                fetch(`/admin/get-subcategories/${catId}`)
                    .then(res => res.json())
                    .then(data => {
                        subcategory.innerHTML = '<option value="">-- Select Subcategory --</option>';
                        data.forEach(sc => {
                            const option = document.createElement('option');
                            option.value = sc.id;
                            option.text = sc.name;
                            if (preselect && preselect == sc.id) option.selected = true;
                            subcategory.add(option);
                        });
                    });
            }

            loadSubcategories(category.value, selectedSubcat);

            category.addEventListener('change', () => {
                loadSubcategories(category.value);
            });
        });
    </script>
@endsection

@push('scripts')
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-lite.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/lang/summernote-en-US.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#productDescription').summernote({
                placeholder: 'Write something...',
                tabsize: 2,
                height: 200,
                toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
@endpush
