@extends('frontend.layouts.master')
@section('title', 'Deals Products')
@section('content')
    <div class="bg-gray-50 py-8 px-4">
        <div class="max-w-6xl mx-auto">

            <div
                class="mb-10 text-center md:text-left flex flex-col md:flex-row md:items-center justify-between gap-6 border-b border-gray-200 pb-8">
                <div class="relative">
                    <div class="absolute -left-4 -top-4 w-20 h-20 bg-orange-200 blur-[40px] opacity-60"></div>

                    <div class="relative z-10">
                        <div
                            class="inline-flex items-center gap-2 bg-orange-100 text-orange-600 px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-widest mb-3">
                            <span class="relative flex h-2 w-2">
                                <span
                                    class="animate-ping absolute inline-flex h-full w-full rounded-full bg-orange-400 opacity-75"></span>
                                <span class="relative inline-flex rounded-full h-2 w-2 bg-orange-500"></span>
                            </span>
                            Flash Sale is Live
                        </div>
                        <h1 class="text-3xl md:text-4xl font-black text-gray-900 leading-none">
                            HOT <span
                                class="text-transparent bg-clip-text bg-gradient-to-r from-orange-500 to-red-600">DEALS</span>
                        </h1>
                        <p class="text-gray-500 text-sm mt-3 font-medium max-w-sm">
                            আপনার পছন্দের পণ্যগুলো এখন বিশেষ ছাড়ে।
                        </p>
                    </div>
                </div>

                <div class="relative z-10 flex flex-col items-center md:items-end gap-3">
                    <span class="text-[11px] font-bold text-gray-400 uppercase tracking-[3px]">Offer Ends In</span>

                    @php $hotDealsDate = $setting->hot_deals ?? null; @endphp
                    @if ($hotDealsDate)
                        <div class="flex items-center gap-3" id="hot-deal-timer" data-end-date="{{ $hotDealsDate }}">
                            <div class="flex flex-col items-center">
                                <div class="relative">
                                    <div id="hours"
                                        class="w-12 h-12 flex items-center justify-center rounded-xl bg-white shadow-sm border border-gray-100 text-gray-800 font-bold text-xl transition-all duration-300">
                                        00</div>
                                    <div
                                        class="absolute -bottom-1 left-1/2 -translate-x-1/2 w-8 h-[2px] bg-orange-400 rounded-full opacity-0 hover:opacity-100">
                                    </div>
                                </div>
                                <span class="text-[9px] font-bold text-gray-400 mt-1 uppercase">Hrs</span>
                            </div>

                            <div class="text-gray-300 font-light text-2xl mb-5">:</div>

                            <div class="flex flex-col items-center">
                                <div class="relative">
                                    <div id="minutes"
                                        class="w-12 h-12 flex items-center justify-center rounded-xl bg-white shadow-sm border border-gray-100 text-gray-800 font-bold text-xl">
                                        00</div>
                                </div>
                                <span class="text-[9px] font-bold text-gray-400 mt-1 uppercase">Min</span>
                            </div>

                            <div class="text-gray-300 font-light text-2xl mb-5">:</div>

                            <div class="flex flex-col items-center">
                                <div class="relative">
                                    <div id="seconds"
                                        class="w-12 h-12 flex items-center justify-center rounded-xl bg-gradient-to-br from-red-500 to-orange-500 shadow-lg shadow-orange-100 text-white font-bold text-xl animate-pulse">
                                        00</div>
                                </div>
                                <span class="text-[9px] font-bold text-gray-400 mt-1 uppercase tracking-tighter">Sec</span>
                            </div>
                        </div>
                    @else
                        <div class="bg-red-50 text-red-500 px-4 py-2 rounded-lg text-sm font-bold flex items-center gap-2">
                            <i class="ri-alarm-warning-line"></i> Limited Time
                        </div>
                    @endif
                </div>
            </div>

            <main>
                <div class="grid grid-cols-2 sm:grid-cols-4 md:grid-cols-5 lg:grid-cols-5 gap-y-8 gap-x-4">
                    @foreach ($products as $product)
                        <div class="transform hover:-translate-y-1 transition-all duration-300">
                            @include('frontend.products.index', ['product' => $product])
                        </div>
                    @endforeach
                </div>

                @if (method_exists($products, 'links'))
                    <div class="mt-16 flex justify-center">
                        <div class="p-2 bg-white rounded-xl shadow-sm border border-gray-100">
                            {{ $products->links() }}
                        </div>
                    </div>
                @endif
            </main>
        </div>
    </div>

    <script>
        function updateTimer() {
            const timerElement = document.getElementById('hot-deal-timer');
            if (!timerElement) return;

            const endDate = new Date(timerElement.getAttribute('data-end-date')).getTime();
            const now = new Date().getTime();
            const distance = endDate - now;

            if (distance < 0) {
                timerElement.innerHTML =
                    "<div class='bg-red-100 text-red-600 px-4 py-1 rounded-full font-bold text-sm uppercase tracking-wider'>Offer Expired</div>";
                return;
            }

            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            document.getElementById('hours').innerText = hours < 10 ? '0' + hours : hours;
            document.getElementById('minutes').innerText = minutes < 10 ? '0' + minutes : minutes;
            document.getElementById('seconds').innerText = seconds < 10 ? '0' + seconds : seconds;
        }

        setInterval(updateTimer, 1000);
        updateTimer();
    </script>
@endsection
