@extends('frontend.layouts.master')
@section('title', 'অর্ডার সম্পন্ন')
@section('content')
    <div class="min-h-screen flex items-center justify-center bg-gray-50 py-5 px-4">
        <div class="bg-white shadow-lg rounded-lg p-8 max-w-xl w-full text-center">
            <div class="text-green-500 text-6xl mb-6">
                <i class="ri-check-line"></i>
            </div>

            <h1 class="text-2xl font-semibold text-gray-800 mb-4">ধন্যবাদ!</h1>

            <p class="text-gray-600 mb-6">
                আপনার অর্ডার সফলভাবে সম্পন্ন হয়েছে। আমরা অর্ডারের বিবরণসহ একটি ইমেইল কনফার্মেশন পাঠিয়েছি।
            </p>

            <div class="bg-gray-50 p-4 rounded-lg mb-6 text-left">
                <p class="text-gray-700 mb-2"><span class="font-medium">অর্ডার আইডি:</span> #{{ request('invoice_id') }}</p>
                <p class="text-gray-700 mb-2"><span class="font-medium">মোট পরিমাণ:</span>
                    ৳{{ number_format(request('amount'), 2) }}</p>
                <p class="text-gray-700 capitalize"><span class="font-medium">পেমেন্ট পদ্ধতি:</span> {{ request('method') }}
                </p>
            </div>

            <div class="flex flex-col gap-3">
                <a href="{{ route('home') }}"
                    class="w-full bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] hover:bg-[{{ $theme->theme_hover }}] font-semibold py-3 rounded-lg transition">
                    <i class="ri-home-5-line mr-1"></i> হোমে ফিরে যান
                </a>
                <a href="https://mail.google.com/mail/u/0/#inbox" target="_blank"
                    class="w-full border border-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_bg }}]/90 font-semibold py-3 rounded-lg transition hover:text-white">
                    <i class="ri-file-list-line mr-1"></i> আমার অর্ডার দেখুন
                </a>
            </div>
        </div>
    </div>

    @if (!empty($order))
        <script>
            (function() {

                var ids = [
                    @foreach ($order->items as $item)
                        '{{ $item->product_id }}',
                    @endforeach
                ];

                var totalItems = {{ $order->items->sum('quantity') }};
                var value = {{ $order->total }};

                if (window.dataLayer) {
                    dataLayer.push({
                        event: 'Purchase',
                        transaction_id: '{{ $order->invoice_id }}',
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product',
                        num_items: totalItems
                    });
                }

                if (typeof fbq === 'function') {
                    fbq('track', 'Purchase', {
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product',
                        num_items: totalItems
                    });
                }

            })();
        </script>
    @endif
@endsection
