@extends('frontend.layouts.master')
@section('title', 'Order Tracking')
@section('content')
    <div class="bg-[#f8fafc] md:py-16 py-8 px-4 min-h-screen">
        <div class="w-full max-w-xl mx-auto">

            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="bg-[{{ $theme->theme_bg }}] p-6 text-center">
                    <h2 class="text-2xl font-bold text-white mb-2">ট্র্যাক করুন আপনার অর্ডার</h2>
                    <p class="text-white/80 text-sm">অর্ডারের সর্বশেষ অবস্থা জানতে আইডি এবং মোবাইল নম্বর দিন</p>
                </div>

                <div class="p-8">
                    @if (session('error'))
                        <div
                            class="flex items-center gap-2 bg-red-50 border-l-4 border-red-500 text-red-700 px-4 py-3 rounded mb-6 animate-pulse">
                            <i class="ri-error-warning-fill"></i>
                            <span class="text-sm font-medium">{{ session('error') }}</span>
                        </div>
                    @endif

                    <form action="{{ route('order.tracking.check') }}" method="POST" class="space-y-5">
                        @csrf

                        <div class="space-y-2">
                            <label for="order_id" class="text-sm font-bold text-gray-700 ml-1">
                                অর্ডার আইডি (Order ID)
                            </label>
                            <div class="relative">
                                <i class="ri-hashtag absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="text" id="order_id" name="order_id" required placeholder="উদা: #12345"
                                    class="w-full pl-11 pr-4 py-3 rounded-xl border border-gray-200 focus:border-[{{ $theme->theme_bg }}] focus:ring-4 focus:ring-[{{ $theme->theme_bg }}]/10 outline-none transition-all">
                            </div>
                        </div>

                        <div class="space-y-2">
                            <label for="phone" class="text-sm font-bold text-gray-700 ml-1">
                                মোবাইল নম্বর (Phone Number)
                            </label>
                            <div class="relative">
                                <i class="ri-phone-line absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="text" id="phone" name="phone" required
                                    placeholder="অর্ডারে ব্যবহৃত মোবাইল নম্বরটি দিন"
                                    class="w-full pl-11 pr-4 py-3 rounded-xl border border-gray-200 focus:border-[{{ $theme->theme_bg }}] focus:ring-4 focus:ring-[{{ $theme->theme_bg }}]/10 outline-none transition-all">
                            </div>
                        </div>

                        <button type="submit"
                            class="w-full bg-[{{ $theme->theme_bg }}] text-white font-bold py-4 rounded-xl shadow-lg shadow-[{{ $theme->theme_bg }}]/20 hover:scale-[1.02] transition-transform active:scale-95 flex items-center justify-center gap-2">
                            <i class="ri-map-pin-user-fill"></i> ট্রাক অর্ডার করুন
                        </button>
                    </form>
                </div>
            </div>

            @if (session('order'))
                @php $order = session('order'); @endphp
                <div class="mt-8 bg-white rounded-2xl shadow-sm border border-gray-100 p-6 animate-fade-in">
                    <div class="flex items-center justify-between mb-6 border-b pb-4">
                        <h3 class="text-lg font-bold text-gray-800">অর্ডারের তথ্য</h3>
                        @php
                            $statusColor = match ($order->order_status) {
                                'pending' => 'bg-amber-100 text-amber-700',
                                'processing' => 'bg-blue-100 text-blue-700 border-blue-200',
                                'shipped' => 'bg-purple-100 text-purple-700',
                                'delivered' => 'bg-green-100 text-green-700',
                                'cancelled' => 'bg-red-100 text-red-700',
                                default => 'bg-gray-100 text-gray-700',
                            };
                        @endphp
                        <span class="px-3 py-1 rounded-full text-xs font-bold uppercase {{ $statusColor }} border">
                            {{ $order->order_status }}
                        </span>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="space-y-4">
                            <div class="flex items-start gap-3">
                                <div class="w-8 h-8 rounded-lg bg-gray-50 flex items-center justify-center text-gray-500">
                                    <i class="ri-file-list-3-line"></i>
                                </div>
                                <div>
                                    <p class="text-[10px] text-gray-400 uppercase font-bold tracking-wider">Invoice ID</p>
                                    <p class="text-gray-800 font-semibold">#{{ $order->invoice_id }}</p>
                                </div>
                            </div>

                            <div class="flex items-start gap-3">
                                <div class="w-8 h-8 rounded-lg bg-gray-50 flex items-center justify-center text-gray-500">
                                    <i class="ri-user-smile-line"></i>
                                </div>
                                <div>
                                    <p class="text-[10px] text-gray-400 uppercase font-bold tracking-wider">Customer</p>
                                    <p class="text-gray-800 font-semibold">{{ $order->shipping->name }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <div class="flex items-start gap-3">
                                <div class="w-8 h-8 rounded-lg bg-gray-50 flex items-center justify-center text-gray-500">
                                    <i class="ri-map-pin-2-line"></i>
                                </div>
                                <div>
                                    <p class="text-[10px] text-gray-400 uppercase font-bold tracking-wider">Shipping Address
                                    </p>
                                    <p class="text-gray-700 text-sm leading-relaxed">{{ $order->shipping->address }}</p>
                                </div>
                            </div>

                            <div class="flex items-start gap-3">
                                <div
                                    class="w-8 h-8 rounded-lg bg-[{{ $theme->theme_bg }}]/10 flex items-center justify-center text-[{{ $theme->theme_bg }}]">
                                    <i class="ri-money-dollar-circle-fill"></i>
                                </div>
                                <div>
                                    <p class="text-[10px] text-gray-400 uppercase font-bold tracking-wider">Total Payable
                                    </p>
                                    <p class="text-xl font-black text-gray-900">৳{{ number_format($order->total) }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-8 pt-6 border-t border-dashed border-gray-200">
                        <div class="flex justify-between items-center px-2">
                            <div class="flex flex-col items-center gap-2">
                                <div class="w-4 h-4 rounded-full bg-green-500 ring-4 ring-green-100"></div>
                                <span class="text-[10px] font-bold text-gray-500">অর্ডার কনফার্ম</span>
                            </div>
                            <div class="flex-1 h-[2px] bg-gray-200 mx-2"></div>
                            <div class="flex flex-col items-center gap-2">
                                <div
                                    class="w-4 h-4 rounded-full {{ in_array($order->order_status, ['processing', 'shipped', 'delivered']) ? 'bg-green-500' : 'bg-gray-200' }}">
                                </div>
                                <span class="text-[10px] font-bold text-gray-500">প্যাকিং হচ্ছে</span>
                            </div>
                            <div class="flex-1 h-[2px] bg-gray-200 mx-2"></div>
                            <div class="flex flex-col items-center gap-2">
                                <div
                                    class="w-4 h-4 rounded-full {{ in_array($order->order_status, ['shipped', 'delivered']) ? 'bg-green-500' : 'bg-gray-200' }}">
                                </div>
                                <span class="text-[10px] font-bold text-gray-500">কুরিয়ারে আছে</span>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection
