<?php

use App\Http\Controllers\Backend\AdminController;
use App\Http\Controllers\Backend\AnalyticsController;
use App\Http\Controllers\Backend\ApiController;
use App\Http\Controllers\Backend\AttributeController;
use App\Http\Controllers\Backend\AttributeValueController;
use App\Http\Controllers\Backend\BannerController;
use App\Http\Controllers\Backend\CategoryController;
use App\Http\Controllers\Backend\CouponController;
use App\Http\Controllers\Backend\CourierController;
use App\Http\Controllers\Backend\FraudController;
use App\Http\Controllers\Backend\IpBlockController;
use App\Http\Controllers\Backend\MediaController;
use App\Http\Controllers\Backend\IncompleteController;
use App\Http\Controllers\Backend\OrderController;
use App\Http\Controllers\Backend\LandingPageController;
use App\Http\Controllers\Backend\PaymentGatewayController;
use App\Http\Controllers\Backend\ProductController;
use App\Http\Controllers\Backend\ReviewController;
use App\Http\Controllers\Backend\SettingController;
use App\Http\Controllers\Backend\SubcategoryController;
use App\Http\Controllers\Backend\ThemeController;
use App\Http\Controllers\Backend\CustomerManageController;
use App\Http\Controllers\Backend\BrandController;
use App\Http\Controllers\Frontend\CartController;
use App\Http\Controllers\Frontend\CheckoutController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\PaymentController;
use App\Http\Controllers\Customer\CustomerController;
use App\Http\Controllers\Customer\GoogleLoginController;
use App\Http\Middleware\ClearBuyNow;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

Route::get('/optimize-clear', function () {
    Artisan::call('optimize:clear');
    return 'Optimize clear successfully!';
});

Route::middleware(['web', ClearBuyNow::class])->group(function () {
    Route::controller(HomeController::class)->group(function () {
        Route::get('/', 'index')->name('home');
        Route::get('/deals', 'deals')->name('deals');
        Route::get('/campaign/{slug}', 'campaign')->name('campaign');
        Route::get('/campaign/order/success', 'campaign_success')->name('campaign.success');
        Route::post('/order/create', 'orderCreate')->name('order.create');
        Route::get('/help-center', 'help')->name('help');
        Route::get('/contact', 'contact')->name('contact');
        Route::get('/privacy-policy', 'policy')->name('policy');
        Route::get('/terms-and-conditions', 'terms')->name('terms');
        Route::get('/your/shop', 'shop')->name('shop');
        Route::get('/product/{slug}', 'product')->name('product.details');
        Route::get('/brand/{slug}', 'brandProduct')->name('brand.product');
        Route::get('/order/success', 'success')->name('order.success');
        Route::get('/order/tracking', 'tracking')->name('order.tracking');
        Route::get('/category/{slug}', 'categoryProduct')->name('category.product');
        Route::get('/subcategory/{slug}', 'subcategoryProduct')->name('subcategory.product');
        Route::get('/search/products', 'search')->name('search.products');
    });
    
    Route::post('/order/incomplete', [IncompleteController::class, 'createIncomplete'])
        ->name('order.incomplete');

    Route::post('/order-tracking-check', [HomeController::class, 'trackCheck'])
        ->name('order.tracking.check');

    Route::post('/payment', [PaymentController::class, 'payment'])->name('payment');
    Route::post('/payment/success', [PaymentController::class, 'paymentSuccess'])->name('payment.success');
    Route::post('/cart/add/{product}', [CartController::class, 'add'])->name('cart.add');
    Route::post('/checkout/buy-now/{product}', [CheckoutController::class, 'buyNow'])->name('checkout.buy-now');
    Route::get('/shipping/cart', [CartController::class, 'index'])->name('cart.index');
    Route::post('/cart/remove/{id}', [CartController::class, 'remove'])->name('cart.remove');
    Route::get('/checkout', [CheckoutController::class, 'index'])->name('checkout.index');
    Route::post('/cart/update/{id}', [CartController::class, 'updateQuantity'])->name('cart.updateQuantity');
});

// Admin Routes
// =======================
Route::prefix('admin')->name('admin.')->middleware(['auth', 'web'])->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/dashboard', 'index')->name('dashboard');
        Route::get('/account', 'account')->name('account');
        Route::post('/account/store', 'accountStore')->name('account.store');
    });
    
    Route::controller(CustomerManageController::class)->group(function () {
        Route::get('/customer', 'index')->name('customer.index');
        Route::delete('/customer/delete/{id}', 'destroy')->name('customer.destroy');
        Route::post('/customer/status/{id}', 'status')->name('customer.status');
    });

    Route::controller(SettingController::class)->group(function () {
        Route::get('/shipping/charge', 'shippingIndex')->name('shipping.index');
        Route::post('/shipping/charge/store', 'shippingStore')->name('shipping.store');
        Route::get('/setting', 'setting')->name('setting');
        Route::post('/setting/store', 'settingStore')->name('setting.store');
    });

    Route::controller(FraudController::class)->group(function () {
        Route::post('/fraud', 'index')->name('fraud.index');
        Route::post('/fraud/store', 'store')->name('fraud.store');
    });

    Route::controller(IpBlockController::class)->group(function () {
        Route::get('/ip-blocked', 'index')->name('ip_block.index');
        Route::delete('/ip-blocked/{id}', 'destroy')->name('ip_block.destroy');
    });

    Route::controller(ThemeController::class)->group(function () {
        Route::get('/main/theme', 'mainIndex')->name('main.theme');
        Route::get('/navbar/theme', 'navbarIndex')->name('navbar.theme');
        Route::post('/main/theme', 'mainUpdate')->name('main.theme.update');
        Route::post('/navbar/theme', 'navbarUpdate')->name('navbar.theme.update');
    });
    
    Route::delete('/product-image/{id}/delete', [ProductController::class, 'deleteImage'])->name('products.deleteImage');

    Route::controller(ProductController::class)->group(function () {
        Route::get('/products/inventory', 'inventory')->name('products.inventory');
        Route::get('/order/products', 'OrderByProduct')->name('order.products');
        Route::post('/products/update-orders', 'updateOrders')->name('products.updateOrders');
        Route::post('/products/{id}/update-stock/{variantId?}', 'updateStock')->name('products.updateStock');
        Route::delete('/products/variant/{id}/destroy', 'destroyVariant')->name('products.variant.destroy');
        Route::get('/products/clone/{id}', 'Clone')->name('products.clone');
    });

    Route::controller(AnalyticsController::class)->group(function () {
        Route::get('/analytics/gtm', 'AnalyticsGTM')->name('analytics.gtm');
        Route::post('/analytics/gtm', 'AnalyticsGTMStore')->name('analytics.gtm.store');
        Route::get('/analytics/pixel', 'AnalyticsPixel')->name('analytics.pixel');
        Route::post('/analytics/pixel', 'AnalyticsPixelStore')->name('analytics.pixel.store');
    });

    Route::controller(OrderController::class)->group(function () {
        Route::get('/orders/report', 'report')->name('orders.report');
        Route::get('/orders/loss-profit', 'lossProfit')->name('loss.profit');
        Route::get('/orders/incomplete', 'incomplete')->name('orders.incomplete');
        Route::get('/orders/pending', 'pending')->name('orders.pending');
        Route::get('/orders/confirmed', 'confirmed')->name('orders.confirmed');
        Route::get('/orders/ready', 'ready')->name('orders.ready');
        Route::get('/orders/shipped', 'shipped')->name('orders.shipped');
        Route::get('/orders/delivered', 'delivered')->name('orders.delivered');
        Route::get('/orders/cancelled', 'cancelled')->name('orders.cancelled');
        Route::get('/orders/refunded', 'refunded')->name('orders.refunded');
        Route::get('/orders/show/{id}', 'show')->name('orders.show');
        Route::post('/orders/invoice', 'invoice')->name('orders.invoice');
        Route::get('/orders/edit/{id}', 'edit')->name('orders.edit');
        Route::post('/orders/destroy/', 'destroy')->name('orders.destroy');
        Route::post('/orders/status/', 'status')->name('orders.status');
        Route::post('/orders/redx/', 'redx')->name('orders.redx');
        Route::post('/orders/steadFast/', 'steadFast')->name('orders.steadFast');
        Route::put('/orders/update/{id}', 'update')->name('orders.update');
    });
    
    Route::resource('brands', BrandController::class);
    Route::resource('categories', CategoryController::class);
    Route::resource('subcategories', SubcategoryController::class);
    Route::resource('products', ProductController::class);
    Route::resource('orders', OrderController::class);
    Route::resource('coupons', CouponController::class);
    Route::resource('attribute_values', AttributeValueController::class);
    Route::resource('attributes', AttributeController::class);
    Route::resource('banners', BannerController::class);
    Route::resource('reviews', ReviewController::class);
    Route::resource('social_media', MediaController::class);
    Route::resource('payment_gateways', PaymentGatewayController::class);
    Route::resource('sms_email_api', ApiController::class);
    Route::resource('courier', CourierController::class);
    Route::resource('landing', LandingPageController::class);


    Route::get('/get-subcategories/{category_id}', [ProductController::class, 'getSubcategories'])->name('get.subcategories');
    Route::get('/get-attribute-values', [ProductController::class, 'getAttributeValuesMultiple'])->name('get.attribute.values.multiple');
});

Route::prefix('customer')->group(function () {

    Route::get('login', [CustomerController::class, 'loginForm'])->name('customer.login');
    Route::post('login', [CustomerController::class, 'login']);
    Route::get('register', [CustomerController::class, 'registerForm'])->name('customer.register');
    Route::post('register', [CustomerController::class, 'registerStore'])->name('customer.register.store');
    
    Route::get('forget-password', [CustomerController::class, 'showForgetForm'])->name('customer.forget');
    Route::post('forget-password', [CustomerController::class, 'sendOtp'])->name('customer.send-otp');

    Route::get('verify-otp', [CustomerController::class, 'showOtpForm'])->name('customer.verify-otp');
    Route::post('verify-otp', [CustomerController::class, 'verifyOtp'])->name('customer.verify-otp.post');

    Route::get('reset-password', [CustomerController::class, 'showResetForm'])->name('customer.reset-password');
    Route::post('reset-password', [CustomerController::class, 'resetPassword'])->name('customer.reset-password.post');
    
    Route::post('review', [CustomerController::class, 'review'])->name('customer.review');
    
    Route::put('orders/cancel/{id}', [CustomerController::class, 'ordersCancel'])->name('customer.orders.cancel');


    Route::middleware('customer.auth')->group(function () {
        Route::post('logout', [CustomerController::class, 'logout'])->name('customer.logout');
        Route::get('orders', [CustomerController::class, 'orders'])->name('customer.orders');
        Route::get('dashboard', [CustomerController::class, 'dashboard'])->name('customer.dashboard');
        Route::get('/customer/orders/{id}', [CustomerController::class, 'show'])->name('customer.order.view');
        Route::put('/customer/dashboard', [CustomerController::class, 'updateAccount'])->name('customer.account.update')->middleware('auth:customer');

    });
});

Route::get('reject/{token}', [AdminController::class, 'reject'])->name('domain.reject');

Route::get('auth/google', [GoogleLoginController::class, 'redirectToGoogle']);

Route::get('google/callback', [GoogleLoginController::class, 'handleCallback']);

Route::post('/set-shipping-charge', function (\Illuminate\Http\Request $request) {
    session([
        'shippingCharge' => $request->charge,
        'shippingArea' => $request->area,
    ]);

    return response()->json(['status' => 'success']);
})->name('set.shipping.charge');

require __DIR__.'/auth.php';
