
<?php $__env->startSection('title', 'Order #'.$order->id); ?>
<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto my-8 px-4 md:px-6 lg:px-0">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold text-gray-800">Order #<?php echo e($order->id); ?></h2>
        
        <?php if($order->order_status == 'pending'): ?>
            <form action="<?php echo e(route('customer.orders.cancel', $order->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to cancel this order?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <button type="submit" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg font-semibold transition-all shadow-md active:scale-95">
                    Cancel Order
                </button>
            </form>
        <?php endif; ?>
    </div>

    <div class="bg-gradient-to-r from-blue-100 to-blue-200 shadow-lg rounded-lg p-6 mb-6 border-l-4 border-blue-500">
        <div class="flex flex-wrap justify-between items-start gap-4">
            <div>
                <p class="mb-2"><strong>Status:</strong>
                    <?php
                        $statusColors = [
                            'pending' => 'yellow',
                            'confirmed' => 'blue',
                            'Ready to Ship' => 'purple',
                            'shipped' => 'indigo',
                            'delivered' => 'green',
                            'cancelled' => 'red',
                            'refunded' => 'gray',
                        ];
                        $color = $statusColors[$order->order_status] ?? 'gray';
                    ?>
                    <span class="bg-<?php echo e($color); ?>-100 text-<?php echo e($color); ?>-800 px-3 py-1 rounded-full text-sm font-semibold">
                        <?php echo e(ucfirst($order->order_status)); ?>

                    </span>
                </p>
                <p class="mb-2"><strong>Date:</strong> <?php echo e($order->created_at->format('d M Y, h:i A')); ?></p>
            </div>
            
            <div class="text-sm">
                <p class="mb-1 font-semibold text-blue-800">Shipping Information:</p>
                <ul class="text-gray-700 space-y-1">
                    <li><strong>Name:</strong> <?php echo e($order->shipping->name); ?></li>
                    <li><strong>Phone:</strong> <?php echo e($order->shipping->phone); ?></li>
                    <li><strong>Address:</strong> <?php echo e($order->shipping->address); ?>, <?php echo e($order->shipping->city ?? 'N/A'); ?></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="bg-white shadow-lg rounded-lg p-6 mb-6">
        <h3 class="text-xl font-semibold mb-4 text-gray-800 border-b pb-2">Items Ordered</h3>
        <div class="overflow-x-auto">
            <table class="w-full table-auto text-left">
                <thead class="bg-gray-50 text-gray-600 uppercase text-xs">
                    <tr>
                        <th class="px-4 py-3">Image</th>
                        <th class="px-4 py-3">Product</th>
                        <th class="px-4 py-3">Qty</th>
                        <th class="px-4 py-3 text-right">Price</th>
                        <th class="px-4 py-3 text-right">Subtotal</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-4 py-3">
                            <?php if($item->product_image): ?>
                                <img src="<?php echo e($item->product_image); ?>" class="w-12 h-12 object-cover rounded-md border" alt="<?php echo e($item->product->name); ?>">
                            <?php else: ?>
                                <div class="w-12 h-12 bg-gray-100 rounded-md flex items-center justify-center text-[10px] text-gray-400">No Image</div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3">
                           <a href="<?php echo e(route('product.details', $item->product->slug)); ?>" class="text-gray-800 font-medium text-sm hover:text-blue-600 hover:underline transition-all">
                <?php echo e($item->product_name); ?>

            </a>
                        </td>
                        <td class="px-4 py-3 text-gray-600"><?php echo e($item->quantity); ?></td>
                        <td class="px-4 py-3 text-right text-gray-600">&#2547;<?php echo e(number_format($item->price, 2)); ?></td>
                        <td class="px-4 py-3 text-right font-semibold text-gray-900">&#2547;<?php echo e(number_format($item->price * $item->quantity, 2)); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="mt-8 border-t pt-6 flex justify-end">
            <div class="w-full md:w-64 space-y-2 text-sm text-gray-600">
                <div class="flex justify-between">
                    <span>Subtotal:</span>
                    <span>&#2547;<?php echo e(number_format($subtotal, 2)); ?></span>
                </div>
                <div class="flex justify-between">
                    <span>Shipping:</span>
                    <span>+ &#2547;<?php echo e(number_format($order->shipping_charge, 2)); ?></span>
                </div>
                <div class="flex justify-between text-red-500">
                    <span>Discount:</span>
                    <span>- &#2547;<?php echo e(number_format($order->discount, 2)); ?></span>
                </div>
                <div class="flex justify-between text-lg font-bold text-gray-900 border-t pt-2">
                    <span>Total:</span>
                    <span>&#2547;<?php echo e(number_format($total, 2)); ?></span>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/customer/order-view.blade.php ENDPATH**/ ?>