
<?php $__env->startSection('title', 'Edit Social Media'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Edit Social Media</h2>

                <!-- Small Screen Button -->
                <a href="<?php echo e(route('admin.social_media.index')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-sm font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    All Social Media
                </a>
            </div>

            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Home</a> /
                    <a href="<?php echo e(route('admin.social_media.index')); ?>"
                        class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Social Media</a>
                    /
                    Edit
                </p>

                <!-- Large Screen Button -->
                <a href="<?php echo e(route('admin.social_media.index')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    All Social Media
                </a>
            </div>
        </div>

        <!-- Form -->
        <div class="w-full bg-white rounded shadow px-6 py-6">
            <form action="<?php echo e(route('admin.social_media.update', $social->id)); ?>" method="POST"
                class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-5 md:gap-6">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- Social Media Name -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">
                        Social Media Name <span class="text-red-500">*</span>
                    </label>
                    <?php
                        $mediaList = [
                            'Facebook',
                            'Twitter',
                            'WhatsApp API',
                            'Instagram',
                            'LinkedIn',
                            'YouTube',
                            'Pinterest',
                        ];
                    ?>
                    <select name="name"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 py-[11px] focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] outline-none transition-all border-gray-300"
                        required>
                        <option value="">-- Select Social Media --</option>
                        <?php $__currentLoopData = $mediaList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($media); ?>"
                                <?php echo e(old('name', $social->name) == $media ? 'selected' : ''); ?>>
                                <?php echo e($media); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Social Media Link -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Link <span
                            class="text-red-500">*</span></label>
                    <input type="url" name="link" placeholder="Enter social media URL"
                        value="<?php echo e(old('link', $social->link)); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 py-2 focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] outline-none transition-all border-gray-300"
                        required>
                </div>

                <!-- Status -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Status</label>
                    <select name="status"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 py-[11px] focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] outline-none transition-all border-gray-300">
                        <option value="1" <?php echo e(old('status', $social->status) == 1 ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status', $social->status) == 0 ? 'selected' : ''); ?>>Inactive
                        </option>
                    </select>
                </div>

                <!-- Submit Button -->
                <div class="col-span-2 mt-3">
                    <button type="submit"
                        class="w-full rounded-md bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] py-2.5 transition-all duration-200">
                        Update Social Media
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/backend/setting/social/edit.blade.php ENDPATH**/ ?>