
<?php $__env->startSection('title', 'My Account'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">
    <h2 class="text-3xl font-bold mb-6 text-gray-800">My Account</h2>

    <div class="bg-white shadow rounded-lg overflow-hidden">
        <!-- Profile Header -->
        <div class="bg-[<?php echo e($theme->theme_bg); ?>] text-white p-6 flex items-center space-x-6">
            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRnTOFgWFerb3xv-p6z6bo26mN_rwZFu1eQFA&s" 
                 alt="Profile" class="w-24 h-24 rounded-full border-4 border-white object-cover">
            <div class="space-y-1">
                <h3 class="text-2xl font-semibold"><?php echo e(Auth::guard('customer')->user()->name); ?></h3>
                <p class="text-sm opacity-90"><?php echo e(Auth::guard('customer')->user()->email); ?></p>
                <p class="text-sm opacity-90">Joined: <?php echo e(Auth::guard('customer')->user()->created_at->format('d M Y')); ?></p>
            </div>
        </div>

        <!-- Tabs -->
        <div class="border-b border-gray-200">
            <nav class="-mb-px flex space-x-8 px-6" aria-label="Tabs">
                <a href="#view-data" class="tab-link text-gray-600 whitespace-nowrap py-4 px-1 border-b-2 border-[<?php echo e($theme->theme_bg); ?>] font-medium text-sm">
                    View Data
                </a>
                <a href="#edit-data" class="tab-link text-gray-600 whitespace-nowrap py-4 px-1 border-b-2 border-transparent hover:border-[<?php echo e($theme->theme_bg); ?>] font-medium text-sm">
                    Edit Data
                </a>
            </nav>
        </div>

        <!-- Tab Contents -->
        <div class="p-6">
            <!-- View Data -->
            <div id="view-data" class="tab-content">
                <div class="w-full">
                    <div class="bg-gray-50 p-4 rounded-lg shadow-sm space-y-2.5">
                        <p><strong>Name:</strong> <?php echo e(Auth::guard('customer')->user()->name); ?></p>
                        <p><strong>Email:</strong> <?php echo e(Auth::guard('customer')->user()->email); ?></p>
                        <p><strong>Phone:</strong> +88<?php echo e(Auth::guard('customer')->user()->phone); ?></p>
                        <p><strong>Address:</strong> <?php echo e(Auth::guard('customer')->user()->address); ?></p>
                        <p><strong>Joined:</strong> <?php echo e(Auth::guard('customer')->user()->created_at->format('d M Y')); ?></p>
                    </div>
                </div>
            </div>

            <!-- Edit Data -->
            <div id="edit-data" class="tab-content hidden">
                <?php if(session('success')): ?>
                    <div class="mb-4 text-sm text-green-700 bg-green-100 border border-green-200 rounded p-3">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session('error')): ?>
                    <div class="mb-4 text-sm text-red-700 bg-red-100 border border-red-200 rounded p-3">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('customer.account.update')); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <h4 class="text-lg font-semibold mb-2 text-gray-800">Personal Information</h4>
                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Name</label>
                        <input type="text" name="name" value="<?php echo e(Auth::guard('customer')->user()->name); ?>" required
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Email</label>
                        <input type="email" name="email" value="<?php echo e(Auth::guard('customer')->user()->email); ?>" required
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition">
                    </div>
                    
                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Address</label>
                        <input type="text" name="address" value="<?php echo e(Auth::guard('customer')->user()->address); ?>" required
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition" placeholder="Enter your address">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Phone</label>
                        <input type="text" name="phone" value="<?php echo e(Auth::guard('customer')->user()->phone); ?>" required
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition">
                    </div>

                    <hr class="my-4">

                    <h4 class="text-lg font-semibold mb-2 text-gray-800">Change Password</h4>
                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Old Password</label>
                        <input type="password" name="current_password"
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">New Password</label>
                        <input type="password" name="new_password"
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Confirm New Password</label>
                        <input type="password" name="new_password_confirmation"
                            class="w-full border rounded-lg px-4 py-2 focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 outline-none transition">
                    </div>

                    <button type="submit"
                        class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-medium py-3 rounded-lg transition">
                        Update Account
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Tab JS -->
<script>
    const tabs = document.querySelectorAll('.tab-link');
    const contents = document.querySelectorAll('.tab-content');

    tabs.forEach((tab, index) => {
        tab.addEventListener('click', function(e) {
            e.preventDefault();
            tabs.forEach(t => t.classList.remove('border-indigo-600','text-indigo-600'));
            tabs.forEach(t => t.classList.add('border-transparent','text-gray-600'));
            tab.classList.add('border-indigo-600','text-indigo-600');

            contents.forEach(c => c.classList.add('hidden'));
            contents[index].classList.remove('hidden');
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/customer/account.blade.php ENDPATH**/ ?>