<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .invoice-box {
            page-break-inside: avoid;
            break-inside: avoid;
        }

        @media print {

            @page{
                margin:0;
                padding:0;
                size:a4;
            }

            html,
            body {
                margin: 0 !important;
                padding: 0 !important;
                background: #fff !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .no-print {
                display: none;
            }

            .page-break {
                page-break-after: always !important;
            }
        }
    </style>
</head>

<?php
    $logo = $setting->icon;
?>

<body class="bg-gray-100 text-gray-800 print-m-0">

    <div class="no-print text-center fixed right-8 bottom-8">
        <button onclick="window.print()"
            class="px-4 py-2 bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  rounded hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">Print Invoice</button>
    </div>

    <?php
        $count = 0;
    ?>

    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $count++; ?>

        <div class="max-w-3xl mx-auto bg-white p-6 my-6 invoice-box">

            <div class="flex flex-row justify-between mb-6">
                <div class="w-1/2">
                    <img src="<?php echo e(asset('public/' . $logo)); ?>" alt="Logo" class="w-32 mb-4">

                    <p class="text-sm"><strong>Payment:</strong>
                        <?php echo e($order->payment->payment_method ?? 'Cash on Delivery'); ?></p>
                    <p class="text-sm"><strong>From:</strong> <?php echo e($setting->name); ?></p>
                    <p class="text-sm"><?php echo e($setting->phone); ?></p>
                    <p class="text-sm"><?php echo e($setting->email); ?></p>
                    <p class="text-sm"><?php echo e($setting->address); ?></p>
                </div>

                <div class="w-1/2 text-right">
                    <div class="inline-block text-white font-bold w-full text-right"
                        style="background-color: #4DBC60; transform: skew(32deg); padding: 10px;">
                        <span style="display: inline-block; transform: skew(-32deg);">
                            Invoice #<?php echo e($order->id); ?>

                        </span>
                    </div>

                    <div class="mt-4 text-sm">
                        <p><strong>Date:</strong> <?php echo e($order->created_at->format('d/m/Y')); ?></p>
                        <p><strong>Name:</strong> <?php echo e($order->shipping->name); ?></p>
                        <p><?php echo e($order->shipping->phone); ?></p>
                        <p><?php echo e($order->shipping->address); ?></p>
                    </div>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full border border-gray-200 divide-y divide-gray-200 text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-4 py-2 text-left font-medium text-gray-700">Product</th>
                            <th class="px-4 py-2 text-left font-medium text-gray-700">Qty</th>
                            <th class="px-4 py-2 text-left font-medium text-gray-700">Price</th>
                            <th class="px-4 py-2 text-left font-medium text-gray-700 whitespace-nowrap">Total Amt.</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">

                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-4 py-2 font-medium text-gray-800">
                                    <div class="flex items-center gap-2">
                                        <img src="<?php echo e($item->product_image); ?>" class="h-12 w-12 rounded-full">
                                        <div class="flex flex-col">
                                            <span
                                                class="text-sm text-gray-700 line-clamp-1 mb-0.5"><?php echo e($item->product->name); ?></span>
                                            <span class="text-sm text-gray-700">
                                                <?php
                                                    $json = str_replace('\"', '"', $item->attributes);
                                                    $attributes = json_decode($json, true);
                                                ?>

                                                <?php if($attributes && is_array($attributes)): ?>
                                                    <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="mr-2"><strong
                                                                class="font-normal"><?php echo e($key); ?>:</strong>
                                                            <?php echo e($value); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    Default
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-4 py-2"><?php echo e($item->quantity); ?></td>
                                <td class="px-4 py-2">৳<?php echo e($item->price); ?></td>
                                <td class="px-4 py-2 font-medium">
                                    ৳<?php echo e(number_format($item->price * $item->quantity, 0)); ?>.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr class="bg-gray-50 font-medium">
                            <td class="px-4 py-2" colspan="3">Subtotal</td>
                            <td class="px-4 py-2">৳<?php echo e($order->total); ?>,00</td>
                        </tr>
                        <tr class="font-medium">
                            <td class="px-4 py-2" colspan="3">Shipping(+)</td>
                            <td class="px-4 py-2">৳<?php echo e($order->shipping_charge); ?>,00</td>
                        </tr>
                        <?php if($order->discount > 0): ?>
                            <tr class="font-medium">
                                <td class="px-4 py-2" colspan="3">Discount(-)</td>
                                <td class="px-4 py-2">৳<?php echo e($order->discount); ?>,00</td>
                            </tr>
                        <?php endif; ?>

                        <tr class="bg-[#4DBC60] text-white text-lg font-medium">
                            <td class="px-4 py-2" colspan="3">Grand Total</td>
                            <td class="px-4 py-2">৳<?php echo e($order->total); ?>,00</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($count % 2 == 0): ?>
            <div class="page-break"></div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>

</html>
<?php /**PATH /home/mojibor1/public_html/resources/views/backend/order/invoice.blade.php ENDPATH**/ ?>