
<?php $__env->startSection('title', 'Add New Product'); ?>
<?php $__env->startSection('content'); ?>
    <link href="https://cdn.jsdelivr.net/npm/tom-select/dist/css/tom-select.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/fsx8l20fj4nn5mesnxt5ddhbf0yrj7q6kz5ph1i042r9p7ub/tinymce/8/tinymce.min.js"
        referrerpolicy="origin" crossorigin="anonymous"></script>
    <style>
        .ts-control {
            border: 1px solid #d0d0d0;
            padding: 11px 12px;
            width: 100%;
            overflow: hidden;
            position: relative;
            z-index: 1;
            box-sizing: border-box;
            box-shadow: none;
            border-radius: 6px;
            display: flex;
            flex-wrap: wrap;
        }
    </style>

    <div class="w-full h-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Add Products</h2>
                <a href="<?php echo e(route('admin.products.index')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] px-4 py-2 rounded text-sm font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    All Products
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Home</a>
                    / Product /
                    Create
                </p>
                <a href="<?php echo e(route('admin.products.index')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] px-4 py-2 rounded text-base font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    All Products
                </a>
            </div>
        </div>

        <!-- Form -->
        <div class="w-full bg-white rounded shadow px-6 py-6">
            <form id="productForm" action="<?php echo e(route('admin.products.store')); ?>" method="POST"
                enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-5 md:gap-6">
                <?php echo csrf_field(); ?>

                <!-- Product Name -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Name</label>
                    <input type="text" name="name" placeholder="Product Name" id="productName"
                        value="<?php echo e(old('name')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <!-- Product Description -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Description</label>
                    <textarea id="productDescription" name="description"
                        class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm sm:text-base"><?php echo e(old('description')); ?></textarea>
                </div>


                <!-- SKU -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">SKU</label>
                    <input type="text" name="sku" placeholder="SKU" value="<?php echo e(old('sku')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <!-- Brand -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Brand Name</label>
                    <input type="text" name="brand" placeholder="Brand Name" value="<?php echo e(old('brand')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <!-- Stock -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Stock</label>
                    <input type="number" name="stock" placeholder="Stock" value="<?php echo e(old('stock')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <!-- Category -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Select Category</label>
                    <select name="category_id" id="category" required
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Category --</option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>"
                                <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                <?php echo e($category->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Subcategory -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Select Subcategory</label>
                    <select name="subcategory_id" id="subcategory"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Subcategory --</option>
                        <?php if(old('subcategory_id') && old('category_id')): ?>
                            <?php
                                $subcats = \App\Models\Subcategory::where('category_id', old('category_id'))->get();
                            ?>
                            <?php $__currentLoopData = $subcats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sc->id); ?>"
                                    <?php echo e(old('subcategory_id') == $sc->id ? 'selected' : ''); ?>>
                                    <?php echo e($sc->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>

                <!-- Buy Price -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Buy Price</label>
                    <input type="number" name="buy_price" placeholder="Enter Buy Price" value="<?php echo e(old('buy_price')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <!-- Old Price -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Old Price</label>
                    <input type="number" name="old_price" placeholder="Enter Old Price" value="<?php echo e(old('old_price')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <!-- New Price -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">New Price</label>
                    <input type="number" name="new_price" placeholder="Enter New Price" value="<?php echo e(old('new_price')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>

                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-2 font-medium">Product Images <span
                            class="text-red-500">*</span></label>

                    <div class="flex flex-wrap gap-4 p-4 bg-gray-50 rounded-lg border border-dashed border-gray-300"
                        id="image-container">
                        <div id="image-preview-wrapper" class="flex flex-wrap gap-4"></div>

                        <div
                            class="relative w-24 h-24 flex items-center justify-center border-2 border-dashed border-gray-300 rounded-lg hover:border-[<?php echo e($theme->theme_bg); ?>] hover:bg-gray-100 transition-all cursor-pointer group">
                            <input type="file" name="image[]" id="image-input" accept="image/*" multiple
                                class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-10">

                            <div class="text-center">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="h-10 w-10 text-gray-400 group-hover:text-[<?php echo e($theme->theme_bg); ?>] mx-auto"
                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 4v16m8-8H4" />
                                </svg>
                            </div>
                        </div>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">You can select multiple images. Click the '+' box to add more.
                    </p>
                </div>

                <div class="col-span-2 mt-4">
                    <label class="block text-md text-gray-700 mb-2 font-medium">Product Video</label>

                    <div class="flex gap-6 mb-4">
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="radio" name="video_type" value="upload" checked
                                class="video-option w-4 h-4 text-orange-500 focus:ring-orange-500">
                            <span class="text-sm text-gray-600">Upload Video</span>
                        </label>
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="radio" name="video_type" value="youtube"
                                class="video-option w-4 h-4 text-orange-500 focus:ring-orange-500">
                            <span class="text-sm text-gray-600">Youtube Link</span>
                        </label>
                    </div>

                    <div id="upload_container"
                        class="video-field-wrapper w-full bg-[#f8faff] rounded-xl p-6 border-2 border-dashed border-gray-200">

                        <div id="default-design" class="flex flex-col items-center justify-center py-4 cursor-pointer"
                            onclick="document.getElementById('video_input').click()">
                            <div class="w-16 h-16 bg-white rounded-full flex items-center justify-center shadow-sm mb-3">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-500" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                                </svg>
                            </div>
                            <p class="text-sm font-medium text-gray-700">Click to upload product video</p>
                            <p class="text-xs text-gray-400 mt-1">MP4, MOV up to 110MB</p>
                        </div>

                        <div id="preview-design" class="hidden flex flex-col md:flex-row items-center gap-5">
                            <div class="relative w-full md:w-48 h-32 bg-black rounded-lg overflow-hidden shadow-lg">
                                <video id="video-preview-player" class="w-full h-full object-cover" controls></video>
                            </div>
                            <div class="flex-1">
                                <p id="file-info" class="text-sm font-mono text-blue-600 font-bold truncate mb-1"></p>
                                <p class="text-xs text-gray-400 uppercase tracking-widest" id="file-size"></p>
                                <button type="button" id="remove-video-btn"
                                    class="mt-3 text-xs bg-red-50 text-red-500 px-3 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition">
                                    Remove Video
                                </button>
                            </div>
                        </div>

                        <input type="file" name="video_file" id="video_input" accept="video/*" class="hidden">
                    </div>

                    <div id="youtube_field" class="video-field-wrapper hidden mt-2">
                        <input type="url" name="video_url" placeholder="Enter Youtube URL here..."
                            class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5 text-sm sm:text-base outline-none focus:ring-2 focus:ring-orange-500 border-gray-300">
                    </div>
                </div>

                <!-- Status -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Status</label>
                    <select name="status"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="1" <?php echo e(old('status', '1') == '1' ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status') == '0' ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>

                <!-- Product Type -->
                <div class="col-span-2 md:col-span-1">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Type</label>
                    <select name="type"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="0" <?php echo e(old('type') == 0 ? 'selected' : ''); ?>>Normal</option>
                        <option value="1" <?php echo e(old('type') == 1 ? 'selected' : ''); ?>>Variable</option>
                    </select>
                </div>

                <!-- Hot Deals -->
                <div class="col-span-2 md:col-span-2">
                    <label class="block text-md text-gray-700 mb-1 font-medium"><i
                            class="ri-fire-fill text-orange-500"></i> Hot Deals</label>
                    <select name="hot_deal"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="1" <?php echo e(old('hot_deal', '1') == '1' ? 'selected' : ''); ?>>On</option>
                        <option value="0" <?php echo e(old('hot_deal') == '0' ? 'selected' : ''); ?>>Off</option>
                    </select>
                </div>

                <!-- Variable Products Section -->
                <div class="col-span-2" id="variableProductsSection" style="display: none;">
                    <label class="block text-md text-gray-700 mb-1 font-medium">Product Variants</label>
                    <div id="variableProductsContainer" class="flex flex-col gap-3"></div>
                    <button type="button" id="addVariantBtn"
                        class="mt-2 px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 transition">
                        + Add Variant
                    </button>
                </div>

                <!-- Submit -->
                <div class="col-span-2 mt-4">
                    <button type="submit"
                        class="w-full rounded-md bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] py-2.5 text-base transition-all duration-200">
                        Create Product
                    </button>
                </div>
            </form>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const videoOptions = document.querySelectorAll('.video-option');
            const uploadContainer = document.getElementById('upload_container');
            const youtubeField = document.getElementById('youtube_field');
            const videoInput = document.getElementById('video_input');
            const defaultDesign = document.getElementById('default-design');
            const previewDesign = document.getElementById('preview-design');
            const previewPlayer = document.getElementById('video-preview-player');
            const fileInfo = document.getElementById('file-info');
            const fileSize = document.getElementById('file-size');
            const removeBtn = document.getElementById('remove-video-btn');

            videoOptions.forEach(option => {
                option.addEventListener('change', function() {
                    if (this.value === 'upload') {
                        uploadContainer.classList.remove('hidden');
                        youtubeField.classList.add('hidden');
                    } else {
                        youtubeField.classList.remove('hidden');
                        uploadContainer.classList.add('hidden');
                        videoInput.value = '';
                        resetPreview();
                    }
                });
            });

            videoInput.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        previewPlayer.src = e.target.result;
                        fileInfo.textContent = file.name;
                        fileSize.textContent = (file.size / (1024 * 1024)).toFixed(2) + ' MB';

                        defaultDesign.classList.add('hidden');
                        previewDesign.classList.remove('hidden');
                    };
                    reader.readAsDataURL(file);
                }
            });

            removeBtn.addEventListener('click', function() {
                resetPreview();
            });

            function resetPreview() {
                videoInput.value = '';
                previewPlayer.src = '';
                defaultDesign.classList.remove('hidden');
                previewDesign.classList.add('hidden');
            }
        });
    </script>


    <script>
        const dt = new DataTransfer();

        document.getElementById('image-input').addEventListener('change', function(event) {
            const previewWrapper = document.getElementById('image-preview-wrapper');
            const files = event.target.files;

            for (let i = 0; i < files.length; i++) {
                const file = files[i];

                dt.items.add(file);

                const reader = new FileReader();
                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = "relative w-24 h-24 group preview-item";

                    const fileIndex = dt.items.length - 1;

                    div.innerHTML = `
                    <img src="${e.target.result}" class="w-full h-full object-cover rounded-lg border shadow-sm">
                    <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity rounded-lg">
                        <button type="button" class="text-white bg-red-500 rounded-full p-1 hover:bg-red-600 transition remove-img" data-index="${fileIndex}">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                `;

                    div.querySelector('.remove-img').addEventListener('click', function() {
                        const indexToRemove = this.getAttribute('data-index');
                        div.remove();
                    });

                    previewWrapper.appendChild(div);
                }
                reader.readAsDataURL(file);
            }

            this.files = dt.files;
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const productType = document.querySelector('select[name="type"]');
            const variableSection = document.getElementById('variableProductsSection');
            const container = document.getElementById('variableProductsContainer');
            const addBtn = document.getElementById('addVariantBtn');
            let variantIndex = 0;

            function createVariantRow(index = null, oldData = null) {
                variantIndex = index !== null ? index : variantIndex + 1;
                const row = document.createElement('div');
                row.classList.add('bg-gray-50', 'p-5', 'rounded-lg', 'shadow-sm', 'border', 'border-gray-200',
                    'space-y-4', 'variant-row');

                const attrId = `attribute_${variantIndex}`;
                const valId = `attributeValue_${variantIndex}`;

                row.innerHTML = `
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Attributes</label>
                    <select id="${attrId}" name="variants[${variantIndex}][attribute_ids][]" multiple class="w-full">
                        <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($attr->id); ?>"><?php echo e($attr->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Attribute Values</label>
                    <select id="${valId}" name="variants[${variantIndex}][attribute_value_ids][]" multiple class="w-full"></select>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Buy Price</label>
                    <input type="number" name="variants[${variantIndex}][buy_price]" placeholder="Buy Price" value="${oldData?.buy_price ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Old Price</label>
                    <input type="number" name="variants[${variantIndex}][old_price]" placeholder="Old Price" value="${oldData?.old_price ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">New Price</label>
                    <input type="number" name="variants[${variantIndex}][new_price]" placeholder="New Price" value="${oldData?.new_price ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm text-gray-700 mb-1 font-medium">Stock</label>
                    <input type="number" name="variants[${variantIndex}][stock]" placeholder="Stock" value="${oldData?.stock ?? ''}" class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                </div>
             <div>
                <label class="block text-sm text-gray-700 mb-1 font-medium">Variant Image</label>
                <input type="file" name="variants[${variantIndex}][image]" accept="image/*" class="w-full rounded-md border border-gray-300 text-gray-900 focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]
           file:bg-indigo-600 file:text-white file:border-0 file:rounded-l file:px-3 file:py-2 file:cursor-pointer
           hover:file:bg-indigo-700 transition-all duration-200">
            </div>
            <div class="w-full">
                <label class="block text-sm text-gray-700 mb-1 font-medium">Variant Close</label>
                <button type="button" class="removeVariantBtn bg-red-500 text-white px-4 py-2 w-full rounded-md hover:bg-red-600 transition">✕ Remove Variant</button>
            </div>
            </div>
        `;

                container.appendChild(row);

                row.querySelector('.removeVariantBtn').addEventListener('click', () => row.remove());

                const attrSelect = new TomSelect(`#${attrId}`, {
                    plugins: ['remove_button'],
                    placeholder: "Select Attributes",
                    create: false,
                    dropdownParent: 'body',
                    onInitialize: function() {
                        const tsWrapper = document.querySelector(`#${attrId}_ts-control`);
                        if (tsWrapper) {
                            tsWrapper.style.width = '100%';
                            tsWrapper.style.padding = '8px';
                        }
                    }
                });

                const valSelect = new TomSelect(`#${valId}`, {
                    plugins: ['remove_button'],
                    placeholder: "Select Attribute Values",
                    create: false,
                    dropdownParent: 'body',
                    optgroupField: 'group',
                    labelField: 'value',
                    valueField: 'id',
                    onInitialize: function() {
                        const tsWrapper = document.querySelector(`#${valId}_ts-control`);
                        if (tsWrapper) {
                            tsWrapper.style.width = '100%';
                            tsWrapper.style.padding = '8px';
                        }
                    }
                });

                if (oldData?.attribute_ids) oldData.attribute_ids.forEach(v => attrSelect.addItem(v));

                attrSelect.on('change', function(values) {
                    if (!values.length) return valSelect.clearOptions();

                    fetch(`/admin/get-attribute-values?ids=${values.join(',')}`)
                        .then(res => res.json())
                        .then(data => {
                            valSelect.clearOptions();
                            Object.keys(data).forEach(group => {
                                data[group].forEach(item => {
                                    valSelect.addOption({
                                        id: item.id,
                                        value: item.value,
                                        group: group
                                    });
                                });
                            });
                            valSelect.refreshOptions(false);
                            if (oldData?.attribute_value_ids) oldData.attribute_value_ids.forEach(v =>
                                valSelect.addItem(v));
                        })
                        .catch(err => console.error(err));
                });

                if (oldData?.attribute_value_ids) oldData.attribute_value_ids.forEach(v => valSelect.addItem(v));
            }

            productType.addEventListener('change', () => {
                if (productType.value === "1") {
                    variableSection.style.display = 'block';
                    if (container.children.length === 0) createVariantRow();
                } else {
                    variableSection.style.display = 'none';
                    container.innerHTML = '';
                }
            });

            addBtn.addEventListener('click', () => createVariantRow());

            <?php if(old('variants')): ?>
                const oldVariants = <?php echo json_encode(old('variants'), 15, 512) ?>;
                variableSection.style.display = 'block';
                Object.values(oldVariants).forEach(v => createVariantRow(null, v));
            <?php endif; ?>
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const category = document.getElementById('category');
            const subcategory = document.getElementById('subcategory');
            category.addEventListener('change', () => {
                fetch(`/admin/get-subcategories/${category.value}`)
                    .then(res => res.json())
                    .then(data => {
                        subcategory.innerHTML = '<option value="">-- Select Subcategory --</option>';
                        data.forEach(sc => subcategory.innerHTML +=
                            `<option value="${sc.id}">${sc.name}</option>`);
                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-lite.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/lang/summernote-en-US.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#productDescription').summernote({
                placeholder: 'Write something...',
                tabsize: 2,
                height: 200,
                toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/backend/products/create.blade.php ENDPATH**/ ?>