
<?php $__env->startSection('title', 'অর্ডার সম্পন্ন'); ?>
<?php $__env->startSection('content'); ?>
    <div class="min-h-screen flex items-center justify-center bg-gray-50 py-5 px-4">
        <div class="bg-white shadow-lg rounded-lg p-8 max-w-xl w-full text-center">
            <!-- Success Icon -->
            <div class="text-green-500 text-6xl mb-6">
                <i class="ri-check-line"></i>
            </div>

            <!-- Title -->
            <h1 class="text-2xl font-semibold text-gray-800 mb-4">ধন্যবাদ!</h1>

            <!-- Message -->
            <p class="text-gray-600 mb-6">
                আপনার অর্ডার সফলভাবে সম্পন্ন হয়েছে। আমরা অর্ডারের বিবরণসহ একটি ইমেইল কনফার্মেশন পাঠিয়েছি।
            </p>

            <!-- Order Info -->
            <div class="bg-gray-50 p-4 rounded-lg mb-6 text-left">
                <p class="text-gray-700 mb-2"><span class="font-medium">অর্ডার আইডি:</span> #<?php echo e(request('invoice_id')); ?></p>
                <p class="text-gray-700 mb-2"><span class="font-medium">মোট পরিমাণ:</span>
                    ৳<?php echo e(number_format(request('amount'), 2)); ?></p>
                <p class="text-gray-700 capitalize"><span class="font-medium">পেমেন্ট পদ্ধতি:</span> <?php echo e(request('method')); ?></p>
            </div>

            <!-- Buttons -->
            <div class="flex flex-col gap-3">
                <a href="<?php echo e(route('home')); ?>"
                    class="w-full bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] font-semibold py-3 rounded-lg transition">
                    <i class="ri-home-5-line mr-1"></i> হোমে ফিরে যান
                </a>
                <a href="https://mail.google.com/mail/u/0/#inbox" target="_blank"
                    class="w-full border border-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_bg); ?>]/90 font-semibold py-3 rounded-lg transition hover:text-white">
                    <i class="ri-file-list-line mr-1"></i> আমার অর্ডার দেখুন
                </a>
            </div>
        </div>
    </div>

    <?php if(!empty($order)): ?>
        <script>
            (function() {

                var ids = [
                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($item->product_id); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ];

                var totalItems = <?php echo e($order->items->sum('quantity')); ?>;
                var value = <?php echo e($order->total); ?>;

                // --- GTM ---
                if (window.dataLayer) {
                    dataLayer.push({
                        event: 'Purchase',
                        transaction_id: '<?php echo e($order->invoice_id); ?>',
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product',
                        num_items: totalItems
                    });
                }

                // --- Pixel ---
                if (typeof fbq === 'function') {
                    fbq('track', 'Purchase', {
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product',
                        num_items: totalItems
                    });
                }

            })();
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/frontend/success.blade.php ENDPATH**/ ?>