
<?php $__env->startSection('title', $setting->meta_title); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $randomCategories = $allcategories->shuffle()->take(9);
    ?>

    <style>
        @keyframes cardFadeUp {
            0% {
                opacity: 0;
                transform: translateY(20px) scale(0.98);
            }

            100% {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .product-card {
            opacity: 0;
            animation: cardFadeUp 0.6s ease forwards;
        }
    </style>

    <?php
        $favicon = $setting->favicon;
        $logo = $setting->icon;
    ?>

    <div class="w-full md:py-2 py-0 mb-4">
        <div class="max-w-6xl mx-auto grid grid-cols-12 gap-2">
            <div class="col-span-3 bg-white relative hidden md:block">
                <ul id="categoryList" class="grid grid-cols-1 max-h-[330px]">
                    <?php $__currentLoopData = $randomCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="group relative">
                            <div onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'"
                                class="flex items-center font-medium justify-between px-4 py-1 hover:bg-gray-100 cursor-pointer transition">
                                <span class="text-gray-800 text-[14.5px] capitalize"><?php echo e($category->name); ?></span>
                                <?php if($category->subcategories->count() > 0): ?>
                                    <i class="ri-arrow-right-s-line text-gray-400 text-lg font-normal"></i>
                                <?php endif; ?>
                            </div>
                            <?php if($category->subcategories->count() > 0): ?>
                                <ul class="absolute top-0 left-full hidden group-hover:block bg-white w-[220px] z-20">
                                    <div class="bg-white">
                                        <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li onclick="window.location.href='<?php echo e(route('subcategory.product', $subcategory->slug)); ?>'"
                                                class="px-4 py-2 hover:bg-gray-100 text-sm text-gray-700 cursor-pointer capitalize">
                                                <?php echo e($subcategory->name); ?>

                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </ul>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>

            <div class="md:col-span-9 col-span-12 overflow-hidden shadow-md relative">
                <div id="banner"
                    class="owl-carousel owl-theme w-full md:h-[330px] h-auto bg-gray-100 overflow-hidden flex items-center">
                    <?php $__currentLoopData = $mainBanner; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <img loading="lazy" src="<?php echo e(asset('public/' . $banner->image)); ?>" alt="Banner"
                            class="w-full h-full object-cover">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white md:py-6 py-3 mb-6">
        <div class="max-w-6xl mx-auto md:px-0 px-2 grid grid-cols-3 gap-2">
            <?php $__currentLoopData = $offerBanner->random(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img loading="lazy" src="<?php echo e(asset('public/' . $banner->image)); ?>" alt="Banner 1"
                    class="w-full h-auto md:min-h-40 min-h-16 object-cover shadow-md">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="bg-white py-4 my-6 hidden md:block">
        <div class="max-w-6xl mx-auto">
            <h2 class="text-lg font-semibold text-gray-800 mb-4 px-2">Shop by Category</h2>
            <div id="categoryScroll"
                class="owl-carousel owl-theme flex overflow-x-auto gap-4 scroll-smooth px-2 pb-2 scroll-hidden cursor-grab active:cursor-grabbing">
                <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'"
                        class="min-w-[100px] bg-gray-50 border rounded-lg shadow-sm flex flex-col items-center justify-start md:py-4 py-2 hover:shadow-md transition px-2 md:min-h-[140px] min-h-[100px]">
                        <img loading="lazy" src="<?php echo e(asset('public/' . $category->image)); ?>" alt="<?php echo e($category->name); ?>"
                            class="w-16 h-14 object-contain mb-2">
                        <span
                            class="text-sm font-medium text-gray-700 text-center capitalize line-clamp-2"><?php echo e($category->name); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- Responsive Grid for Mobile -->
    <div class="bg-white py-4 my-6 block md:hidden">
        <div class="max-w-6xl mx-auto px-2">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Shop by Category</h2>

            <div class="grid grid-cols-4 overflow-hidden" style="max-height: 220px;">
                <?php $__currentLoopData = $allcategories->shuffle()->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'"
                        class="flex flex-col items-center justify-start py-3 hover:shadow transition cursor-pointer">
                        <img loading="lazy" src="<?php echo e(asset('public/' . $category->image)); ?>" alt="<?php echo e($category->name); ?>"
                            class="w-14 h-12 object-contain mb-2 border border-gray-50 rounded">
                        <span class="text-xs font-medium capitalize text-gray-700 text-center line-clamp-2">
                            <?php echo e($category->name); ?>

                        </span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="bg-white py-3 my-6">
        <div class="max-w-6xl mx-auto">
            <div class="border-b pb-3 mb-3 flex items-center justify-between px-2">
                <h2 class="text-lg font-semibold text-gray-800 mb-3 flex items-center gap-2 mt-1">
                    <i class="ri-fire-fill text-[<?php echo e($theme->theme_bg); ?>]"></i> Hot Deals
                </h2>
                <?php
                    $hotDealsDate = $setting->hot_deals ?? null;
                ?>
                <?php if($hotDealsDate): ?>
                    <div class="flex gap-2 items-center" id="hot-deal-timer" data-end-date="<?php echo e($hotDealsDate); ?>">
                        <div id="hours"
                            class="w-10 h-9 text-sm flex items-center justify-center rounded bg-[<?php echo e($theme->theme_bg); ?>] text-white font-semibold">
                            00</div>
                        <div id="minutes"
                            class="w-10 h-9 text-sm flex items-center justify-center rounded bg-[<?php echo e($theme->theme_bg); ?>] text-white font-semibold">
                            00</div>
                        <div id="seconds"
                            class="w-10 h-9 text-sm flex items-center justify-center rounded bg-[<?php echo e($theme->theme_bg); ?>] text-white font-semibold">
                            00</div>
                    </div>
                <?php endif; ?>
            </div>

            <div id="hotdealScroll" class="owl-carousel owl-theme">
                <?php $__currentLoopData = $hotDeals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'"
                        class="product-card relative rounded-md border p-2.5 flex flex-col items-start transition cursor-pointer hover:shadow-md">
                        <?php if($product->old_price && $product->new_price): ?>
                            <?php
                                if ($product->old_price > $product->new_price) {
                                    $discount = round(
                                        (($product->old_price - $product->new_price) / $product->old_price) * 100,
                                    );
                                    $badgeText = "-{$discount}%";
                                    $badgeColor = 'bg-red-500';
                                } elseif ($product->old_price < $product->new_price) {
                                    $discount = round(
                                        (($product->new_price - $product->old_price) / $product->old_price) * 100,
                                    );
                                    $badgeText = "+{$discount}%";
                                    $badgeColor = 'bg-green-500';
                                } else {
                                    $badgeText = null;
                                }
                            ?>
                            <?php if($badgeText): ?>
                                <span
                                    class="absolute top-3 right-3 <?php echo e($badgeColor); ?> text-white text-xs font-semibold px-2 py-0.5 rounded z-20"><?php echo e($badgeText); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>

                        <div class="w-full h-40 mb-3 overflow-hidden rounded relative">
                            <img loading="lazy"
                                src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                                alt="Smartphone XYZ"
                                class="w-full h-full object-cover transform hover:scale-105 transition duration-300">
                        </div>
                        <h3 class="text-gray-700 font-semibold text-left capitalize text-[14.5px] line-clamp-2 mb-1">
                            <?php echo e($product->name); ?></h3>
                        <div class="flex items-left text-[14.5px]">
                            <?php
                                $rating = $product->averageRating();
                                $fullStars = floor($rating);
                                $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                                $emptyStars = 5 - $fullStars - $halfStar;
                            ?>
                            <?php for($i = 0; $i < $fullStars; $i++): ?>
                                <i class="ri-star-fill text-yellow-400"></i>
                            <?php endfor; ?>
                            <?php if($halfStar): ?>
                                <i class="ri-star-half-line text-yellow-400"></i>
                            <?php endif; ?>
                            <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                <i class="ri-star-line text-yellow-400"></i>
                            <?php endfor; ?>
                        </div>
                        <p class="text-[<?php echo e($theme->theme_bg); ?>] font-bold mb-2 text-left text-[14.5px]">
                            &#2547;<?php echo e($product->new_price); ?>

                            <?php if($product->old_price): ?>
                                <span
                                    class="line-through text-gray-400 text-[14px]">&#2547;<?php echo e($product->old_price); ?></span>
                            <?php endif; ?>
                        </p>

                        <div class="flex flex-col gap-1 w-full">
                            <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>" class="flex-1">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="quantity" value="1">
                                <input type="hidden" name="image"
                                    value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                <button type="submit" onclick="event.stopPropagation();"
                                    class="bg-[<?php echo e($theme->nav_bg); ?>]/90 hover:bg-[<?php echo e($theme->nav_bg); ?>] text-[<?php echo e($theme->nav_text); ?>] px-2 py-2 rounded w-full text-[14.5px]"><i class="ri-shopping-bag-line"></i>
                                    অর্ডার করুন
                                </button>
                            </form>
                            <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="flex-1">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="quantity" value="1">
                                <input type="hidden" name="image"
                                    value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                <button type="submit" onclick="event.stopPropagation();"
                                    class="bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] px-2 py-2 rounded w-full text-[14.5px]"><i class="ri-shopping-cart-line"></i>
                                    কার্টে রাখুন
                                </button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="max-w-6xl mx-auto md:px-0 px-2 mb-6">
        <?php $__currentLoopData = $offerBanner->random(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <img loading="lazy" src="<?php echo e(asset('public/' . $banner->image)); ?>" alt="Banner 1"
                class="w-full h-full md:h-72 object-fill">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="py-4 mb-6">
        <div class="max-w-6xl mx-auto px-2">
            <h2 class="text-lg font-semibold text-gray-800 mb-3">Featured Products</h2>
            <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white overflow-hidden relative cursor-pointer product-card group hover:shadow-md"
                        onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'">
                        <?php if($product->old_price && $product->new_price): ?>
                            <?php
                                if ($product->old_price > $product->new_price) {
                                    $discount = round(
                                        (($product->old_price - $product->new_price) / $product->old_price) * 100,
                                    );
                                    $badgeText = "-{$discount}%";
                                    $badgeColor = 'bg-red-500';
                                } elseif ($product->old_price < $product->new_price) {
                                    $discount = round(
                                        (($product->new_price - $product->old_price) / $product->old_price) * 100,
                                    );
                                    $badgeText = "+{$discount}%";
                                    $badgeColor = 'bg-green-500';
                                } else {
                                    $badgeText = null;
                                }
                            ?>
                            <?php if($badgeText): ?>
                                <span
                                    class="absolute top-2 right-2 <?php echo e($badgeColor); ?> text-white text-xs font-semibold px-2 py-0.5 rounded z-20"><?php echo e($badgeText); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>

                        <div class="w-full h-48 overflow-hidden relative">
                            <img loading="lazy"
                                src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                                alt="Smartphone XYZ"
                                class="w-full h-full object-cover transform hover:scale-105 transition duration-300">
                            <button
                                onclick="event.stopPropagation(); document.getElementById('add_cart_<?php echo e($product->id); ?>').submit();"
                                class="absolute bottom-2 left-2 bg-[<?php echo e($theme->theme_bg); ?>] text-white w-9 h-9 flex items-center justify-center rounded-full 
                            opacity-0 scale-0 translate-y-3 
                            group-hover:opacity-100 group-hover:scale-100 group-hover:translate-y-0 
                            transition-all duration-300 ease-out shadow-md">
                                <i class="ri-shopping-cart-line text-md"></i>
                            </button>
                        </div>

                        <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="hidden"
                            id="add_cart_<?php echo e($product->id); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="quantity" value="1">
                            <input type="hidden" name="image"
                                value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                        </form>

                        <div class="px-2.5 py-1 pb-2.5 flex flex-col items-left">
                            <h3 class="text-gray-700 font-medium capitalize text-left text-[14.5px] line-clamp-2">
                                <?php echo e($product->name); ?>

                            </h3>
                            <div class="flex items-center text-[14.5px]">
                                <?php
                                    $rating = $product->averageRating();
                                    $fullStars = floor($rating);
                                    $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                                    $emptyStars = 5 - $fullStars - $halfStar;
                                ?>
                                <?php for($i = 0; $i < $fullStars; $i++): ?>
                                    <i class="ri-star-fill text-yellow-400"></i>
                                <?php endfor; ?>
                                <?php if($halfStar): ?>
                                    <i class="ri-star-half-line text-yellow-400"></i>
                                <?php endif; ?>
                                <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                    <i class="ri-star-line text-yellow-400"></i>
                                <?php endfor; ?>
                            </div>
                            <p class="text-[<?php echo e($theme->theme_bg); ?>] font-bold mb-2 text-left text-[14.5px]">
                                &#2547;<?php echo e($product->new_price); ?>

                                <?php if($product->old_price): ?>
                                    <span
                                        class="line-through text-gray-400 text-[14px]">&#2547;<?php echo e($product->old_price); ?></span>
                                <?php endif; ?>
                            </p>
                            <div class="flex flex-row gap-1 w-full">
                                <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>"
                                    class="flex-1">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="quantity" value="1">
                                    <input type="hidden" name="image"
                                        value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                    <button type="submit" onclick="event.stopPropagation();"
                                        class="bg-[<?php echo e($theme->theme_bg); ?>]/90 hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] px-2 py-2 rounded w-full text-[14.5px]">
                                         <i class="ri-shopping-bag-line"></i>
                                        অর্ডার করুন
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="max-w-6xl mx-auto md:px-0 px-2 mb-6">
        <?php $__currentLoopData = $offerBanner->random(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <img loading="lazy" src="<?php echo e(asset('public/' . $banner->image)); ?>" alt="Banner 1"
                class="w-full h-full md:h-72 object-fill">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white py-4 mb-6">
            <div class="max-w-6xl mx-auto px-2">
                <h2 class="text-lg font-semibold text-gray-800 mb-4"><?php echo e($category->name); ?></h2>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3">
                    <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-white rounded-md animated-card overflow-hidden relative border cursor-pointer group hover:shadow"
                            onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'">
                            <?php if($product->old_price && $product->new_price): ?>
                                <?php
                                    if ($product->old_price > $product->new_price) {
                                        $discount = round(
                                            (($product->old_price - $product->new_price) / $product->old_price) * 100,
                                        );
                                        $badgeText = "-{$discount}%";
                                        $badgeColor = 'bg-red-500';
                                    } elseif ($product->old_price < $product->new_price) {
                                        $discount = round(
                                            (($product->new_price - $product->old_price) / $product->old_price) * 100,
                                        );
                                        $badgeText = "+{$discount}%";
                                        $badgeColor = 'bg-green-500';
                                    } else {
                                        $badgeText = null;
                                    }
                                ?>
                                <?php if($badgeText): ?>
                                    <span
                                        class="absolute top-2 right-2 <?php echo e($badgeColor); ?> text-white text-xs font-semibold px-2 py-0.5 rounded z-20"><?php echo e($badgeText); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                            <div class="w-full h-48 overflow-hidden relative">
                                <img loading="lazy"
                                    src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                                    alt="<?php echo e($product->name); ?>"
                                    class="w-full h-full object-cover transform hover:scale-105 transition duration-300">

                                <button
                                    onclick="event.stopPropagation(); document.getElementById('add_cart_<?php echo e($product->id); ?>').submit();"
                                    class="absolute bottom-2 left-2 bg-[<?php echo e($theme->theme_bg); ?>] text-white w-9 h-9 flex items-center justify-center rounded-full 
                                opacity-0 scale-0 translate-y-3 
                                group-hover:opacity-100 group-hover:scale-100 group-hover:translate-y-0 
                                transition-all duration-300 ease-out shadow-md">
                                    <i class="ri-shopping-cart-line text-md"></i>
                                </button>
                            </div>

                            <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="hidden"
                                id="add_cart_<?php echo e($product->id); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="quantity" value="1">
                                <input type="hidden" name="image"
                                    value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                            </form>


                            <div class="px-2.5 py-1 pb-2.5 flex flex-col items-left">
                                <h3 class="text-gray-700 font-medium capitalize text-left text-[14.5px] line-clamp-2">
                                    <?php echo e($product->name); ?></h3>
                                <div class="flex items-center text-[14.5px]">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <?php if($i <= $product->rating): ?>
                                            <i class="ri-star-fill text-yellow-400"></i>
                                        <?php elseif($i - $product->rating == 0.5): ?>
                                            <i class="ri-star-half-line text-yellow-400"></i>
                                        <?php else: ?>
                                            <i class="ri-star-line text-yellow-400"></i>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                </div>
                                <p class="text-[<?php echo e($theme->theme_bg); ?>] font-bold mb-2 text-left text-[14.5px]">
                                    &#2547;<?php echo e($product->new_price); ?>

                                    <?php if($product->old_price): ?>
                                        <span
                                            class="line-through text-gray-400 text-[14px]">&#2547;<?php echo e($product->old_price); ?></span>
                                    <?php endif; ?>
                                </p>
                                <div class="flex flex-row gap-1 w-full">
                                    <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>"
                                        class="flex-1">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="quantity" value="1">
                                        <input type="hidden" name="image"
                                            value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                        <button type="submit" onclick="event.stopPropagation();"
                                            class="bg-[<?php echo e($theme->theme_bg); ?>]/90 hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] px-2 py-2 rounded w-full text-[14.5px]">
                                            <i class="ri-shopping-bag-line"></i> অর্ডার করুন
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="bg-white py-6 mb-6">
        <div class="max-w-6xl mx-auto md:px-0 px-2 grid grid-cols-2 gap-2">
            <?php $__currentLoopData = $offerBanner->random(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img loading="lazy" src="<?php echo e(asset('public/' . $banner->image)); ?>" alt="Banner 1"
                    class="w-full h-auto md:max-h-48 md:min-h-48 object-cover shadow-md">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

  <!---  <div class="bg-white md:py-8 py-4">
        <div
            class="max-w-6xl mx-auto md:px-0 px-4 flex flex-col md:flex-row items-center md:items-center justify-between gap-6">
            <div class="flex flex-col items-center md:items-start md:w-1/3 text-center md:text-left">
                <img src="<?php echo e(asset('public/' . $logo)); ?>" alt="App Logo" class="max-h-[60px] object-contain mb-3">
                <h3 class="text-lg font-semibold text-gray-800">
                    এখনই ডাউনলোড করুন আমাদের মোবাইল অ্যাপ
                </h3>
                <p class="text-[13px] text-gray-600 mt-1">
                    আরও দ্রুত & সহজ শপিংয়ের জন্য
                </p>
            </div>

            <div id="qrcodes" class="w-32 h-32 bg-gray-50 border rounded-xl flex items-center justify-center shadow-md">
            </div>

            <div class="flex flex-col items-center md:items-end md:w-1/3 text-center md:text-right gap-2">
                <p class="text-[12px] text-indigo-600 font-semibold">
                    স্ক্যান করুন এবং অ্যাপ ডাউনলোড করুন
                </p>
                <div class="flex gap-3 mt-1 justify-center md:justify-end">
                    <img src="https://icon-library.com/images/android-app-icon-download/android-app-icon-download-11.jpg"
                        class="h-12 object-contain">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/9/91/Download_on_the_App_Store_RGB_blk.svg/1024px-Download_on_the_App_Store_RGB_blk.svg.png"
                        class="h-10 object-contain">
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script>
        var apkLink = "<?php echo e(url('/app.apk')); ?>";
        new QRCode(document.getElementById("qrcodes"), {
            text: apkLink,
            width: 130,
            height: 130,
            colorDark: "#000000",
            colorLight: "#ffffff",
            correctLevel: QRCode.CorrectLevel.H
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const cards = document.querySelectorAll(".product-card");

            cards.forEach((card, index) => {
                card.style.animationDelay = (index * 0.3) + "s";
            });
        });
    </script> --->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/frontend/welcome.blade.php ENDPATH**/ ?>