<!DOCTYPE html>
<html>

<head>
    <title>Order Delivered</title>
</head>

<body style="font-family: Arial, sans-serif; background-color: #f5f5f5; margin: 0; padding: 0;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f5f5; padding: 20px;">
        <tr>
            <td align="center">
                <table width="100%" cellpadding="0" cellspacing="0"
                    style="background-color: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 0 10px rgba(0,0,0,0.1);">

                    <!-- Header -->
                    <tr>
                        <td style="background-color: #28a745; color: #ffffff; text-align: center; padding: 20px;">
                            <h1 style="margin: 0; font-size: 24px; font-weight: normal;">Order Delivered</h1>
                        </td>
                    </tr>

                    <!-- Body -->
                    <tr>
                        <td style="padding: 20px; color: #333333; font-weight: normal;">

                            <p style="font-size: 16px; margin: 0 0 10px;">
                                Hello <?php echo e($order->shipping->name); ?>,
                            </p>

                            <p style="font-size: 16px; margin: 0 0 10px;">
                                Good news! Your order has been successfully <strong
                                    style="font-weight: normal;">delivered</strong>.
                            </p>

                            <p style="font-size: 16px; margin: 10px 0;">
                                Invoice ID: <?php echo e($order->invoice_id); ?>

                            </p>

                            <h3 style="font-size: 18px; color: #28a745; margin: 20px 0 10px; font-weight: normal;">
                                Delivered Items:
                            </h3>

                            <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div
                                    style="padding: 10px; border: 1px solid #ddd; border-radius: 8px; margin-bottom: 10px; font-weight: normal;">

                                    <p style="margin: 0 0 5px; font-size: 15px; font-weight: normal;">
                                        <?php echo e($item->product_name); ?>

                                    </p>

                                    <?php
                                        $attributes = json_decode($item->attributes, true);
                                    ?>

                                    <?php if($attributes && is_array($attributes)): ?>
                                        <p style="margin: 0 0 5px; font-size: 14px; color: #555; font-weight: normal;">
                                            <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span style="margin-right:5px;"><?php echo e($key); ?>:
                                                    <?php echo e($value); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </p>
                                    <?php endif; ?>

                                    <p style="margin: 0; font-size: 14px; font-weight: normal;">
                                        Qty: <?php echo e($item->quantity); ?> | Subtotal: ৳<?php echo e($item->quantity * $item->price); ?>

                                    </p>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <h3 style="font-size: 18px; color: #28a745; margin: 20px 0 10px; font-weight: normal;">
                                Shipping Address:
                            </h3>

                            <p style="font-size: 16px; margin: 0; font-weight: normal;">
                                <?php echo e($order->shipping->address); ?>, <?php echo e($order->shipping->city); ?>

                            </p>

                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td
                            style="background-color: #ffffff; border-top:1px solid #eee; text-align: center; padding: 15px; font-size: 14px; color: #666; font-weight: normal;">
                            &copy; <?php echo e(date('Y')); ?> <?php echo e($setting->name); ?>. All rights reserved.
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
    </table>
</body>

</html>
<?php /**PATH /home/allbdinc/public_html/resources/views/emails/order_delivered.blade.php ENDPATH**/ ?>