<?php $__env->startSection('title', 'Order #'.$order->id); ?>
<?php $__env->startSection('content'); ?>
<div class="bg-[#f8fafc] min-h-screen py-10 md:py-16">
    <div class="max-w-5xl mx-auto px-4">
        
        <div class="flex flex-col md:flex-row md:items-center justify-between mb-8 gap-4">
            <div class="flex items-center gap-4">
                <a href="<?php echo e(route('customer.orders')); ?>" class="h-12 w-12 bg-white rounded-2xl flex items-center justify-center text-gray-500 hover:text-gray-900 shadow-sm border border-gray-100 transition-all">
                    <i class="ri-arrow-left-line text-xl"></i>
                </a>
                <div>
                    <h1 class="text-3xl font-black text-gray-900 tracking-tight">Order #<?php echo e($order->invoice_id); ?></h1>
                    <p class="text-gray-500 text-sm font-bold uppercase tracking-widest mt-0.5">Placed on <?php echo e($order->created_at->format('d M Y, h:i A')); ?></p>
                </div>
            </div>

            <?php if($order->order_status == 'pending'): ?>
                <form action="<?php echo e(route('customer.orders.cancel', $order->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to cancel this order?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <button type="submit" class="bg-red-50 text-red-500 hover:bg-red-500 hover:text-white px-8 py-3 rounded-2xl font-black text-xs uppercase tracking-widest transition-all duration-300 shadow-sm flex items-center gap-2">
                        <i class="ri-close-circle-line text-lg"></i> Cancel Order
                    </button>
                </form>
            <?php endif; ?>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <div class="lg:col-span-2 space-y-8">
                <div class="bg-white rounded-xl p-8 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100">
                    <h3 class="text-xl font-black text-gray-900 tracking-tight mb-6 flex items-center gap-2">
                        <i class="ri-shopping-bag-3-line text-[<?php echo e($theme->theme_bg); ?>]"></i> Items Ordered
                    </h3>
                    
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="text-left border-b border-gray-50">
                                    <th class="pb-4 text-[10px] font-black text-gray-400 uppercase tracking-widest">Product</th>
                                    <th class="pb-4 text-[10px] font-black text-gray-400 uppercase tracking-widest text-center">Qty</th>
                                    <th class="pb-4 text-[10px] font-black text-gray-400 uppercase tracking-widest text-right">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-50">
                                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="group">
                                    <td class="py-5">
                                        <div class="flex items-center gap-4">
                                            <div class="h-16 w-16 rounded-2xl overflow-hidden border border-gray-100 bg-gray-50 flex-shrink-0">
                                                <?php if($item->product_image): ?>
                                                    <img src="<?php echo e($item->product_image); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                                                <?php else: ?>
                                                    <div class="w-full h-full flex items-center justify-center text-[10px] text-gray-400">N/A</div>
                                                <?php endif; ?>
                                            </div>
                                            <div>
                                                <a href="<?php echo e(route('product.details', $item->product->slug)); ?>" class="text-gray-900 font-bold hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors leading-tight block">
                                                    <?php echo e($item->product_name); ?>

                                                </a>
                                                <p class="text-xs text-gray-400 font-bold mt-1">৳<?php echo e(number_format($item->price, 2)); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-5 text-center font-black text-gray-900">x<?php echo e($item->quantity); ?></td>
                                    <td class="py-5 text-right font-black text-gray-900 tracking-tight">৳<?php echo e(number_format($item->price * $item->quantity, 2)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="bg-white rounded-xl p-8 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100">
                    <h3 class="text-xl font-black text-gray-900 tracking-tight mb-6 flex items-center gap-2">
                        <i class="ri-map-pin-user-line text-[<?php echo e($theme->theme_bg); ?>]"></i> Shipping Details
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div class="bg-gray-50 p-5 rounded-2xl border border-gray-100">
                            <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2">Recipient</p>
                            <p class="text-gray-900 font-bold text-lg"><?php echo e($order->shipping->name); ?></p>
                            <p class="text-gray-500 font-medium text-sm mt-1"><?php echo e($order->shipping->phone); ?></p>
                        </div>
                        <div class="bg-gray-50 p-5 rounded-2xl border border-gray-100">
                            <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2">Delivery Address</p>
                            <p class="text-gray-900 font-bold leading-relaxed"><?php echo e($order->shipping->address); ?></p>
                            <p class="text-gray-500 font-bold text-xs mt-1 uppercase tracking-wider"><?php echo e($order->shipping->city ?? 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-1">
                <div class="sticky top-24 space-y-6">
                    
                    <div class="bg-white rounded-xl p-8 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100 text-center">
                        <p class="text-[10px] font-black text-gray-400 uppercase tracking-[3px] mb-4">Order Status</p>
                        <?php
                            $statusColors = [
                                'pending' => 'bg-amber-100 text-amber-600',
                                'confirmed' => 'bg-blue-100 text-blue-600',
                                'shipped' => 'bg-indigo-100 text-indigo-600',
                                'delivered' => 'bg-emerald-100 text-emerald-600',
                                'cancelled' => 'bg-red-100 text-red-600',
                            ];
                            $colorClass = $statusColors[$order->order_status] ?? 'bg-gray-100 text-gray-600';
                        ?>
                        <span class="<?php echo e($colorClass); ?> px-6 py-2 rounded-full text-xs font-black uppercase tracking-widest inline-block mb-2">
                            <?php echo e($order->order_status); ?>

                        </span>
                    </div>

                    <div class="bg-gray-900 rounded-xl p-8 shadow-2xl shadow-gray-200 text-white">
                        <h4 class="text-lg font-black tracking-tight mb-6">Payment Summary</h4>
                        <div class="space-y-4">
                            <div class="flex justify-between text-sm opacity-70 font-bold">
                                <span>Subtotal</span>
                                <span>৳<?php echo e(number_format($subtotal, 2)); ?></span>
                            </div>
                            <div class="flex justify-between text-sm opacity-70 font-bold">
                                <span>Shipping Charge</span>
                                <span>+ ৳<?php echo e(number_format($order->shipping_charge, 2)); ?></span>
                            </div>
                            <?php if($order->discount > 0): ?>
                            <div class="flex justify-between text-sm text-red-400 font-bold">
                                <span>Discount</span>
                                <span>- ৳<?php echo e(number_format($order->discount, 2)); ?></span>
                            </div>
                            <?php endif; ?>
                            <div class="pt-4 border-t border-white/10 flex justify-between items-end">
                                <div>
                                    <p class="text-[10px] font-black uppercase tracking-widest opacity-50">Total Amount</p>
                                    <p class="text-3xl font-black tracking-tighter">৳<?php echo e(number_format($total, 2)); ?></p>
                                </div>
                                <i class="ri-bank-card-line text-4xl opacity-20"></i>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl p-6 border border-gray-100 text-center">
                        <p class="text-sm font-bold text-gray-500 mb-3">Having trouble with this order?</p>
                        <a href="#" class="text-[<?php echo e($theme->theme_bg); ?>] font-black text-xs uppercase tracking-widest hover:underline">Contact Support</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/customer/order-view.blade.php ENDPATH**/ ?>