
<?php $__env->startSection('title', $product_category->name); ?>
<?php $__env->startSection('content'); ?>
    <div class="bg-gray-50 py-4 px-4">
        <div class="max-w-6xl mx-auto grid grid-cols-12 gap-4">
            <form action="<?php echo e(route('category.product', $product_category->slug)); ?>" method="GET"
                class="col-span-12 md:col-span-3 hidden md:block bg-white h-fit rounded-lg shadow p-4 sticky top-4"
                id="categoryList">
                <h3 class="text-lg font-semibold mb-4">Filter Products</h3>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Categories</h4>
                    <ul class="space-y-2 text-sm">
                        <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="checkbox" name="categories[]" value="<?php echo e($category->id); ?>"
                                        class="form-checkbox"
                                        <?php echo e(in_array($category->id, request()->categories ?? []) ? 'checked' : ''); ?>>
                                    <span><?php echo e($category->name); ?></span>
                                </label>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Price</h4>
                    <div class="flex items-center gap-2">
                        <input type="number" name="min_price" placeholder="Min"
                            value="<?php echo e(request()->min_price ?? $minPrice); ?>"
                            class="w-1/2 border px-3 py-1.5 rounded focus:outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                        <input type="number" name="max_price" placeholder="Max"
                            value="<?php echo e(request()->max_price ?? $maxPrice); ?>"
                            class="w-1/2 border px-3 py-1.5 rounded focus:outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                    </div>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Rating</h4>
                    <div class="flex flex-col gap-1">
                        <?php for($i = 5; $i >= 1; $i--): ?>
                            <label class="flex items-center gap-2 cursor-pointer text-sm">
                                <input type="radio" name="rating" value="<?php echo e($i); ?>" class="form-radio"
                                    <?php echo e(request()->rating == $i ? 'checked' : ''); ?>>
                                <span class="flex gap-1">
                                    <?php for($j = 0; $j < $i; $j++): ?>
                                        <i class="ri-star-fill text-yellow-400"></i>
                                    <?php endfor; ?>
                                    <?php for($k = $i; $k < 5; $k++): ?>
                                        <i class="ri-star-line text-yellow-400"></i>
                                    <?php endfor; ?>
                                </span>
                            </label>
                        <?php endfor; ?>
                    </div>
                </div>

                <div class="flex gap-2 mt-4">
                    <button type="submit"
                        class="w-1/2 bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] py-2 rounded transition">Apply</button>
                    <a href="<?php echo e(route('category.product', $product_category->slug)); ?>"
                        class="w-1/2 bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 rounded transition text-center">Reset</a>
                </div>
            </form>

            <!-- ================= Products Grid ================= -->
            <main class="col-span-12 md:col-span-9">

                <div class="md:hidden mb-3 -mt-1 flex justify-between items-center">
                    <form id="sortForm" action="<?php echo e(route('category.product', $product_category->slug)); ?>" method="GET">
                        <?php $__currentLoopData = request()->categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="categories[]" value="<?php echo e($catId); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(request()->min_price): ?>
                            <input type="hidden" name="min_price" value="<?php echo e(request()->min_price); ?>">
                        <?php endif; ?>
                        <?php if(request()->max_price): ?>
                            <input type="hidden" name="max_price" value="<?php echo e(request()->max_price); ?>">
                        <?php endif; ?>
                        <?php if(request()->rating): ?>
                            <input type="hidden" name="rating" value="<?php echo e(request()->rating); ?>">
                        <?php endif; ?>
                        <select id="sortSelect" name="sort"
                            class="border border-gray-300 rounded-md px-3 py-[10px] text-sm focus:outline-none">
                            <option value="">Sort by</option>
                            <option value="price_low" <?php echo e(request('sort') == 'price_low' ? 'selected' : ''); ?>>Price: Low to
                                High</option>
                            <option value="price_high" <?php echo e(request('sort') == 'price_high' ? 'selected' : ''); ?>>Price: High
                                to Low</option>
                            <option value="rating" <?php echo e(request('sort') == 'rating' ? 'selected' : ''); ?>>Top Rated</option>
                        </select>
                    </form>

                    <button id="openFilter" type="button"
                        class="flex items-center gap-2 bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] px-4 py-[7px] rounded-md shadow hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                        <i class="ri-filter-3-line text-lg"></i> Filter
                    </button>
                </div>

                <!-- Mobile Filter Drawer -->
                <div id="mobileFilterDrawer" class="fixed inset-0 z-50 bg-black/40 hidden justify-end md:hidden">
                    <div class="bg-white w-full h-full p-5 overflow-y-auto transform translate-x-full transition-transform duration-300"
                        id="filterPanel">

                        <!-- Filter Form (same logic as desktop) -->
                        <form action="<?php echo e(route('category.product', $product_category->slug)); ?>" method="GET"
                            class="space-y-6">
                            <!-- Categories -->
                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Categories</h4>
                                <ul class="space-y-2 text-sm">
                                    <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <label class="flex items-center gap-2 cursor-pointer">
                                                <input type="checkbox" name="categories[]" value="<?php echo e($category->id); ?>"
                                                    class="form-checkbox"
                                                    <?php echo e(in_array($category->id, request()->categories ?? []) ? 'checked' : ''); ?>>
                                                <span><?php echo e($category->name); ?></span>
                                            </label>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <!-- Price -->
                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Price</h4>
                                <div class="flex items-center gap-2">
                                    <input type="number" name="min_price" placeholder="Min"
                                        value="<?php echo e(request()->min_price ?? $minPrice); ?>"
                                        class="w-1/2 border px-3 py-1.5 rounded focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                                    <input type="number" name="max_price" placeholder="Max"
                                        value="<?php echo e(request()->max_price ?? $maxPrice); ?>"
                                        class="w-1/2 border px-3 py-1.5 rounded focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                                </div>
                            </div>

                            <!-- Rating -->
                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Rating</h4>
                                <div class="flex flex-col gap-1">
                                    <?php for($i = 5; $i >= 1; $i--): ?>
                                        <label class="flex items-center gap-2 cursor-pointer text-sm">
                                            <input type="radio" name="rating" value="<?php echo e($i); ?>"
                                                class="form-radio" <?php echo e(request()->rating == $i ? 'checked' : ''); ?>>
                                            <span class="flex gap-1">
                                                <?php for($j = 0; $j < $i; $j++): ?>
                                                    <i class="ri-star-fill text-yellow-400"></i>
                                                <?php endfor; ?>
                                                <?php for($k = $i; $k < 5; $k++): ?>
                                                    <i class="ri-star-line text-yellow-400"></i>
                                                <?php endfor; ?>
                                            </span>
                                        </label>
                                    <?php endfor; ?>
                                </div>
                            </div>

                            <!-- Buttons -->
                            <div class="flex gap-2 pt-2">
                                <button type="submit"
                                    class="w-1/2 bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] py-2 rounded transition">Apply</button>
                                <a href="<?php echo e(route('category.product', $product_category->slug)); ?>"
                                    class="w-1/2 bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 rounded transition text-center">Reset</a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-3 lg:grid-cols-4 gap-y-4 gap-x-2">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-white rounded-md overflow-hidden relative border cursor-pointer group"
                            onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'">
                            <?php if($product->hot_deal == 1): ?>
                                <span
                                    class="absolute top-2 right-2 bg-red-600 text-white text-xs font-semibold px-2 py-0.5 rounded z-20">
                                    Hot
                                </span>
                            <?php elseif($product->old_price && $product->new_price): ?>
                                <?php
                                    if ($product->old_price > $product->new_price) {
                                        $discount = round(
                                            (($product->old_price - $product->new_price) / $product->old_price) * 100,
                                        );
                                        $badgeText = "-{$discount}%";
                                        $badgeColor = 'bg-red-500';
                                    } elseif ($product->old_price < $product->new_price) {
                                        $discount = round(
                                            (($product->new_price - $product->old_price) / $product->old_price) * 100,
                                        );
                                        $badgeText = "+{$discount}%";
                                        $badgeColor = 'bg-green-500';
                                    } else {
                                        $badgeText = null;
                                    }
                                ?>
                                <?php if($badgeText): ?>
                                    <span
                                        class="absolute top-2 right-2 <?php echo e($badgeColor); ?> text-white text-xs font-semibold px-2 py-0.5 rounded z-20">
                                        <?php echo e($badgeText); ?>

                                    </span>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div class="w-full h-48 overflow-hidden relative">
                                <img loading="lazy"
                                    src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                                    alt="<?php echo e($product->name); ?>"
                                    class="w-full h-full object-cover transform hover:scale-105 transition duration-300">

                                <button
                                    onclick="event.stopPropagation(); document.getElementById('add_cart_<?php echo e($product->id); ?>').submit();"
                                    class="absolute bottom-2 left-2 bg-[<?php echo e($theme->theme_bg); ?>] text-white w-9 h-9 flex items-center justify-center rounded-full 
                                opacity-0 scale-0 translate-y-3 
                                group-hover:opacity-100 group-hover:scale-100 group-hover:translate-y-0 
                                transition-all duration-300 ease-out shadow-md">
                                    <i class="ri-shopping-cart-line text-md"></i>
                                </button>
                            </div>

                            <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="hidden"
                                id="add_cart_<?php echo e($product->id); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="quantity" value="1">
                                <input type="hidden" name="image"
                                    value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                            </form>

                            <div class="px-2.5 py-1 pb-2.5 flex flex-col items-left">
                                <h3 class="text-gray-700 font-medium text-left text-[14.5px] line-clamp-2">
                                    <?php echo e($product->name); ?>

                                </h3>
                                <div class="flex items-center text-[14.5px]">
                                    <?php
                                        $rating = $product->averageRating();
                                        $fullStars = floor($rating);
                                        $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                                        $emptyStars = 5 - $fullStars - $halfStar;
                                    ?>
                                    <?php for($i = 0; $i < $fullStars; $i++): ?>
                                        <i class="ri-star-fill text-yellow-400"></i>
                                    <?php endfor; ?>
                                    <?php if($halfStar): ?>
                                        <i class="ri-star-half-line text-yellow-400"></i>
                                    <?php endif; ?>
                                    <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                        <i class="ri-star-line text-yellow-400"></i>
                                    <?php endfor; ?>
                                </div>
                                <p class="text-[<?php echo e($theme->theme_bg); ?>] font-bold mb-2 text-left text-[14.5px]">
                                    &#2547;<?php echo e($product->new_price); ?>

                                    <?php if($product->old_price): ?>
                                        <span
                                            class="line-through text-gray-400 text-[14px]">&#2547;<?php echo e($product->old_price); ?></span>
                                    <?php endif; ?>
                                </p>
                                <div class="flex flex-row gap-1 w-full">
                                    <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>"
                                        class="flex-1">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="quantity" value="1">
                                        <input type="hidden" name="image"
                                            value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                        <button type="submit" onclick="event.stopPropagation();"
                                            class="bg-[<?php echo e($theme->theme_bg); ?>]/90 hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] px-2 py-2 rounded w-full text-[14.5px]"> <i class="ri-shopping-bag-line"></i>
                                            অর্ডার করুন
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </main>
        </div>
    </div>
    <!-- JS for Mobile Filter -->
    <script>
        const openBtn = document.getElementById('openFilter');
        const closeBtn = document.getElementById('closeFilter');
        const drawer = document.getElementById('mobileFilterDrawer');
        const panel = document.getElementById('filterPanel');

        openBtn.addEventListener('click', () => {
            drawer.classList.remove('hidden');
            setTimeout(() => panel.classList.remove('translate-x-full'), 10);
        });

        closeBtn.addEventListener('click', () => {
            panel.classList.add('translate-x-full');
            setTimeout(() => drawer.classList.add('hidden'), 300);
        });

        drawer.addEventListener('click', (e) => {
            if (e.target === drawer) {
                panel.classList.add('translate-x-full');
                setTimeout(() => drawer.classList.add('hidden'), 300);
            }
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const sortSelect = document.getElementById("sortSelect");
            const sortForm = document.getElementById("sortForm");

            sortSelect.addEventListener("change", function() {
                if (this.value !== "") {
                    sortForm.submit();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/frontend/category-product.blade.php ENDPATH**/ ?>