
<?php $__env->startSection('title', 'Add New Banner'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Banner</h2>
                <!-- Small Screen Button -->
                <a href="<?php echo e(route('admin.banners.index')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-sm font-medium hover:bg-indigo-700 transition">
                    All banners
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Home</a> /
                    Banner /
                    Create
                </p>
                <!-- Large Screen Button -->
                <a href="<?php echo e(route('admin.banners.index')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-base font-medium hover:bg-indigo-700 transition">
                    All banners
                </a>
            </div>
        </div>

        <!-- Form -->
        <div class="w-full bg-white rounded shadow px-6 py-6">
            <form action="<?php echo e(route('admin.banners.store')); ?>" method="POST" enctype="multipart/form-data"
                class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-5 md:gap-6">
                <?php echo csrf_field(); ?>

                <!-- Name Dropdown -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 sm:mb-2 font-medium">Select Name</label>
                    <select name="name"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5
            text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Name --</option>
                        <option value="main">Main Banner</option>
                        <option value="offer">Offer Banner</option>
                    </select>
                </div>

                <!-- Banner Image -->
                <div class="flex flex-col col-span-2">
                    <label for="image" class="text-sm font-medium text-gray-700 mb-1">Banner Image <span
                            class="text-red-500">*</span></label>
                    <input type="file" name="image" id="image"
                        class="w-full rounded-md border border-gray-300 text-gray-900 focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]
           file:bg-[<?php echo e($theme->theme_bg); ?>] file:text-[<?php echo e($theme->theme_text); ?>] file:border-0 file:rounded-l file:px-3 file:py-2 file:cursor-pointer
           hover:file:bg-[<?php echo e($theme->theme_hover); ?>] transition-all duration-200"
                        accept="image/*" required>
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <!-- Image Preview -->
                    <div id="previewContainer" class="mt-3 hidden">
                        <p class="text-sm text-gray-600 mb-1">Preview:</p>
                        <img id="previewImage" src="#" alt="Banner Preview"
                            class="w-40 h-24 object-cover rounded border border-gray-200 shadow-sm">
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="col-span-2 md:col-span-2 mt-2">
                    <button type="submit"
                        class="w-full rounded-md bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] disabled:opacity-60 disabled:cursor-not-allowed 
                        py-2.5 text-sm sm:text-base transition-all duration-200 transform">
                        Create Banner
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- JS for Slug Auto Generation -->
    <script>
        document.getElementById('image').addEventListener('change', function(e) {
            const previewContainer = document.getElementById('previewContainer');
            const previewImage = document.getElementById('previewImage');
            const file = e.target.files[0];

            if (file) {
                const reader = new FileReader();
                reader.onload = function(event) {
                    previewImage.src = event.target.result;
                    previewContainer.classList.remove('hidden');
                }
                reader.readAsDataURL(file);
            } else {
                previewContainer.classList.add('hidden');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/backend/setting/banner/create.blade.php ENDPATH**/ ?>