<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <?php if(!empty($pixelTracking)): ?>
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($pixelTracking); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($pixelTracking); ?>&ev=PageView&noscript=1" />
        </noscript>
    <?php endif; ?>

    <?php if(!empty($gtmTracking)): ?>
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src = 'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo e($gtmTracking); ?>');
        </script>
    <?php endif; ?>

    <?php
        $favicon = $setting->favicon;
        $logo = $setting->icon;
    ?>
    <?php if($favicon && file_exists(public_path($favicon))): ?>
        <link rel="icon" href="<?php echo e(asset('public/' . $favicon)); ?>" type="image/png">
    <?php endif; ?>
    <?php if(View::hasSection('meta')): ?>
        <?php echo $__env->yieldContent('meta'); ?>
    <?php else: ?>
        <meta property="og:type" content="website">
        <meta property="og:title" content="<?php echo e($setting->meta_title ?? config('app.name')); ?>">
        <meta property="og:description" content="<?php echo e($setting->meta_desc ?? ''); ?>">

        <?php if($logo && file_exists(public_path($logo))): ?>
            <meta property="og:image" content="<?php echo e(asset('public/' . $logo)); ?>">
            <meta name="twitter:image" content="<?php echo e(asset('public/' . $logo)); ?>">
        <?php endif; ?>
    <?php endif; ?>
    <style>
        body {
            font-family: 'Roboto', 'Poppins', sans-serif;
        }

        .scroll-hidden::-webkit-scrollbar {
            display: none;
        }

        .category-scroll {
            scroll-behavior: smooth;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .search-box {
            scroll-behavior: smooth;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }
    </style>
</head>

<?php echo $__env->make('massage.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body class="bg-gray-50 text-gray-800">

    <?php if(!empty($gtmTracking)): ?>
        <noscript>
            <iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e($gtmTracking); ?>" height="0" width="0"
                style="display:none;visibility:hidden"></iframe>
        </noscript>
    <?php endif; ?>

<div class="bg-[<?php echo e($theme->theme_bg); ?>] w-full border-b border-white/5 shadow-sm">
    <div class="max-w-6xl mx-auto flex items-center justify-between px-4 py-1">
        
        <div class="flex items-center gap-4">
            <a href="tel:<?php echo e($setting->phone); ?>" class="flex items-center gap-1.5 text-[<?php echo e($theme->theme_text); ?>] text-[12px] font-medium hover:opacity-80 transition">
                <i class="ri-customer-service-2-fill text-[<?php echo e($theme->theme_text); ?>] text-sm"></i>
                <span class="hidden xs:inline"><?php echo e($setting->phone); ?></span>
            </a>
            <span class="hidden sm:block h-3 w-[1px] bg-white/20"></span>
            <a href="<?php echo e(route('order.tracking')); ?>" class="hidden sm:flex items-center gap-1.5 text-[<?php echo e($theme->theme_text); ?>] text-[12px] hover:text-[<?php echo e($theme->theme_text); ?>] transition">
                <i class="ri-truck-line text-sm"></i>
                <span>Track Order</span>
            </a>
        </div>

        <div class="flex items-center gap-5">
            <div class="flex items-center gap-3 border-r border-white/20 pr-4">
                <?php if(Auth::guard('customer')->check()): ?>
                    <a href="<?php echo e(route('customer.dashboard')); ?>" class="flex items-center gap-1.5 text-[<?php echo e($theme->theme_text); ?>] text-[12px] font-semibold hover:text-[<?php echo e($theme->theme_text); ?>] transition">
                        <div class="w-5 h-5 rounded-full bg-[<?php echo e($theme->nav_bg); ?>] flex items-center justify-center text-white text-[10px] uppercase">
                            <?php echo e(substr(Auth::guard('customer')->user()->name, 0, 1)); ?>

                        </div>
                        <span class="hidden md:inline">My Account</span>
                    </a>
                <?php else: ?>
                    <div class="flex items-center gap-2">
                        <i class="ri-user-line text-[<?php echo e($theme->nav_text); ?>] opacity-70 text-sm"></i>
                        <a href="#" class="loginBtn text-[<?php echo e($theme->nav_text); ?>] text-[12px] font-medium hover:text-[<?php echo e($theme->theme_text); ?>] transition">
                            Login
                        </a>
                        <span class="text-white/20 text-[10px]">|</span>
                        <a id="registerBtn" href="#" class="registerBtn text-[<?php echo e($theme->theme_text); ?>] text-[12px] font-medium hover:text-[<?php echo e($theme->theme_text); ?>] transition">
                            Register
                        </a>
                    </div>
                <?php endif; ?>
            </div>

            <div class="flex items-center gap-3">
                <a href="<?php echo e($setting->facebook); ?>" target="_blank" class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[#1877F2] transition duration-300">
                    <i class="ri-facebook-circle-fill text-lg"></i>
                </a>
                <a href="https://wa.me/<?php echo e($setting->whatsapp); ?>" target="_blank" class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[#25D366] transition duration-300">
                    <i class="ri-whatsapp-fill text-lg"></i>
                </a>
            </div>
        </div>
    </div>
</div>


    <div class="sticky top-0 z-50 ">
      <header class="bg-white shadow-sm border-b border-gray-100 hidden md:block sticky top-0 z-50">
    <div class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between gap-8">
        
        <div onclick="window.location.href='/'" class="flex-shrink-0 cursor-pointer group">
            <img class="max-w-[180px] h-auto object-contain transform group-hover:scale-105 transition duration-300" 
                 src="<?php echo e(asset('public/' . $logo)); ?>" 
                 alt="<?php echo e($setting->name); ?>">
        </div>

        <div id="searchEngine" class="relative flex-grow max-w-xl group">
            <div class="relative flex items-center">
                <input id="searchInput" type="text" name="search"
                    placeholder="পছন্দের পণ্যটি খুঁজুন..."
                    class="w-full pl-5 pr-12 py-2.5 rounded-full border border-gray-200 focus:outline-none focus:border-[<?php echo e($theme->theme_bg); ?>] focus:ring-4 focus:ring-[<?php echo e($theme->theme_bg); ?>]/5 transition-all duration-300 text-sm">
                
                <button class="absolute right-1 top-1 bottom-1 px-5 bg-[<?php echo e($theme->theme_bg); ?>] text-white rounded-full hover:bg-[<?php echo e($theme->theme_hover); ?>] transition-colors duration-200 shadow-sm">
                    <i class="ri-search-2-line text-lg"></i>
                </button>
            </div>

            <div id="searchBox" data-lenis-disabled
                class="search-box absolute left-0 top-full mt-3 w-full bg-white shadow-2xl border border-gray-100 rounded-xl max-h-[450px] overflow-y-auto hidden z-50 animate-in fade-in slide-in-from-top-2">
            </div>
        </div>

        <div class="flex items-center gap-6">
            
            <a href="/order/tracking" class="flex flex-col items-center gap-0.5 text-gray-600 hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors group">
                <div class="relative">
                    <i class="ri-truck-line text-xl group-hover:animate-bounce"></i>
                </div>
                <span class="text-[10px] font-medium tracking-wide uppercase">Tracking</span>
            </a>

            <div class="relative group">
                <?php if(Auth::guard('customer')->check()): ?>
                    <button class="flex flex-col items-center gap-0.5 text-gray-600 hover:text-[<?php echo e($theme->nav_bg); ?>] transition-colors">
                        <i class="ri-user-3-line text-xl"></i>
                        <span class="text-[10px] font-medium tracking-wide uppercase truncate max-w-[80px]">
                            <?php echo e(explode(' ', Auth::guard('customer')->user()->name)[0]); ?>

                        </span>
                    </button>

                    <div class="absolute right-0 mt-2 w-52 bg-white border border-gray-100 shadow-xl rounded-xl opacity-0 group-hover:opacity-100 invisible group-hover:visible transition-all duration-200 z-50 overflow-hidden">
                        <div class="bg-gray-50 px-4 py-3 border-b border-gray-100">
                            <p class="text-xs text-gray-500">Welcome,</p>
                            <p class="text-sm font-bold text-gray-800 truncate"><?php echo e(Auth::guard('customer')->user()->name); ?></p>
                        </div>
                        <a href="<?php echo e(route('customer.orders')); ?>" class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-700 hover:bg-[<?php echo e($theme->theme_bg); ?>]/5 hover:text-[<?php echo e($theme->theme_bg); ?>] transition">
                            <i class="ri-shopping-bag-3-line text-lg"></i> My Orders
                        </a>
                        <a href="<?php echo e(route('customer.dashboard')); ?>" class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-700 hover:bg-[<?php echo e($theme->theme_bg); ?>]/5 hover:text-[<?php echo e($theme->theme_bg); ?>] transition">
                            <i class="ri-settings-4-line text-lg"></i> My Account
                        </a>
                        <hr class="border-gray-50">
                        <form method="POST" action="<?php echo e(route('customer.logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full flex items-center gap-3 px-4 py-3 text-sm text-red-600 hover:bg-red-50 transition font-medium">
                                <i class="ri-logout-circle-r-line text-lg"></i> Logout
                            </button>
                        </form>
                    </div>
                <?php else: ?>
                    <a href="#" id="loginBtn" class="loginBtn flex flex-col items-center gap-0.5 text-gray-600 hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors">
                        <i class="ri-user-shared-2-line text-xl"></i>
                        <span class="text-[10px] font-medium tracking-wide uppercase">Login</span>
                    </a>
                <?php endif; ?>
            </div>

            <button onclick="window.location.href='/shipping/cart'" class="flex flex-col items-center gap-0.5 text-gray-600 hover:text-[<?php echo e($theme->theme_bg); ?>] transition-all relative group">
                <div class="relative">
                    <i class="ri-shopping-basket-line text-xl"></i>
                    <span class="absolute -top-1.5 -right-2 bg-[<?php echo e($theme->theme_bg); ?>] text-white text-[10px] font-bold rounded-full min-w-[18px] h-[18px] flex items-center justify-center border-2 border-white shadow-sm group-hover:scale-110 transition">
                        <?php echo e(count(session('cart', []))); ?>

                    </span>
                </div>
                <span class="text-[10px] font-medium tracking-wide uppercase">Cart</span>
            </button>

        </div>
    </div>
</header>


<header class="bg-white shadow-sm w-full z-50 md:hidden sticky top-0 border-b border-gray-100">
    <div class="flex items-center justify-between px-4 py-3">
        <button class="mobileMenuBtn text-gray-800 text-2xl active:scale-90 transition-transform">
            <i class="ri-menu-2-line"></i>
        </button>

        <a href="/" class="flex items-center transition-opacity hover:opacity-90">
            <img class="max-w-[140px] w-auto h-12 object-contain" src="<?php echo e(asset('public/' . $logo)); ?>" alt="Logo">
        </a>

        <div class="relative cursor-pointer active:scale-90 transition-transform" onclick="window.location.href='/shipping/cart'">
            <div class="p-1">
                <i class="ri-shopping-basket-line text-2xl text-gray-800"></i>
                <span class="absolute top-0 -right-1 bg-[<?php echo e($theme->theme_bg); ?>] text-white text-[10px] font-bold rounded-full min-w-[18px] h-[18px] flex items-center justify-center border-2 border-white shadow-sm">
                    <?php echo e(count(session('cart', []))); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="px-4 pb-3">
        <div id="MobilesearchEngine" class="relative flex items-center">
            <div class="relative w-full group">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="ri-search-line text-gray-400 text-sm"></i>
                </div>
                
                <input id="MobilesearchInput" type="text" placeholder="পছন্দের পণ্যটি খুঁজুন..."
                    class="w-full bg-gray-50 pl-10 pr-12 py-2.5 rounded-xl border border-transparent focus:bg-white focus:border-[<?php echo e($theme->theme_bg); ?>] focus:ring-4 focus:ring-[<?php echo e($theme->theme_bg); ?>]/10 transition-all duration-200 text-sm text-gray-800 outline-none">
                
                <button class="absolute right-1 top-1 bottom-1 px-3 bg-[<?php echo e($theme->theme_bg); ?>] text-white rounded-lg flex items-center justify-center shadow-sm">
                    <i class="ri-arrow-right-line"></i>
                </button>
            </div>

            <div id="MobilesearchBox" data-lenis-disabled
                class="search-box absolute left-0 top-full mt-2 bg-white w-full shadow-2xl border border-gray-100 rounded-xl max-h-[70vh] overflow-y-auto hidden z-[60]">
            </div>
        </div>
    </div>
</header>

        <div id="mobileMenu"
            class="fixed h-full w-72 left-0 top-0 bg-white border-t border-gray-200 z-50 transform -translate-x-full transition-transform duration-300 ease-in-out">
            <nav class="flex flex-col text-gray-700 text-sm h-full">
                <div
                    class="flex items-center justify-between px-4 py-2 border-b border-gray-200 sticky top-0 bg-white z-50">
                    <img class="max-w-48 w-auto h-10" src="<?php echo e(asset('public/' . $logo)); ?>" alt="">
                    <button id="closeCategorySidebar" class="text-gray-600 hover:text-[<?php echo e($theme->theme_bg); ?>]">
                        <i class="ri-close-line text-2xl"></i>
                    </button>
                </div>

                <ul class="flex flex-col divide-y divide-gray-200 overflow-auto">
                    <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="flex flex-col">
                            <div class="flex items-center justify-between px-4 py-3 hover:bg-[<?php echo e($theme->theme_bg); ?>]/50 cursor-pointer"
                                onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'">
                                <div class="flex items-center gap-3">
                                    <img src="<?php echo e(asset('public/' . $category->image ?? 'default-category.png')); ?>"
                                        alt="<?php echo e($category->name); ?>" class="w-8 h-8 object-cover rounded">
                                    <span class="text-gray-700 font-medium"><?php echo e($category->name); ?></span>
                                </div>
                                <?php if($category->subcategories->count()): ?>
                                    <i class="ri-arrow-down-s-line text-gray-500 text-xl"
                                        onclick="event.stopPropagation(); toggleSubcategory(this)"></i>
                                <?php endif; ?>
                            </div>

                            <?php if($category->subcategories->count()): ?>
                                <ul
                                    class="max-h-0 overflow-hidden transition-all duration-300 ease-in-out flex-col divide-y divide-gray-200 bg-gray-50">
                                    <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="flex items-center gap-3 px-8 py-3 hover:bg-[<?php echo e($theme->theme_bg); ?>]/50 cursor-pointer"
                                            onclick="window.location.href='<?php echo e(route('subcategory.product', $subcategory->slug)); ?>'">
                                            <span class="text-gray-600 text-sm"><?php echo e($subcategory->name); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </nav>
        </div>

        <div class="bg-[<?php echo e($theme->nav_bg); ?>] w-full hidden sm:block">
            <div class="max-w-6xl mx-auto flex items-center justify-between h-12">
                <div id="categoryButton"
                    class="mobileMenuBtn flex items-center justify-between gap-2 bg-[<?php echo e($theme->theme_bg); ?>] px-3 h-full cursor-pointer hover:[<?php echo e($theme->theme_hover); ?>] transition">
                    <span class="text-[<?php echo e($theme->theme_text); ?>] font-medium text-[14.5px] uppercase">All
                        Categories</span>
                    <i class="ri-menu-line text-[<?php echo e($theme->theme_text); ?>] text-lg"></i>
                </div>

<div class="flex items-center gap-8">
    <a href="<?php echo e(url('/')); ?>"
        class="flex items-center gap-1.5 text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14px] font-medium transition-all duration-300 group">
        <i class="ri-home-4-line text-lg opacity-80 group-hover:opacity-100"></i>
        <span>Home</span>
    </a>

    <a href="<?php echo e(url('/your/shop')); ?>"
        class="flex items-center gap-1.5 text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14px] font-medium transition-all duration-300 group">
        <i class="ri-store-2-line text-lg opacity-80 group-hover:opacity-100"></i>
        <span>Shop</span>
    </a>

    <a href="<?php echo e(url('deals')); ?>"
        class="flex items-center gap-1.5 text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14px] font-medium transition-all duration-300 group">
            <i class="ri-fire-line text-lg opacity-80 group-hover:opacity-100 text-orange-500"></i>
        <span>Deals</span>
    </a>

    <a href="<?php echo e(url('/contact')); ?>"
        class="flex items-center gap-1.5 text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14px] font-medium transition-all duration-300 group">
        <i class="ri-customer-service-2-line text-lg opacity-80 group-hover:opacity-100"></i>
        <span>Contact</span>
    </a>
</div>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('content'); ?>


    <footer class="bg-gray-900 text-gray-300 pt-12 pb-6 md:mb-0 mb-14">
        <div class="max-w-6xl mx-auto px-4">

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-10">

                <div>
                    <img class="max-w-48 w-auto h-20 mb-4" src="<?php echo e(asset('public/' . $logo)); ?>" alt="">
                    <p class="text-sm text-gray-400 leading-relaxed mb-4">
                        Your trusted online store for smart gadgets, electronics, fashion and more.
                        Shop confidently — fast delivery, secure payment, and 24/7 customer support.
                    </p>

                    <?php
                        $socialStyles = [
                            'Facebook' => [
                                'icon' => 'ri-facebook-fill',
                                'hover' => 'hover:bg-blue-600',
                            ],
                            'Instagram' => [
                                'icon' => 'ri-instagram-line',
                                'hover' => 'hover:bg-pink-500',
                            ],
                            'Twitter' => [
                                'icon' => 'ri-twitter-x-line',
                                'hover' => 'hover:bg-blue-400',
                            ],
                            'YouTube' => [
                                'icon' => 'ri-youtube-fill',
                                'hover' => 'hover:bg-red-600',
                            ],
                            'LinkedIn' => [
                                'icon' => 'ri-linkedin-fill',
                                'hover' => 'hover:bg-blue-700',
                            ],
                            'Pinterest' => [
                                'icon' => 'ri-pinterest-fill',
                                'hover' => 'hover:bg-red-500',
                            ],
                            'WhatsApp API' => [
                                'icon' => 'ri-whatsapp-line',
                                'hover' => 'hover:bg-green-500',
                            ],
                        ];
                    ?>

                    <div class="flex gap-3 mt-4">
                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $style = $socialStyles[$item->name] ?? null;
                            ?>

                            <?php if($style): ?>
                                <a href="<?php echo e($item->link); ?>" target="_blank"
                                    class="w-10 h-10 flex items-center justify-center bg-gray-800 rounded-full transition <?php echo e($style['hover']); ?>">
                                    <i class="<?php echo e($style['icon']); ?> text-white text-lg"></i>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Top Categories</h3>
                    <ul class="space-y-2 text-sm">
                        <?php $__currentLoopData = $topCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('category.product', $category->slug)); ?>"
                                    class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition"><?php echo e($category->name); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Our Services</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Free
                                Shipping</a></li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Easy Returns</a>
                        </li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">24/7 Support</a>
                        </li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Warranty
                                Policy</a></li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Affiliate
                                Program</a></li>
                    </ul>
                </div>

                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Stay Connected</h3>
                    <p class="text-sm text-gray-400 mb-3">
                        Subscribe to our newsletter for latest product updates, offers & news.
                    </p>
                    <form class="flex bg-gray-800 rounded-lg overflow-hidden mb-3">
                        <input type="email" placeholder="Enter your email"
                            class="w-full px-3 py-2 bg-gray-800 text-gray-300 text-sm focus:outline-none">
                        <button
                            class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] px-4 font-semibold text-sm transition">Join</button>
                    </form>
                    <p class="text-xs text-gray-500 mb-4">We respect your privacy. Unsubscribe anytime.</p>

                    <h3 class="text-lg font-semibold text-white mb-2">Payment Methods</h3>
                    <div class="flex gap-3 mt-2">
                        <img src="https://www.projapotishop.com/public/frontEnd/images/payment2.png" alt="Visa"
                            class="w-72">
                    </div>
                </div>

            </div>

            <div class="border-t border-gray-700 my-6"></div>

            <div class="flex flex-col sm:flex-row justify-between items-center text-sm text-gray-400">
                <p>© <?php echo e(date('Y')); ?> <span class="text-white font-semibold"><?php echo e($setting->name); ?></span> — All
                    rights reserved.
                </p>
                <div class="flex flex-wrap justify-center gap-4 mt-3 sm:mt-0">
                    <a href="<?php echo e(url('/privacy-policy')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Privacy
                        Policy</a>
                    <a href="<?php echo e(url('/terms-and-conditions')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Terms of
                        Use</a>
                    <a href="<?php echo e(url('/help-center')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Help
                        Center</a>
                    <a href="<?php echo e(url('/order/tracking')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Track Order</a>
                </div>
            </div>
        </div>
    </footer>

    <nav class="nav-btn-section fixed bottom-0 left-0 w-full bg-white/80 backdrop-blur-lg border-t border-gray-100 shadow-[0_-5px_20px_rgba(0,0,0,0.05)] z-[0] block md:hidden z-[50]">
    <ul class="flex justify-around items-center h-16">
        <li class="flex-1">
            <a href="<?php echo e(route('home')); ?>" class="flex flex-col items-center justify-center gap-0 group transition-all duration-300">
                <div class="relative flex items-center justify-center">
                    <i class="ri-home-5-line text-2xl group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors <?php echo e(request()->routeIs('home') ? 'text-['.$theme->theme_bg.']' : 'text-gray-500'); ?>"></i>
                </div>
                <span class="text-[10px] font-bold group-hover:text-[<?php echo e($theme->theme_bg); ?>] uppercase tracking-tight <?php echo e(request()->routeIs('home') ? 'text-['.$theme->theme_bg.']' : 'text-gray-500'); ?>">Home</span>
            </a>
        </li>

        <li class="flex-1">
            <a href="<?php echo e(route('shop')); ?>" class="flex flex-col items-center justify-center gap-0 group transition-all duration-300">
                <div class="relative flex items-center justify-center">
                    <i class="ri-store-2-line text-2xl group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors <?php echo e(request()->routeIs('shop') ? 'text-['.$theme->theme_bg.']' : 'text-gray-500'); ?>"></i>
                </div>
                <span class="text-[10px] font-bold group-hover:text-[<?php echo e($theme->theme_bg); ?>] uppercase tracking-tight <?php echo e(request()->routeIs('shop') ? 'text-['.$theme->theme_bg.']' : 'text-gray-500'); ?>">Shop</span>
            </a>
        </li>

        <li class="flex-1 -translate-y-4">
            <a href="<?php echo e(route('cart.index')); ?>" class="flex flex-col items-center justify-center group">
                <div class="w-14 h-14 bg-[<?php echo e($theme->theme_bg); ?>] rounded-full flex items-center justify-center shadow-lg border-4 border-white transform active:scale-90 transition-all duration-300">
                    <i class="ri-shopping-basket-line text-white text-2xl"></i>
                    <span class="absolute -top-1 -right-1 bg-red-500 text-white text-[10px] font-bold rounded-full w-5 h-5 flex items-center justify-center border-2 border-white shadow-sm">
                        <?php echo e(count(session('cart', []))); ?>

                    </span>
                </div>
                <span class="mt-2 text-[10px] font-bold uppercase tracking-tight text-[<?php echo e($theme->theme_bg); ?>]">Cart</span>
            </a>
        </li>

        <li class="flex-1">
            <a href="<?php echo e(route('order.tracking')); ?>" class="flex flex-col items-center justify-center gap-0 group transition-all duration-300">
                <div class="relative flex items-center justify-center">
                    <i class="ri-map-pin-user-line text-2xl group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors <?php echo e(request()->routeIs('order.tracking') ? 'text-['.$theme->theme_bg.']' : 'text-gray-500'); ?>"></i>
                </div>
                <span class="text-[10px] font-bold group-hover:text-[<?php echo e($theme->theme_bg); ?>] uppercase tracking-tight <?php echo e(request()->routeIs('order.tracking') ? 'text-['.$theme->theme_bg.']' : 'text-gray-500'); ?>">Track</span>
            </a>
        </li>

        <li class="flex-1">
            <?php if(Auth::guard('customer')->check()): ?>
                <button onclick="toggleProfileSidebar()" class="w-full flex flex-col items-center justify-center gap-0 group outline-none">
                    <i class="ri-user-3-fill text-2xl text-gray-500 group-hover:text-[<?php echo e($theme->theme_bg); ?>]"></i>
                    <span class="text-[10px] font-bold group-hover:text-[<?php echo e($theme->theme_bg); ?>] uppercase tracking-tight text-gray-500">Account</span>
                </button>
            <?php else: ?>
                <a href="#" class="registerBtn flex flex-col items-center justify-center gap-0 group transition-all duration-300">
                    <i class="ri-user-3-line text-2xl text-gray-500 group-hover:text-[<?php echo e($theme->theme_bg); ?>]"></i>
                    <span class="text-[10px] font-bold group-hover:text-[<?php echo e($theme->theme_bg); ?>] uppercase tracking-tight text-gray-500">Account</span>
                </a>
            <?php endif; ?>
        </li>
    </ul>
</nav>
    
<div id="profileSidebar" class="fixed inset-0 z-[100] invisible overflow-hidden" role="dialog" aria-modal="true">
    <div id="sidebarBackdrop" onclick="toggleProfileSidebar()" class="absolute inset-0 bg-black/60 backdrop-blur-sm opacity-0 transition-opacity duration-300"></div>
    
    <div id="sidebarContent" class="absolute right-0 top-0 h-full w-[300px] bg-white shadow-2xl translate-x-full transition-transform duration-300 ease-in-out">
        <div class="flex flex-col h-full">
            
            <div class="relative p-8 text-center overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-[<?php echo e($theme->theme_bg); ?>] to-indigo-900 opacity-90"></div>
                
                <div class="relative z-10">
                    <button onclick="toggleProfileSidebar()" class="absolute -top-4 -left-4 p-2 text-white/70 hover:text-white transition-colors">
                        <i class="ri-close-line text-2xl"></i>
                    </button>

                    <div class="relative inline-block group">
                        <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::guard('customer')->user()->name ?? 'User'); ?>&background=FFFFFF&color=<?php echo e(str_replace('#', '', $theme->theme_bg)); ?>&bold=true" 
                             alt="Profile" 
                             class="w-24 h-24 rounded-full border-4 border-white/20 p-1 shadow-2xl mx-auto transition-transform group-hover:scale-105">
                        <div class="absolute bottom-1 right-1 w-6 h-6 bg-green-500 border-4 border-white rounded-full"></div>
                    </div>

                    <h4 class="-mt-2 font-black text-white text-lg tracking-tight"><?php echo e(Auth::guard('customer')->user()->name ?? 'Guest User'); ?></h4>
                    <p class="text-xs text-white/70 font-medium tracking-wide uppercase"><?php echo e(Auth::guard('customer')->user()->phone ?? 'Customer Account'); ?></p>
                </div>
            </div>

            <div class="flex-1 py-6 px-4">
                <p class="px-4 mb-4 text-[10px] font-bold text-gray-400 uppercase tracking-[2px]">Quick Menu</p>
                <ul class="space-y-2">
                    <li>
                        <a href="<?php echo e(route('customer.dashboard')); ?>" class="flex items-center justify-between p-4 text-gray-700 hover:bg-[<?php echo e($theme->theme_bg); ?>]/5 hover:text-[<?php echo e($theme->theme_bg); ?>] rounded-2xl transition-all group">
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-blue-50 text-blue-500 group-hover:bg-[<?php echo e($theme->theme_bg); ?>] group-hover:text-white transition-all">
                                    <i class="ri-user-settings-line text-xl"></i>
                                </div>
                                <span class="font-bold text-sm">Dashboard</span>
                            </div>
                            <i class="ri-arrow-right-s-line text-gray-300 group-hover:translate-x-1 transition-transform"></i>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('customer.orders')); ?>" class="flex items-center justify-between p-4 text-gray-700 hover:bg-[<?php echo e($theme->theme_bg); ?>]/5 hover:text-[<?php echo e($theme->theme_bg); ?>] rounded-2xl transition-all group">
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-purple-50 text-purple-500 group-hover:bg-[<?php echo e($theme->theme_bg); ?>] group-hover:text-white transition-all">
                                    <i class="ri-shopping-bag-3-line text-xl"></i>
                                </div>
                                <span class="font-bold text-sm">Order History</span>
                            </div>
                            <i class="ri-arrow-right-s-line text-gray-300 group-hover:translate-x-1 transition-transform"></i>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('order.tracking')); ?>" class="flex items-center justify-between p-4 text-gray-700 hover:bg-[<?php echo e($theme->theme_bg); ?>]/5 hover:text-[<?php echo e($theme->theme_bg); ?>] rounded-2xl transition-all group">
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-orange-50 text-orange-500 group-hover:bg-[<?php echo e($theme->theme_bg); ?>] group-hover:text-white transition-all">
                                    <i class="ri-map-pin-line text-xl"></i>
                                </div>
                                <span class="font-bold text-sm">Track Orders</span>
                            </div>
                            <i class="ri-arrow-right-s-line text-gray-300 group-hover:translate-x-1 transition-transform"></i>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="p-6">
                <form method="POST" action="<?php echo e(route('customer.logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="group relative w-full flex items-center justify-center gap-3 p-4 bg-gray-50 text-gray-500 font-black rounded-2xl hover:bg-red-50 hover:text-red-600 transition-all active:scale-95">
                        <i class="ri-logout-circle-r-line text-xl"></i>
                        <span class="text-sm uppercase tracking-widest">Logout Now</span>
                    </button>
                </form>
                <p class="mt-4 text-[10px] text-center text-gray-300 font-medium">Version 2.0.4 • Powered by <?php echo e(config('app.name')); ?></p>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleProfileSidebar() {
        const sidebar = document.getElementById('profileSidebar');
        const backdrop = document.getElementById('sidebarBackdrop');
        const content = document.getElementById('sidebarContent');

        if (sidebar.classList.contains('invisible')) {
            sidebar.classList.remove('invisible');
            setTimeout(() => {
                backdrop.classList.replace('opacity-0', 'opacity-100');
                content.classList.replace('translate-x-full', 'translate-x-0');
            }, 10);
        } else {
            backdrop.classList.replace('opacity-100', 'opacity-0');
            content.classList.replace('translate-x-0', 'translate-x-full');
            setTimeout(() => {
                sidebar.classList.add('invisible');
            }, 300);
        }
    }
</script>

 <div id="modalOverlay" class="hidden fixed inset-0 bg-gray-900/80 backdrop-blur-[2px] z-40 transition-all duration-300"></div>

<div id="modalContainer" class="hidden fixed inset-0 flex items-center justify-center z-50 px-4 py-10">
    <div class="bg-white rounded-xl w-full max-w-[450px] relative shadow-2xl border border-gray-100 overflow-hidden">
        
        <div class="bg-[<?php echo e($theme->theme_bg); ?>] p-6 text-center relative">
            <h2 class="text-2xl font-black text-white uppercase tracking-tighter">Shopping Portal</h2>
            <p class="text-white/80 text-[10px] font-bold uppercase tracking-[2px] mt-1">Access your account & orders</p>
            
            <button id="closeModal" class="absolute top-4 right-4 h-8 w-8 flex items-center justify-center rounded-lg bg-black/10 text-white hover:bg-black/20 transition-all">
                <i class="ri-close-line text-xl"></i>
            </button>
        </div>

        <div class="p-6 md:p-10 pt-2">
            <div id="loginForm" class="animate-in fade-in slide-in-from-bottom-4 duration-300">
                <div id="loginMsg" class="text-sm mb-2"></div>

                <form id="loginAjaxForm" class="space-y-3">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase mb-1.5 block ml-1">Email or Phone</label>
                        <input type="text" name="email" placeholder="example@mail.com" required
                            class="w-full px-4 py-3 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-gray-800 transition-all">
                    </div>

                    <div>
                        <div class="flex justify-between items-center mb-1.5">
                            <label class="text-[11px] font-bold text-gray-500 uppercase ml-1">Password</label>
                            <a href="<?php echo e(route('customer.forget')); ?>" class="text-[10px] font-bold text-[<?php echo e($theme->theme_bg); ?>] uppercase hover:underline">Forgot?</a>
                        </div>
                        <input type="password" name="password" placeholder="••••••••" required
                            class="w-full px-4 py-3 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-gray-800 transition-all">
                    </div>

                    <button type="submit" class="w-full bg-[<?php echo e($theme->theme_bg); ?>] text-white font-black py-4 h-11 rounded-lg hover:brightness-90 active:scale-[0.98] transition-all shadow-lg shadow-[<?php echo e($theme->theme_bg); ?>]/20 uppercase tracking-widest text-xs">
                        Sign In Now
                    </button>
                </form>

                <div class="relative my-8">
                    <div class="absolute inset-0 flex items-center"><span class="w-full border-t border-gray-100"></span></div>
                    <div class="relative flex justify-center text-[10px] uppercase"><span class="bg-white px-4 font-bold text-gray-400">Quick Login</span></div>
                </div>

                <a href="https://accounts.google.com/..." class="flex items-center justify-center gap-3 w-full py-3 h-11 border border-gray-200 rounded-lg hover:bg-gray-50 transition-all">
                    <img src="https://www.svgrepo.com/show/475656/google-color.svg" class="w-4 h-4" alt="Google">
                    <span class="text-xs font-bold text-gray-600 uppercase tracking-wider">Login with Google</span>
                </a>

                <p class="text-center mt-8 text-xs font-bold text-gray-500 uppercase tracking-wide">
                    New Customer? 
                    <button id="registerBtn" class="registerBtn text-[<?php echo e($theme->theme_bg); ?>] font-black hover:underline ml-1">Create Account</button>
                </p>
            </div>

            <div id="registerForm" class="hidden animate-in fade-in slide-in-from-bottom-4 duration-300">
                <div id="registerMsg" class="text-sm"></div>

                <form id="registerAjaxForm" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="text-[11px] font-bold text-gray-500 uppercase mb-1 block">Name</label>
                            <input type="text" name="name" placeholder="Full Name" required class="w-full px-4 py-2.5 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-sm transition-all">
                        </div>
                        <div>
                            <label class="text-[11px] font-bold text-gray-500 uppercase mb-1 block">Phone</label>
                            <input type="text" name="phone" placeholder="017..." required class="w-full px-4 py-2.5 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-sm transition-all">
                        </div>
                    </div>

                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase mb-1 block">Email</label>
                        <input type="email" name="email" placeholder="email@example.com" required class="w-full px-4 py-2.5 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-sm transition-all">
                    </div>

                    <div class="grid md:grid-cols-2 grid-cols-1 gap-3">
                        <div>
                            <label class="text-[11px] font-bold text-gray-500 uppercase mb-1 block">Password</label>
                            <input type="password" name="password" placeholder="••••" required class="w-full px-4 py-2.5 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-sm transition-all">
                        </div>
                        <div>
                            <label class="text-[11px] font-bold text-gray-500 uppercase mb-1 block">Confirm</label>
                            <input type="password" name="password_confirmation" placeholder="••••" required class="w-full px-4 py-2.5 h-11 bg-gray-50 border border-gray-200 focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-lg outline-none font-bold text-sm transition-all">
                        </div>
                    </div>

                    <button type="submit" class="w-full bg-[<?php echo e($theme->theme_bg); ?>] text-white font-black py-3 h-11 rounded-lg hover:brightness-90 transition-all uppercase tracking-widest text-xs mt-2 shadow-lg">
                        Create My Account
                    </button>
                </form>
                
                <a href="https://accounts.google.com/..." class="flex items-center justify-center gap-3 w-full py-3 h-11 border border-gray-200 rounded-lg hover:bg-gray-50 transition-all mt-3">
                    <img src="https://www.svgrepo.com/show/475656/google-color.svg" class="w-4 h-4" alt="Google">
                    <span class="text-xs font-bold text-gray-600 uppercase tracking-wider">Login with Google</span>
                </a>

                <p class="text-center mt-6 text-xs font-bold text-gray-500 uppercase tracking-wide">
                    Already Member? 
                    <button id="switchToLogin" class="text-[<?php echo e($theme->theme_bg); ?>] font-black hover:underline ml-1">Login</button>
                </p>
            </div>
        </div>
    </div>
</div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {

            $(".loginBtn").each(function() {
                $(this).on("click", function() {
                    $("#modalOverlay, #modalContainer").removeClass("hidden");
                    $("#loginForm").show();
                    $("#registerForm").hide();
                });
            });
            
            $(".registerBtn").each(function() {
                $(this).on("click", function() {
                    $("#modalOverlay, #modalContainer").removeClass("hidden");
                    $("#registerForm").show();
                    $("#loginForm").hide();
                });
            });
            
            $("#closeModal, #modalOverlay").click(function() {
                $("#modalOverlay, #modalContainer").addClass("hidden");
            });

            $("#switchToRegister").click(function() {
                $("#loginForm").hide();
                $("#registerForm").show();
            });
            
            $("#switchToLogin").click(function() {
                $("#registerForm").hide();
                $("#loginForm").show();
            });

            $("#loginAjaxForm").submit(function(e) {
                e.preventDefault();
                $("#loginMsg").text('');
                $.ajax({
                    url: "<?php echo e(route('customer.login')); ?>",
                    method: "POST",
                    data: $(this).serialize(),
                    success: function(res) {
                        if (res.success) {
                            $("#loginMsg").text(res.message).addClass("text-green-600");
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#loginMsg").text(res.message).addClass("text-red-600");
                        }
                    },
                    error: function(err) {
                        $("#loginMsg").text("Invalid credentials or error!").addClass(
                            "text-red-600");
                    }
                });
            });

            $("#registerAjaxForm").submit(function(e) {
                e.preventDefault();
                $("#registerMsg").text('');
                $.ajax({
                    url: "<?php echo e(route('customer.register')); ?>",
                    method: "POST",
                    data: $(this).serialize(),
                    success: function(res) {
                        if (res.success) {
                            $("#registerMsg").text(res.message).addClass("text-green-600");
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#registerMsg").text(res.message).addClass("text-red-600");
                        }
                    },
                    error: function(err) {
                        let errors = err.responseJSON.errors;
                        let msg = Object.values(errors).map(e => e.join(', ')).join(' | ');
                        $("#registerMsg").text(msg).addClass("text-red-600");
                    }
                });
            });

        });
    </script>


    <script>
        const navSection = document.querySelector('.nav-btn-section');
        const openFilter = document.getElementById('openFilter');
        const closeFilter = document.getElementById('closeFilter');

        openFilter.addEventListener('click', () => {
            navSection.classList.add('hidden');
        });

        closeFilter.addEventListener('click', () => {
            navSection.classList.remove('hidden');
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const navItems = document.querySelectorAll('.nav-item');

            navItems.forEach(item => {
                if (item.href === window.location.href) {
                    item.classList.add('text-[<?php echo e($theme->theme_bg); ?>]');
                    item.querySelector('.nav-indicator').classList.add('w-full');
                }
            });

            navItems.forEach(item => {
                item.addEventListener('click', () => {
                    navItems.forEach(i => {
                        i.classList.remove('text-[<?php echo e($theme->theme_bg); ?>]');
                        i.querySelector('.nav-indicator').classList.remove('w-full');
                    });

                    item.classList.add('text-[<?php echo e($theme->theme_bg); ?>]');
                    item.querySelector('.nav-indicator').classList.add('w-full');
                });
            });
        });
    </script>

    <style>
        .nav-item:hover i,
        .nav-item:hover span {
            color: #f97316;
            transform: translateY(-2px);
            transition: all 0.3s ease;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const searchBox = document.getElementById('searchBox');

            async function handleSearch() {
                const query = searchInput.value.trim();
                if (query.length === 0) {
                    searchBox.classList.add('hidden');
                    searchBox.innerHTML = '';
                    return;
                }

                try {
                    const response = await fetch(`/search/products?query=${encodeURIComponent(query)}`);
                    if (!response.ok) throw new Error('Network response was not ok');

                    const products = await response.json();

                    searchBox.innerHTML = '';
                    if (products.length === 0) {
                        searchBox.innerHTML =
                            `<div class="p-4 text-center text-gray-500">Products not found</div>`;
                    } else {
                        products.forEach(product => {

                            const imageUrl = product.image ?
                                `/public/uploads/products/${product.image}` :
                                '/public/uploads/products/placeholder.jpg';

                            const item = document.createElement('div');
                            item.className =
                                "flex items-center justify-between p-3 hover:bg-gray-50 border-b border-gray-50 cursor-pointer";
                            item.innerHTML = `
                        <div class="flex items-center gap-3">
                            <img src="${imageUrl}" alt="Product" class="w-10 h-10 object-cover rounded-full">
                            <div>
                                <p class="text-gray-800 line-clamp-1 mb-0.5">${product.name}</p>
                                <p class="text-gray-500 text-sm">&#2547;${product.price}</p>
                            </div>
                        </div>
                        <div class="text-gray-500 text-xl">
                            <i class="ri-arrow-right-s-line"></i>
                        </div>
                    `;
                            item.addEventListener('click', () => {
                                window.location.href = `/product/${product.slug}`;
                            });
                            searchBox.appendChild(item);
                        });
                    }
                    searchBox.classList.remove('hidden');
                } catch (error) {
                    searchBox.innerHTML =
                        `<div class="p-4 text-center text-red-500">Error loading products</div>`;
                    searchBox.classList.remove('hidden');
                    console.error(error);
                }
            }

            function debounce(func, delay = 300) {
                let timeout;
                return function(...args) {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(this, args), delay);
                }
            }

            searchInput.addEventListener('input', debounce(handleSearch, 300));

            document.addEventListener('click', (e) => {
                if (!document.getElementById('searchEngine').contains(e.target)) {
                    searchBox.classList.add('hidden');
                }
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const MobilesearchInput = document.getElementById('MobilesearchInput');
            const MobilesearchBox = document.getElementById('MobilesearchBox');

            async function handleSearch() {
                const query = MobilesearchInput.value.trim();
                if (query.length === 0) {
                    MobilesearchBox.classList.add('hidden');
                    MobilesearchBox.innerHTML = '';
                    return;
                }

                try {
                    const response = await fetch(`/search/products?query=${encodeURIComponent(query)}`);
                    if (!response.ok) throw new Error('Network response was not ok');

                    const products = await response.json();

                    MobilesearchBox.innerHTML = '';
                    if (products.length === 0) {
                        MobilesearchBox.innerHTML =
                            `<div class="p-4 text-center text-gray-500">Products not found</div>`;
                    } else {
                        products.forEach(product => {

                            const imageUrl = product.image ?
                                `/public/uploads/products/${product.image}` :
                                '/public/uploads/products/placeholder.jpg';

                            const item = document.createElement('div');
                            item.className =
                                "flex items-center justify-between p-3 hover:bg-gray-50 border-b border-gray-50 cursor-pointer";
                            item.innerHTML = `
                        <div class="flex items-center gap-3">
                            <img src="${imageUrl}" alt="Product" class="w-10 h-10 object-cover rounded-full">
                            <div>
                                <p class="text-gray-800 line-clamp-1 mb-0.5">${product.name}</p>
                                <p class="text-gray-500 text-sm">&#2547;${product.price}</p>
                            </div>
                        </div>
                        <div class="text-gray-500 text-xl">
                            <i class="ri-arrow-right-s-line"></i>
                        </div>
                    `;
                            item.addEventListener('click', () => {
                                window.location.href = `/product/${product.slug}`;
                            });
                            MobilesearchBox.appendChild(item);
                        });
                    }
                    MobilesearchBox.classList.remove('hidden');
                } catch (error) {
                    MobilesearchBox.innerHTML =
                        `<div class="p-4 text-center text-red-500">Error loading products</div>`;
                    MobilesearchBox.classList.remove('hidden');
                    console.error(error);
                }
            }

            function debounce(func, delay = 300) {
                let timeout;
                return function(...args) {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(this, args), delay);
                }
            }

            MobilesearchInput.addEventListener('input', debounce(handleSearch, 300));

            document.addEventListener('click', (e) => {
                if (!document.getElementById('MobilesearchEngine').contains(e.target)) {
                    searchBox.classList.add('block');
                }
            });
        });
    </script>

    <script>
        function toggleSubcategory(icon) {
            const subList = icon.closest('li').querySelector('ul');
            if (!subList) return;

            if (subList.style.maxHeight && subList.style.maxHeight !== '0px') {
                subList.style.maxHeight = '0px';
                icon.classList.remove('ri-arrow-up-s-line');
                icon.classList.add('ri-arrow-down-s-line');
            } else {
                subList.style.maxHeight = subList.scrollHeight + 'px';
                icon.classList.remove('ri-arrow-down-s-line');
                icon.classList.add('ri-arrow-up-s-line');
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('ul > li > ul').forEach(ul => {
                ul.style.maxHeight = '0px';
            });
        });
    </script>

    <script>
        const categoryButton = document.getElementById('categoryButton');
        const categoryList = document.getElementById('categoryList');

        function syncCategoryWidth() {
            if (categoryList && categoryButton) {
                const width = categoryList.offsetWidth;
                categoryButton.style.width = width + 'px';
            }
        }

        syncCategoryWidth();

        window.addEventListener('resize', syncCategoryWidth);

        const observer = new ResizeObserver(syncCategoryWidth);
        observer.observe(categoryList);
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const searchBox = document.getElementById('searchBox');

            function syncSearchBoxWidth() {
                if (searchInput && searchBox) {
                    const width = searchInput.getBoundingClientRect().width;
                    searchBox.style.width = width + 'px';
                }
            }

            setTimeout(() => {
                requestAnimationFrame(syncSearchBoxWidth);
            }, 100);

            window.addEventListener('resize', syncSearchBoxWidth);

            const observer = new ResizeObserver(syncSearchBoxWidth);
            observer.observe(searchInput);
        });
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#categoryScroll').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 1000,
                smartSpeed: 1000,
                responsive: {
                    0: {
                        items: 3
                    },
                    640: {
                        items: 4
                    },
                    768: {
                        items: 5
                    },
                    1024: {
                        items: 7
                    },
                    1280: {
                        items: 8
                    }
                }
            });

            $('#hotdealScroll').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 2000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                stagePadding: 5,
                responsive: {
                    0: {
                        items: 2
                    },
                    480: {
                        items: 2
                    },
                    768: {
                        items: 4
                    },
                    1024: {
                        items: 5
                    }
                },
            });

            $('#banner').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 2000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                stagePadding: 0,
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    768: {
                        items: 1
                    },
                    1024: {
                        items: 1
                    }
                },
            });

            $('#desktopProduct').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 2000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                stagePadding: 0,
                responsive: {
                    0: {
                        items: 5
                    },
                    480: {
                        items: 5
                    },
                    768: {
                        items: 5
                    },
                    1024: {
                        items: 5
                    }
                },
            });

            $(document).ready(function() {
                var owl = $('#phoneProduct');
                owl.owlCarousel({
                    loop: true,
                    margin: 10,
                    nav: false,
                    dots: false,
                    autoplay: true,
                    autoplayTimeout: 3000,
                    autoplaySpeed: 2000,
                    smartSpeed: 1000,
                    autoplayHoverPause: true,
                    stagePadding: 0,
                    responsive: {
                        0: {
                            items: 1
                        },
                        480: {
                            items: 1
                        },
                        768: {
                            items: 1
                        },
                        1024: {
                            items: 1
                        }
                    },
                    onInitialized: updateCounter,
                    onTranslated: updateCounter
                });

                function updateCounter(event) {
                    var element = event.target;
                    var items = event.item.count;
                    var item = event.item.index - event.relatedTarget._clones.length / 2;
                    if (item > items || item === 0) {
                        item = items;
                    }
                    $('#productCounter').text(item + ' / ' + items);
                }
            });
            
            $(document).ready(function() {
                var owl = $('#service');
                owl.owlCarousel({
                    loop: true,
                    margin: 10,
                    nav: false,
                    dots: false,
                    autoplay: true,
                    autoplayTimeout: 3000,
                    autoplaySpeed: 2000,
                    smartSpeed: 1000,
                    autoplayHoverPause: true,
                    stagePadding: 0,
                    responsive: {
                        0: {
                            items: 2
                        },
                        480: {
                            items: 3
                        },
                        768: {
                            items: 4
                        },
                        1024: {
                            items: 4
                        }
                    },
                    onInitialized: updateCounter,
                    onTranslated: updateCounter
                });

                function updateCounter(event) {
                    var element = event.target;
                    var items = event.item.count;
                    var item = event.item.index - event.relatedTarget._clones.length / 2;
                    if (item > items || item === 0) {
                        item = items;
                    }
                    $('#productCounter').text(item + ' / ' + items);
                }
            });

        });
    </script>

    <script>
        document.getElementById('categoryButton').addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>

    <script>
        const menuBtns = document.querySelectorAll('.mobileMenuBtn'); // note: class, not id
        const menu = document.getElementById('mobileMenu');
        const categoryCloseBtn = document.getElementById('closeCategorySidebar');

        function openMenu() {
            menu.style.transform = 'translateX(0)';
        }

        function closeMenu() {
            menu.style.transform = 'translateX(-100%)';
        }

        menuBtns.forEach(btn => {
            btn.addEventListener('click', openMenu);
        });

        categoryCloseBtn.addEventListener('click', closeMenu);

        document.addEventListener('click', function(event) {
            let clickedInsideMenuBtn = false;
            menuBtns.forEach(btn => {
                if (btn.contains(event.target)) clickedInsideMenuBtn = true;
            });

            if (!menu.contains(event.target) && !clickedInsideMenuBtn) {
                closeMenu();
            }
        });

        function toggleSubcategory(icon) {
            const subList = icon.closest('li').querySelector('ul');
            if (!subList) return;

            if (subList.style.maxHeight && subList.style.maxHeight !== '0px') {
                subList.style.maxHeight = '0px';
                icon.classList.remove('ri-arrow-up-s-line');
                icon.classList.add('ri-arrow-down-s-line');
            } else {
                subList.style.maxHeight = subList.scrollHeight + 'px';
                icon.classList.remove('ri-arrow-down-s-line');
                icon.classList.add('ri-arrow-up-s-line');
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('ul > li > ul').forEach(ul => {
                ul.style.maxHeight = '0px';
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const timer = document.getElementById("hot-deal-timer");
            if (!timer) return;

            const endDate = new Date(timer.dataset.endDate).getTime();

            function updateTimer() {
                const now = new Date().getTime();
                const distance = endDate - now;

                if (distance <= 0) {
                    document.getElementById("hours").textContent = "00";
                    document.getElementById("minutes").textContent = "00";
                    document.getElementById("seconds").textContent = "00";
                    clearInterval(timerInterval);
                    return;
                }

                const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                document.getElementById("hours").textContent = String(hours).padStart(2, '0');
                document.getElementById("minutes").textContent = String(minutes).padStart(2, '0');
                document.getElementById("seconds").textContent = String(seconds).padStart(2, '0');
            }

            const timerInterval = setInterval(updateTimer, 1000);
            updateTimer();
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/@studio-freight/lenis@1.0.29/bundled/lenis.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const lenis = new Lenis({
                duration: 1.2,
                smooth: true
            });

            const searchBox = document.getElementById('searchBox');
            if (searchBox) {
                searchBox.addEventListener('wheel', (e) => {
                    e.stopPropagation();
                });
                searchBox.addEventListener('touchmove', (e) => {
                    e.stopPropagation();
                });
            }

            function raf(time) {
                lenis.raf(time);
                requestAnimationFrame(raf);
            }
            requestAnimationFrame(raf);
        });
    </script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css">
    <script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>

</body>

</html>
<?php /**PATH /home/mojibor1/public_html/resources/views/frontend/layouts/master.blade.php ENDPATH**/ ?>