                <div class="group relative bg-white rounded-xl border border-gray-100 overflow-hidden transition-all duration-300 hover:shadow-[0_10px_25px_rgba(0,0,0,0.1)] hover:-translate-y-1 cursor-pointer"
                    onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'">
                    
                    <?php if($product->old_price && $product->new_price): ?>
                        <?php
                            $badgeText = null;
                            if ($product->old_price > $product->new_price) {
                                $discount = round((($product->old_price - $product->new_price) / $product->old_price) * 100);
                                $badgeText = "-{$discount}%";
                                $badgeColor = 'bg-red-500';
                            } elseif ($product->old_price < $product->new_price) {
                                $discount = round((($product->new_price - $product->old_price) / $product->old_price) * 100);
                                $badgeText = "+{$discount}%";
                                $badgeColor = 'bg-green-500';
                            }
                        ?>
                        <?php if($badgeText): ?>
                            <span class="absolute top-6 right-6 <?php echo e($badgeColor); ?> text-white text-[10px] font-bold px-2 py-0.5 rounded-full z-20 shadow-sm">
                                <?php echo e($badgeText); ?>

                            </span>
                        <?php endif; ?>
                    <?php endif; ?>

                    <div class="w-full h-48 overflow-hidden relative bg-gray-50">
                        <img loading="lazy"
                            src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                            alt="<?php echo e($product->name); ?>"
                            class="w-full h-full p-2 transform group-hover:scale-110 transition duration-500 rounded-t-2xl">
                        
                        <button
                            onclick="event.stopPropagation(); document.getElementById('add_cart_<?php echo e($product->id); ?>').submit();"
                            class="absolute bottom-3 right-3 bg-white text-[<?php echo e($theme->theme_bg); ?>] w-10 h-10 flex items-center justify-center rounded-full shadow-lg opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300 hover:bg-[<?php echo e($theme->theme_bg); ?>] hover:text-white">
                            <i class="ri-shopping-cart-2-line text-lg"></i>
                        </button>
                    </div>

                    <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="hidden" id="add_cart_<?php echo e($product->id); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="quantity" value="1">
                        <input type="hidden" name="image" value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                    </form>

                    <div class="p-3">
                        <h3 class="text-gray-700 font-semibold text-sm line-clamp-2 h-10 mb-1 group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors capitalize">
                            <?php echo e($product->name); ?>

                        </h3>
                        
                        <div class="flex items-center gap-0.5">
                            <?php
                                $rating = $product->averageRating();
                                $fullStars = floor($rating);
                                $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                            ?>
                            <?php for($i = 0; $i < $fullStars; $i++): ?>
                                <i class="ri-star-fill text-orange-400 text-[12px]"></i>
                            <?php endfor; ?>
                            <?php if($halfStar): ?>
                                <i class="ri-star-half-line text-orange-400 text-[12px]"></i>
                            <?php endif; ?>
                            <?php for($i = 0; $i < (5 - $fullStars - $halfStar); $i++): ?>
                                <i class="ri-star-line text-gray-300 text-[12px]"></i>
                            <?php endfor; ?>
                        </div>

                        <div class="flex items-baseline gap-2 mb-2">
                            <span class="text-[<?php echo e($theme->theme_bg); ?>] font-bold text-base">
                                ৳<?php echo e(number_format($product->new_price)); ?>

                            </span>
                            <?php if($product->old_price): ?>
                                <span class="line-through text-gray-400 text-xs">
                                    ৳<?php echo e(number_format($product->old_price)); ?>

                                </span>
                            <?php endif; ?>
                        </div>

<div class="flex flex-row items-center gap-2 mt-2 w-full">
    <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>" class="flex-[3]">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="quantity" value="1">
        <input type="hidden" name="image" value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
        <button type="submit" onclick="event.stopPropagation();"
            class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover ?? $theme->theme_bg); ?>] text-white h-9 rounded-lg text-sm font-bold flex items-center justify-center gap-2 transition-all active:scale-95 shadow-sm">
            <i class="ri-shopping-bag-line text-sm"></i>
            <span>অর্ডার করুন</span>
        </button>
    </form>
</div>
                    </div>
                </div>
<?php /**PATH /home/mojibor1/public_html/resources/views/frontend/products/index.blade.php ENDPATH**/ ?>