
<?php $__env->startSection('title', 'My Orders'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

        <h1
            class="text-2xl font-medium mb-6 text-gray-800 relative inline-block 
               after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[<?php echo e($theme->theme_bg); ?>] after:bottom-[-6px] after:left-0">
            🛒 My Orders
        </h1>

        <?php if($orders->count() > 0): ?>
            <div class="bg-white shadow rounded-lg p-4 overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-100">
                            <th class="px-4 py-2 text-gray-700">Invoice ID</th>
                            <th class="px-4 py-2 text-gray-700">Order Date</th>
                            <th class="px-4 py-2 text-gray-700">Order Status</th>
                            <th class="px-4 py-2 text-gray-700">Amount</th>
                            <th class="px-4 py-2 text-gray-700">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="border-b hover:bg-gray-50 transition">
                                <td class="px-4 py-2 font-medium text-gray-800"><?php echo e($order->invoice_id); ?></td>
                                <td class="px-4 py-2 text-gray-600"><?php echo e($order->created_at->format('d M, Y')); ?></td>
                                <td class="px-4 py-2">
                                    <?php
                                        $statusColors = [
                                            'pending' => 'yellow',
                                            'confirmed' => 'blue',
                                            'Ready to Ship' => 'purple',
                                            'shipped' => 'indigo',
                                            'delivered' => 'green',
                                            'cancelled' => 'red',
                                            'refunded' => 'gray',
                                        ];
                                        $color = $statusColors[$order->order_status] ?? 'gray';
                                    ?>
                                    <span
                                        class="bg-<?php echo e($color); ?>-100 text-<?php echo e($color); ?>-700 px-2 py-1 rounded-full text-xs">
                                        <?php echo e(ucfirst($order->order_status)); ?>

                                    </span>
                                </td>

                                <td class="px-4 py-2 font-medium text-gray-800">৳<?php echo e(number_format($order->total, 2)); ?></td>
                                <td class="px-4 py-2">
                                    <a href="<?php echo e(route('customer.order.view', $order->id)); ?>"
                                        class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline text-sm flex items-center gap-1">
                                        <i class="ri-eye-line"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="flex flex-col items-center justify-center py-16 bg-gray-50 rounded-lg shadow">
                <img loading="lazy" src="https://cdn-icons-png.flaticon.com/512/2038/2038854.png" alt="No Orders"
                    class="w-40 h-40 mb-6 animate-bounce">
                <h2 class="text-2xl font-medium text-gray-700 mb-2">No Orders Found</h2>
                <p class="text-gray-500 mb-6 text-center px-4">
                    You haven't placed any orders yet. Start shopping and place your first order!
                </p>
                <a href="<?php echo e(route('shop')); ?>"
                    class="bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] font-medium py-3 px-6 rounded-lg transition">
                    Go to Shop
                </a>
            </div>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/customer/order.blade.php ENDPATH**/ ?>