<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <?php if(!empty($pixelTracking)): ?>
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($pixelTracking); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($pixelTracking); ?>&ev=PageView&noscript=1" />
        </noscript>
    <?php endif; ?>

    <?php if(!empty($gtmTracking)): ?>
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src = 'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo e($gtmTracking); ?>');
        </script>
    <?php endif; ?>

    <?php
        $favicon = $setting->favicon;
        $logo = $setting->icon;
    ?>
    <?php if($favicon && file_exists(public_path($favicon))): ?>
        <link rel="icon" href="<?php echo e(asset('public/' . $favicon)); ?>" type="image/png">
    <?php endif; ?>
    <?php if(View::hasSection('meta')): ?>
        <?php echo $__env->yieldContent('meta'); ?>
    <?php else: ?>
        <meta property="og:type" content="website">
        <meta property="og:title" content="<?php echo e($setting->meta_title ?? config('app.name')); ?>">
        <meta property="og:description" content="<?php echo e($setting->meta_desc ?? ''); ?>">

        <?php if($logo && file_exists(public_path($logo))): ?>
            <meta property="og:image" content="<?php echo e(asset('public/' . $logo)); ?>">
            <meta name="twitter:image" content="<?php echo e(asset('public/' . $logo)); ?>">
        <?php endif; ?>
    <?php endif; ?>
    <style>
        body {
            font-family: 'Roboto', 'Poppins', sans-serif;
        }

        .scroll-hidden::-webkit-scrollbar {
            display: none;
        }

        .category-scroll {
            scroll-behavior: smooth;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .search-box {
            scroll-behavior: smooth;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }
    </style>
</head>

<?php echo $__env->make('massage.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body class="bg-gray-50 text-gray-800">

    <?php if(!empty($gtmTracking)): ?>
        <noscript>
            <iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e($gtmTracking); ?>" height="0" width="0"
                style="display:none;visibility:hidden"></iframe>
        </noscript>
    <?php endif; ?>

    <div class="bg-[<?php echo e($theme->nav_bg); ?>] w-full">
        <div class="max-w-6xl mx-auto flex items-center py-2">
            <marquee class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-sm leading-tight">
                <?php echo e($setting->headline); ?>

            </marquee>
        </div>
    </div>

    <!-- Fixed buttons -->
    <div class="fixed md:bottom-5 bottom-20 right-5 flex flex-col gap-3 z-50">
        <!-- Messenger Button -->
        <a href="<?php echo e($setting->facebook ?? 'https://www.facebook.com/yourpage'); ?>" target="_blank"
            class="w-12 h-12 bg-blue-600 text-white flex items-center justify-center rounded-full shadow-lg hover:scale-110 transition-transform">
            <i class="ri-messenger-line text-2xl"></i>
        </a>

        <!-- WhatsApp Button -->
        <a href="https://wa.me/<?php echo e($setting->whatsapp ?? '4571421852'); ?>" target="_blank"
            class="w-12 h-12 bg-green-500 text-white flex items-center justify-center rounded-full shadow-lg hover:scale-110 transition-transform">
            <i class="ri-whatsapp-line text-2xl"></i>
        </a>
    </div>

    <div class="sticky top-0 z-50 ">
        <header class="bg-white shadow-sm hidden md:block relative">
            <div class="max-w-6xl mx-auto py-4 flex items-center justify-between">
                <!-- Logo -->
                <h1 onclick="window.location.href='/'"
                    class="text-2xl font-bold text-[<?php echo e($theme->theme_bg); ?>] flex items-center gap-1 cursor-pointer">
                    <img class="max-w-48 w-auto h-16" src="<?php echo e(asset('public/' . $logo)); ?>" alt="">
                </h1>

                <!-- Search Bar -->
                <div id="searchEngine" class="relative flex items-center justify-center mx-6 w-[500px] lg:w-[600px]">
                    <input id="searchInput" type="text" name="search"
                        placeholder="Search in <?php echo e($setting->name); ?>..."
                        class="w-full px-4 py-2 rounded-l-md border border-gray-300 focus:outline-none focus:border-[<?php echo e($theme->theme_bg); ?>] focus:ring-0 transition-colors duration-200">
                    <button
                        class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] border border-[<?php echo e($theme->theme_bg); ?>] px-4 py-2 rounded-r-md">
                        <i class="ri-search-line"></i>
                    </button>

                    <div id="searchBox" data-lenis-disabled
                        class="search-box absolute left-0 top-full mt-2 bg-white shadow-md border border-gray-200 rounded-md max-h-80 overflow-y-auto hidden">
                    </div>
                </div>

                <div class="flex items-center gap-5">

                    <a href="/order/tracking"
                        class="flex items-center gap-1 text-gray-700 hover:text-[<?php echo e($theme->theme_bg); ?>] font-medium">
                        <i class="ri-map-pin-line text-xl"></i>
                        <span class="font-normal">Tracking Order</span>
                    </a>

                    <?php if(Auth::guard('customer')->check()): ?>
                        <div class="relative group">
                            <a href="javascript:void(0)"
                                class="flex items-center gap-1 text-gray-700 hover:text-[<?php echo e($theme->theme_bg); ?>]">
                                <i class="ri-user-3-line text-xl"></i>
                                <span class="font-normal"><?php echo e(Auth::guard('customer')->user()->name); ?></span>
                            </a>

                            <div
                                class="absolute right-0 mt-2 w-56 bg-white border shadow-lg opacity-0 group-hover:opacity-100 invisible group-hover:visible transition-all duration-200 z-50">

                                <a href="<?php echo e(route('customer.orders')); ?>"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <i class="ri-shopping-bag-line mr-1"></i> My Orders
                                </a>

                                <a href="<?php echo e(route('customer.account')); ?>"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <i class="ri-user-line mr-1"></i> My Account
                                </a>

                                <form method="POST" action="<?php echo e(route('customer.logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"
                                        class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                                        <i class="ri-logout-box-line mr-1"></i> Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="#" id="loginBtn"
                            class="loginBtn flex items-center gap-1 text-gray-700 hover:text-[<?php echo e($theme->theme_bg); ?>] font-medium">
                            <i class="ri-login-box-line text-xl"></i>
                            <span class="font-normal">Login</span>
                        </a>
                    <?php endif; ?>

                    <div class="relative cursor-pointer" onclick="window.location.href='/shipping/cart'">
                        <i
                            class="ri-shopping-cart-line  text-xl text-gray-700 hover:text-[<?php echo e($theme->theme_bg); ?>] cursor-pointer text-2xl"></i>
                        <span
                            class="absolute -top-2 -right-2 bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] text-xs rounded-full px-1.5 py-0.5 font-semibold">
                            <?php echo e(count(session('cart', []))); ?></span>
                    </div>
                </div>
            </div>
        </header>

        <!-- ================= <?php echo e($setting->name); ?> MOBILE HEADER ================= -->
        <header class="bg-white shadow-sm w-full z-50 md:hidden relative">
            <!-- Top Bar: Menu, Logo, Cart -->
            <div class="flex items-center justify-between px-4 py-4">
                <!-- ☰ Menu Button -->
                <button class="mobileMenuBtn text-gray-700 text-2xl hover:text-[<?php echo e($theme->theme_bg); ?>]">
                    <i class="ri-menu-line"></i>
                </button>

                <!-- 🛍️ Logo -->
                <a href="/" class="flex items-center gap-1 text-[<?php echo e($theme->theme_bg); ?>] font-bold text-xl">
                    <img class="max-w-48 w-auto h-12" src="<?php echo e(asset('public/' . $logo)); ?>" alt="">
                </a>

                <!-- 🛒 Cart Icon -->
                <div class="relative" onclick="window.location.href='/shipping/cart'">
                    <i
                        class="ri-shopping-cart-line text-2xl text-gray-700 hover:text-[<?php echo e($theme->theme_bg); ?>] cursor-pointer"></i>
                    <span
                        class="absolute -top-1.5 -right-1.5 bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] text-xs rounded-full px-1.5 font-semibold">
                        <?php echo e(count(session('cart', []))); ?>

                    </span>
                </div>
            </div>

            <!-- 🔍 Search Bar -->
            <div class="px-4 pb-4">
                <div id="MobilesearchEngine" class="relative flex items-center bg-gray-100 rounded bg-white">
                    <input id="MobilesearchInput" type="text" placeholder="Search products..."
                        class="w-full bg-[transparent] px-3 py-2 outline-none rounded-l ring-1 ring-offset-1 ring-gray-200 text-sm text-gray-700 transition-colors duration-200
                focus:outline-none focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:ring-offset-1">
                    <button
                        class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] px-3 py-2 rounded-r">
                        <i class="ri-search-line"></i>
                    </button>
                    <div id="MobilesearchBox" data-lenis-disabled
                        class="search-box absolute left-0 top-full mt-2 bg-white w-[-webkit-fill-available] shadow-md border border-gray-200 rounded-md max-h-96 overflow-y-auto hidden">
                        <!-- JS will populate products here -->
                    </div>
                </div>
            </div>
        </header>

        <!-- 📂 Mobile Dropdown Menu (Hidden by default) -->
        <div id="mobileMenu"
            class="fixed h-full w-72 left-0 top-0 bg-white border-t border-gray-200 z-50 transform -translate-x-full transition-transform duration-300 ease-in-out">
            <nav class="flex flex-col text-gray-700 text-sm h-full">
                <!-- Header -->
                <div
                    class="flex items-center justify-between px-4 py-2 border-b border-gray-200 sticky top-0 bg-white z-50">
                    <img class="max-w-48 w-auto h-10" src="<?php echo e(asset('public/' . $logo)); ?>" alt="">
                    <button id="closeCategorySidebar" class="text-gray-600 hover:text-[<?php echo e($theme->theme_bg); ?>]">
                        <i class="ri-close-line text-2xl"></i>
                    </button>
                </div>

                <!-- Category List with Smooth Subcategories -->
                <ul class="flex flex-col divide-y divide-gray-200 overflow-auto">
                    <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="flex flex-col">
                            <!-- Main Category -->
                            <div class="flex items-center justify-between px-4 py-3 hover:bg-[<?php echo e($theme->theme_bg); ?>]/50 cursor-pointer"
                                onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'">
                                <div class="flex items-center gap-3">
                                    <img src="<?php echo e(asset('public/' . $category->image ?? 'default-category.png')); ?>"
                                        alt="<?php echo e($category->name); ?>" class="w-8 h-8 object-cover rounded">
                                    <span class="text-gray-700 font-medium"><?php echo e($category->name); ?></span>
                                </div>
                                <?php if($category->subcategories->count()): ?>
                                    <i class="ri-arrow-down-s-line text-gray-500 text-xl"
                                        onclick="event.stopPropagation(); toggleSubcategory(this)"></i>
                                <?php endif; ?>
                            </div>

                            <!-- Subcategory List -->
                            <?php if($category->subcategories->count()): ?>
                                <ul
                                    class="max-h-0 overflow-hidden transition-all duration-300 ease-in-out flex-col divide-y divide-gray-200 bg-gray-50">
                                    <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="flex items-center gap-3 px-8 py-3 hover:bg-[<?php echo e($theme->theme_bg); ?>]/50 cursor-pointer"
                                            onclick="window.location.href='<?php echo e(route('subcategory.product', $subcategory->slug)); ?>'">
                                            <span class="text-gray-600 text-sm"><?php echo e($subcategory->name); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </nav>
        </div>

        <!-- Desktop Navigation Bar -->
        <div class="bg-[<?php echo e($theme->nav_bg); ?>] w-full hidden sm:block">
            <div class="max-w-6xl mx-auto flex items-center justify-between h-12">
                <!-- Left: All Categories -->
                <div id="categoryButton"
                    class="mobileMenuBtn flex items-center justify-between gap-2 bg-[<?php echo e($theme->theme_bg); ?>] px-3 h-full cursor-pointer hover:[<?php echo e($theme->theme_hover); ?>] transition">
                    <span class="text-[<?php echo e($theme->theme_text); ?>] font-medium text-[14.5px] uppercase">All
                        Categories</span>
                    <i class="ri-menu-line text-[<?php echo e($theme->theme_text); ?>] text-lg"></i>
                </div>

                <!-- Right: Nav Links -->
                <div class="flex items-center gap-6">
                    <a href="<?php echo e(url('/')); ?>"
                        class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14.5px] hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Home</a>
                    <a href="<?php echo e(url('/your/shop')); ?>"
                        class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14.5px] hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Shop</a>
                    <a href="<?php echo e(url('deals')); ?>"
                        class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14.5px] hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Deals</a>
                    <a href="<?php echo e(url('/contact')); ?>"
                        class="text-[<?php echo e($theme->nav_text); ?>] hover:text-[<?php echo e($theme->theme_bg); ?>] text-[14.5px] hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Contact</a>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('content'); ?>

    <!-- =================== <?php echo e($setting->name); ?> FOOTER =================== -->

    <!-- =================== <?php echo e($setting->name); ?> FOOTER =================== -->
    <footer class="bg-gray-900 text-gray-300 pt-12 pb-6 md:mb-0 mb-14">
        <div class="max-w-6xl mx-auto px-4">

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-10">

                <!-- Brand Info -->
                <div>
                    <img class="max-w-48 w-auto h-20 mb-4" src="<?php echo e(asset('public/' . $logo)); ?>" alt="">
                    <p class="text-sm text-gray-400 leading-relaxed mb-4">
                        Your trusted online store for smart gadgets, electronics, fashion and more.
                        Shop confidently — fast delivery, secure payment, and 24/7 customer support.
                    </p>

                    <?php
                        $socialStyles = [
                            'Facebook' => [
                                'icon' => 'ri-facebook-fill',
                                'hover' => 'hover:bg-blue-600',
                            ],
                            'Instagram' => [
                                'icon' => 'ri-instagram-line',
                                'hover' => 'hover:bg-pink-500',
                            ],
                            'Twitter' => [
                                'icon' => 'ri-twitter-x-line',
                                'hover' => 'hover:bg-blue-400',
                            ],
                            'YouTube' => [
                                'icon' => 'ri-youtube-fill',
                                'hover' => 'hover:bg-red-600',
                            ],
                            'LinkedIn' => [
                                'icon' => 'ri-linkedin-fill',
                                'hover' => 'hover:bg-blue-700',
                            ],
                            'Pinterest' => [
                                'icon' => 'ri-pinterest-fill',
                                'hover' => 'hover:bg-red-500',
                            ],
                            'WhatsApp API' => [
                                'icon' => 'ri-whatsapp-line',
                                'hover' => 'hover:bg-green-500',
                            ],
                        ];
                    ?>

                    <div class="flex gap-3 mt-4">
                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $style = $socialStyles[$item->name] ?? null;
                            ?>

                            <?php if($style): ?>
                                <a href="<?php echo e($item->link); ?>" target="_blank"
                                    class="w-10 h-10 flex items-center justify-center bg-gray-800 rounded-full transition <?php echo e($style['hover']); ?>">
                                    <i class="<?php echo e($style['icon']); ?> text-white text-lg"></i>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Top Categories -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Top Categories</h3>
                    <ul class="space-y-2 text-sm">
                        <?php $__currentLoopData = $topCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('category.product', $category->slug)); ?>"
                                    class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition"><?php echo e($category->name); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <!-- Services -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Our Services</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Free
                                Shipping</a></li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Easy Returns</a>
                        </li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">24/7 Support</a>
                        </li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Warranty
                                Policy</a></li>
                        <li><a href="#" class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Affiliate
                                Program</a></li>
                    </ul>
                </div>

                <!-- Newsletter & Payment -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Stay Connected</h3>
                    <p class="text-sm text-gray-400 mb-3">
                        Subscribe to our newsletter for latest product updates, offers & news.
                    </p>
                    <form class="flex bg-gray-800 rounded-lg overflow-hidden mb-3">
                        <input type="email" placeholder="Enter your email"
                            class="w-full px-3 py-2 bg-gray-800 text-gray-300 text-sm focus:outline-none">
                        <button
                            class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] px-4 font-semibold text-sm transition">Join</button>
                    </form>
                    <p class="text-xs text-gray-500 mb-4">We respect your privacy. Unsubscribe anytime.</p>

                    <h3 class="text-lg font-semibold text-white mb-2">Payment Methods</h3>
                    <div class="flex gap-3 mt-2">
                        <img src="https://www.projapotishop.com/public/frontEnd/images/payment2.png" alt="Visa"
                            class="w-72">
                    </div>
                </div>

            </div>

            <div class="border-t border-gray-700 my-6"></div>

            <div class="flex flex-col sm:flex-row justify-between items-center text-sm text-gray-400">
                <p>© <?php echo e(date('Y')); ?> <span class="text-white font-semibold"><?php echo e($setting->name); ?></span> — All
                    rights reserved.
                </p>
                <div class="flex flex-wrap justify-center gap-4 mt-3 sm:mt-0">
                    <a href="<?php echo e(url('/privacy-policy')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Privacy
                        Policy</a>
                    <a href="<?php echo e(url('/terms-and-conditions')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Terms of
                        Use</a>
                    <a href="<?php echo e(url('/help-center')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Help
                        Center</a>
                    <a href="<?php echo e(url('/order/tracking')); ?>"
                        class="hover:text-[<?php echo e($theme->theme_bg); ?>] transition">Track Order</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bottom Navbar -->
    <nav
        class="nav-btn-section fixed bottom-0 left-0 w-full bg-white/70 backdrop-blur-md border-t border-white/20 shadow-md z-50 block md:hidden">
        <ul class="flex justify-around">
            <!-- Home -->
            <li class="flex-1">
                <a href="<?php echo e(route('home')); ?>"
                    class="nav-item flex flex-col items-center justify-center py-2 relative text-gray-700">
                    <i class="ri-home-5-line text-2xl"></i>
                    <span class="text-xs">Home</span>
                    <span
                        class="nav-indicator absolute bottom-0 w-0 h-[2px] bg-[<?php echo e($theme->theme_bg); ?>] transition-all"></span>
                </a>
            </li>

            <!-- Shop -->
            <li class="flex-1">
                <a href="<?php echo e(route('shop')); ?>"
                    class="nav-item flex flex-col items-center justify-center py-2 relative text-gray-700">
                    <i class="ri-store-line text-2xl"></i>
                    <span class="text-xs">Shop</span>
                    <span
                        class="nav-indicator absolute bottom-0 w-0 h-[2px] bg-[<?php echo e($theme->theme_bg); ?>] transition-all"></span>
                </a>
            </li>

            <!-- Cart -->
            <li class="flex-1">
                <a href="<?php echo e(route('cart.index')); ?>"
                    class="nav-item flex flex-col items-center justify-center py-2 relative text-gray-700">
                    <i class="ri-shopping-cart-line text-2xl"></i>
                    <span class="text-xs">Cart</span>
                    <span
                        class="nav-indicator absolute bottom-0 w-0 h-[2px] bg-[<?php echo e($theme->theme_bg); ?>] transition-all"></span>
                </a>
            </li>

            <!-- Track -->
            <li class="flex-1">
                <a href="<?php echo e(route('order.tracking')); ?>"
                    class="nav-item flex flex-col items-center justify-center py-2 relative text-gray-700">
                    <i class="ri-map-pin-line text-2xl"></i>
                    <span class="text-xs">Track</span>
                    <span
                        class="nav-indicator absolute bottom-0 w-0 h-[2px] bg-[<?php echo e($theme->theme_bg); ?>] transition-all"></span>
                </a>
            </li>
            <li class="flex-1">
                <?php if(Auth::guard('customer')->check()): ?>
                <button onclick="toggleProfileSidebar()" class="w-full flex flex-col items-center justify-center py-2 text-gray-600">
                    <i class="ri-user-3-line text-2xl"></i>
                    <span class="text-xs font-medium">Account</span>
                </button>
                <?php else: ?>
                    <a href="#" id="loginBtn"
                        class="loginBtn nav-item flex flex-col items-center justify-center py-2 relative text-gray-700">
                        <i class="ri-login-box-line text-2xl"></i>
                        <span class="text-xs">Login</span>
                        <span
                            class="nav-indicator absolute bottom-0 w-0 h-[2px] bg-[<?php echo e($theme->theme_bg); ?>] transition-all"></span>
                    </a>
                <?php endif; ?>
            </li>
        </ul>
    </nav>
    
    <div id="profileSidebar" class="fixed inset-0 z-[60] invisible overflow-hidden" role="dialog" aria-modal="true">
    <div id="sidebarBackdrop" onclick="toggleProfileSidebar()" class="absolute inset-0 bg-black/50 opacity-0 transition-opacity duration-300"></div>
    
    <div id="sidebarContent" class="absolute right-0 top-0 h-full w-[280px] bg-white shadow-2xl translate-x-full transition-transform duration-300 ease-in-out">
        <div class="flex flex-col h-full">
            <div class="p-6 text-center border-b bg-gray-50">
                <div class="relative inline-block">
                    <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::guard('customer')->user()->name ?? 'User'); ?>&background=random" 
                         alt="Profile" 
                         class="w-20 h-20 rounded-full border-4 border-white shadow-sm mx-auto">
                    <div class="absolute bottom-0 right-0 w-5 h-5 bg-green-500 border-2 border-white rounded-full"></div>
                </div>
                <h4 class="mt-3 font-bold text-gray-800"><?php echo e(Auth::guard('customer')->user()->name ?? 'Guest User'); ?></h4>
                <p class="text-xs text-gray-500"><?php echo e(Auth::guard('customer')->user()->email ?? ''); ?></p>
            </div>

            <div class="flex-1 py-4">
                <ul class="space-y-1 px-4">
                    <li>
                        <a href="<?php echo e(route('customer.account')); ?>" class="flex items-center gap-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg transition-colors">
                            <i class="ri-dashboard-line text-xl text-blue-500"></i>
                            <span class="font-medium">My Account</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('customer.orders')); ?>" class="flex items-center gap-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg transition-colors">
                            <i class="ri-shopping-bag-3-line text-xl text-purple-500"></i>
                            <span class="font-medium">My Orders</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="p-4 border-t">
                <form method="POST" action="<?php echo e(route('customer.logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full flex items-center justify-center gap-2 p-3 bg-red-50 text-red-600 font-bold rounded-xl hover:bg-red-100 transition-colors">
                        <i class="ri-logout-box-r-line"></i>
                        Logout
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleProfileSidebar() {
        const sidebar = document.getElementById('profileSidebar');
        const backdrop = document.getElementById('sidebarBackdrop');
        const content = document.getElementById('sidebarContent');

        if (sidebar.classList.contains('invisible')) {
            // Open Sidebar
            sidebar.classList.remove('invisible');
            setTimeout(() => {
                backdrop.classList.replace('opacity-0', 'opacity-100');
                content.classList.replace('translate-x-full', 'translate-x-0');
            }, 10);
        } else {
            // Close Sidebar
            backdrop.classList.replace('opacity-100', 'opacity-0');
            content.classList.replace('translate-x-0', 'translate-x-full');
            setTimeout(() => {
                sidebar.classList.add('invisible');
            }, 300);
        }
    }
</script>

    <!-- Modal Overlay -->
    <div id="modalOverlay" class="hidden fixed inset-0 bg-black bg-opacity-50 z-40"></div>

    <!-- Modal Container -->
    <div id="modalContainer" class="hidden fixed inset-0 flex items-center justify-center z-50 border px-2 py-10">
        <div class="bg-white rounded-lg w-full max-w-xl p-6 relative border">
            <button id="closeModal"
                class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-xl">&times;</button>

            <!-- Login Form -->
            <div id="loginForm">
                <h2 class="text-2xl font-bold mb-4 block text-center">Customer Login</h2>
                <div id="loginMsg" class="text-sm mb-2"></div>
                <form id="loginAjaxForm">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label class="block text-sm text-gray-600 mb-1.5">Email or Phone</label>
                        <input type="text" name="email" placeholder="Enter your email or phone" required
                            class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                    </div>
                    <div class="mb-3">
                        <label class="block text-sm text-gray-600 mb-1.5">Password</label>
                        <input type="password" name="password" placeholder="Enter your password" required
                            class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                    </div>
                    <div class="w-full flex justify-end mb-4">
                        <a href="<?php echo e(route('customer.forget')); ?>"
                            class="text-sm flex items-center gap-1 text-gray-500 hover:text-[<?php echo e($theme->theme_bg); ?>] transition font-medium">
                            <i class="ri-question-line text-base"></i>
                            Forgot password?
                        </a>
                    </div>
                    <button type="submit"
                        class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-white font-medium py-2 rounded transition">Login</button>
                </form>
                <p class="text-sm mt-3 text-gray-600 block text-center">Don't have an account?
                    <a href="#" id="switchToRegister" class="text-green-600 hover:underline">Register</a>
                </p>
                <div class="mt-3">
                    <a href="https://accounts.google.com/o/oauth2/v2/auth?client_id=<?php echo e(env('GOOGLE_CLIENT_ID')); ?>&redirect_uri=<?php echo e(env('GOOGLE_REDIRECT_URI')); ?>&response_type=code&scope=openid%20profile%20email"
                        class="flex-1 flex items-center justify-center gap-2 border border-gray-300 py-2 rounded-md hover:bg-gray-100 transition">
                        <img src="https://www.svgrepo.com/show/475656/google-color.svg" class="w-5 h-5"
                            alt="Google">
                        <span>Continue with Google</span>
                    </a>
                </div>
            </div>

            <!-- Registration Form -->
            <div id="registerForm" class="hidden">
                <h2 class="text-2xl font-bold mb-4 text-center">Registration</h2>
                <div id="registerMsg" class="text-sm mb-2"></div>
                <form id="registerAjaxForm">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label class="block text-sm text-gray-600 mb-1.5">Name</label>
                        <input type="text" name="name" placeholder="Enter your full name" required
                            class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                    </div>
                    <div class="mb-3">
                        <label class="block text-sm text-gray-600 mb-1.5">Email</label>
                        <input type="email" name="email" placeholder="Enter your email" required
                            class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                    </div>
                    <div class="mb-3">
                        <label class="block text-sm text-gray-600 mb-1.5">Phone</label>
                        <input type="text" name="phone" placeholder="Enter your phone number" required
                            class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2
    text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                    </div>
                    <div class="mb-3 grid grid-cols-1 sm:grid-cols-2 gap-3">
                        <div>
                            <label class="block text-sm text-gray-600 mb-1.5">Password</label>
                            <input type="password" name="password" placeholder="Enter your password" required
                                class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2 text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-600 mb-1.5">Confirm Password</label>
                            <input type="password" name="password_confirmation" placeholder="Confirm your password"
                                required
                                class="w-full rounded-md bg-white text-gray-900 border border-gray-300 px-3 py-2 text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200">
                        </div>
                    </div>
                    <button type="submit"
                        class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-white font-medium py-2 rounded transition">Register</button>
                </form>
                <p class="text-sm mt-3 text-gray-600 block text-center">Already have an account?
                    <a href="#" id="switchToLogin" class="text-indigo-600 hover:underline">Login</a>
                </p>
                <div class="mt-3">
                    <a href="https://accounts.google.com/o/oauth2/v2/auth?client_id=<?php echo e(env('GOOGLE_CLIENT_ID')); ?>&redirect_uri=<?php echo e(env('GOOGLE_REDIRECT_URI')); ?>&response_type=code&scope=openid%20profile%20email"
                        class="flex-1 flex items-center justify-center gap-2 border border-gray-300 py-2 rounded-md hover:bg-gray-100 transition">
                        <img src="https://www.svgrepo.com/show/475656/google-color.svg" class="w-5 h-5"
                            alt="Google">
                        <span>Continue with Google</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {

            // Open modal
            $(".loginBtn").each(function() {
                $(this).on("click", function() {
                    $("#modalOverlay, #modalContainer").removeClass("hidden");
                    $("#loginForm").show();
                    $("#registerForm").hide();
                });
            });
            $("#registerBtn").click(function() {
                $("#modalOverlay, #modalContainer").removeClass("hidden");
                $("#registerForm").show();
                $("#loginForm").hide();
            });

            // Close modal
            $("#closeModal, #modalOverlay").click(function() {
                $("#modalOverlay, #modalContainer").addClass("hidden");
            });

            // Switch forms
            $("#switchToRegister").click(function() {
                $("#loginForm").hide();
                $("#registerForm").show();
            });
            $("#switchToLogin").click(function() {
                $("#registerForm").hide();
                $("#loginForm").show();
            });

            // Login AJAX
            $("#loginAjaxForm").submit(function(e) {
                e.preventDefault();
                $("#loginMsg").text('');
                $.ajax({
                    url: "<?php echo e(route('customer.login')); ?>",
                    method: "POST",
                    data: $(this).serialize(),
                    success: function(res) {
                        if (res.success) {
                            $("#loginMsg").text(res.message).addClass("text-green-600");
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#loginMsg").text(res.message).addClass("text-red-600");
                        }
                    },
                    error: function(err) {
                        $("#loginMsg").text("Invalid credentials or error!").addClass(
                            "text-red-600");
                    }
                });
            });

            // Register AJAX
            $("#registerAjaxForm").submit(function(e) {
                e.preventDefault();
                $("#registerMsg").text('');
                $.ajax({
                    url: "<?php echo e(route('customer.register')); ?>",
                    method: "POST",
                    data: $(this).serialize(),
                    success: function(res) {
                        if (res.success) {
                            $("#registerMsg").text(res.message).addClass("text-green-600");
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#registerMsg").text(res.message).addClass("text-red-600");
                        }
                    },
                    error: function(err) {
                        let errors = err.responseJSON.errors;
                        let msg = Object.values(errors).map(e => e.join(', ')).join(' | ');
                        $("#registerMsg").text(msg).addClass("text-red-600");
                    }
                });
            });

        });
    </script>


    <script>
        const navSection = document.querySelector('.nav-btn-section');
        const openFilter = document.getElementById('openFilter');
        const closeFilter = document.getElementById('closeFilter');

        // OPEN = hide nav-btn-section
        openFilter.addEventListener('click', () => {
            navSection.classList.add('hidden');
        });

        // CLOSE = show nav-btn-section
        closeFilter.addEventListener('click', () => {
            navSection.classList.remove('hidden');
        });
    </script>

    <!-- Active State Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const navItems = document.querySelectorAll('.nav-item');

            navItems.forEach(item => {
                if (item.href === window.location.href) {
                    item.classList.add('text-[<?php echo e($theme->theme_bg); ?>]');
                    item.querySelector('.nav-indicator').classList.add('w-full');
                }
            });

            navItems.forEach(item => {
                item.addEventListener('click', () => {
                    navItems.forEach(i => {
                        i.classList.remove('text-[<?php echo e($theme->theme_bg); ?>]');
                        i.querySelector('.nav-indicator').classList.remove('w-full');
                    });

                    item.classList.add('text-[<?php echo e($theme->theme_bg); ?>]');
                    item.querySelector('.nav-indicator').classList.add('w-full');
                });
            });
        });
    </script>

    <style>
        .nav-item:hover i,
        .nav-item:hover span {
            color: #f97316;
            transform: translateY(-2px);
            transition: all 0.3s ease;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const searchBox = document.getElementById('searchBox');

            async function handleSearch() {
                const query = searchInput.value.trim();
                if (query.length === 0) {
                    searchBox.classList.add('hidden');
                    searchBox.innerHTML = '';
                    return;
                }

                try {
                    const response = await fetch(`/search/products?query=${encodeURIComponent(query)}`);
                    if (!response.ok) throw new Error('Network response was not ok');

                    const products = await response.json();

                    searchBox.innerHTML = '';
                    if (products.length === 0) {
                        searchBox.innerHTML =
                            `<div class="p-4 text-center text-gray-500">Products not found</div>`;
                    } else {
                        products.forEach(product => {

                            const imageUrl = product.image ?
                                `/public/uploads/products/${product.image}` :
                                '/public/uploads/products/placeholder.jpg';

                            const item = document.createElement('div');
                            item.className =
                                "flex items-center justify-between p-3 hover:bg-gray-50 border-b border-gray-50 cursor-pointer";
                            item.innerHTML = `
                        <div class="flex items-center gap-3">
                            <img src="${imageUrl}" alt="Product" class="w-10 h-10 object-cover rounded-full">
                            <div>
                                <p class="text-gray-800 line-clamp-1 mb-0.5">${product.name}</p>
                                <p class="text-gray-500 text-sm">&#2547;${product.price}</p>
                            </div>
                        </div>
                        <div class="text-gray-500 text-xl">
                            <i class="ri-arrow-right-s-line"></i>
                        </div>
                    `;
                            item.addEventListener('click', () => {
                                window.location.href = `/product/${product.slug}`;
                            });
                            searchBox.appendChild(item);
                        });
                    }
                    searchBox.classList.remove('hidden');
                } catch (error) {
                    searchBox.innerHTML =
                        `<div class="p-4 text-center text-red-500">Error loading products</div>`;
                    searchBox.classList.remove('hidden');
                    console.error(error);
                }
            }

            // Debounce function to limit AJAX calls
            function debounce(func, delay = 300) {
                let timeout;
                return function(...args) {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(this, args), delay);
                }
            }

            searchInput.addEventListener('input', debounce(handleSearch, 300));

            // Hide dropdown on click outside
            document.addEventListener('click', (e) => {
                if (!document.getElementById('searchEngine').contains(e.target)) {
                    searchBox.classList.add('hidden');
                }
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const MobilesearchInput = document.getElementById('MobilesearchInput');
            const MobilesearchBox = document.getElementById('MobilesearchBox');

            async function handleSearch() {
                const query = MobilesearchInput.value.trim();
                if (query.length === 0) {
                    MobilesearchBox.classList.add('hidden');
                    MobilesearchBox.innerHTML = '';
                    return;
                }

                try {
                    const response = await fetch(`/search/products?query=${encodeURIComponent(query)}`);
                    if (!response.ok) throw new Error('Network response was not ok');

                    const products = await response.json();

                    MobilesearchBox.innerHTML = '';
                    if (products.length === 0) {
                        MobilesearchBox.innerHTML =
                            `<div class="p-4 text-center text-gray-500">Products not found</div>`;
                    } else {
                        products.forEach(product => {

                            const imageUrl = product.image ?
                                `/public/uploads/products/${product.image}` :
                                '/public/uploads/products/placeholder.jpg';

                            const item = document.createElement('div');
                            item.className =
                                "flex items-center justify-between p-3 hover:bg-gray-50 border-b border-gray-50 cursor-pointer";
                            item.innerHTML = `
                        <div class="flex items-center gap-3">
                            <img src="${imageUrl}" alt="Product" class="w-10 h-10 object-cover rounded-full">
                            <div>
                                <p class="text-gray-800 line-clamp-1 mb-0.5">${product.name}</p>
                                <p class="text-gray-500 text-sm">&#2547;${product.price}</p>
                            </div>
                        </div>
                        <div class="text-gray-500 text-xl">
                            <i class="ri-arrow-right-s-line"></i>
                        </div>
                    `;
                            item.addEventListener('click', () => {
                                window.location.href = `/product/${product.slug}`;
                            });
                            MobilesearchBox.appendChild(item);
                        });
                    }
                    MobilesearchBox.classList.remove('hidden');
                } catch (error) {
                    MobilesearchBox.innerHTML =
                        `<div class="p-4 text-center text-red-500">Error loading products</div>`;
                    MobilesearchBox.classList.remove('hidden');
                    console.error(error);
                }
            }

            // Debounce function to limit AJAX calls
            function debounce(func, delay = 300) {
                let timeout;
                return function(...args) {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => func.apply(this, args), delay);
                }
            }

            MobilesearchInput.addEventListener('input', debounce(handleSearch, 300));

            // Hide dropdown on click outside
            document.addEventListener('click', (e) => {
                if (!document.getElementById('MobilesearchEngine').contains(e.target)) {
                    searchBox.classList.add('block');
                }
            });
        });
    </script>

    <script>
        function toggleSubcategory(icon) {
            const subList = icon.closest('li').querySelector('ul');
            if (!subList) return;

            if (subList.style.maxHeight && subList.style.maxHeight !== '0px') {
                // slide up
                subList.style.maxHeight = '0px';
                icon.classList.remove('ri-arrow-up-s-line');
                icon.classList.add('ri-arrow-down-s-line');
            } else {
                // slide down
                subList.style.maxHeight = subList.scrollHeight + 'px';
                icon.classList.remove('ri-arrow-down-s-line');
                icon.classList.add('ri-arrow-up-s-line');
            }
        }

        // Optional: Reset all sublists on page load
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('ul > li > ul').forEach(ul => {
                ul.style.maxHeight = '0px';
            });
        });
    </script>

    <script>
        const categoryButton = document.getElementById('categoryButton');
        const categoryList = document.getElementById('categoryList');

        function syncCategoryWidth() {
            if (categoryList && categoryButton) {
                const width = categoryList.offsetWidth;
                categoryButton.style.width = width + 'px';
            }
        }

        syncCategoryWidth();

        window.addEventListener('resize', syncCategoryWidth);

        const observer = new ResizeObserver(syncCategoryWidth);
        observer.observe(categoryList);
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const searchBox = document.getElementById('searchBox');

            function syncSearchBoxWidth() {
                if (searchInput && searchBox) {
                    const width = searchInput.getBoundingClientRect().width;
                    searchBox.style.width = width + 'px';
                }
            }

            setTimeout(() => {
                requestAnimationFrame(syncSearchBoxWidth);
            }, 100);

            window.addEventListener('resize', syncSearchBoxWidth);

            const observer = new ResizeObserver(syncSearchBoxWidth);
            observer.observe(searchInput);
        });
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#categoryScroll').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 1000,
                smartSpeed: 1000,
                responsive: {
                    0: {
                        items: 3
                    },
                    640: {
                        items: 4
                    },
                    768: {
                        items: 5
                    },
                    1024: {
                        items: 7
                    },
                    1280: {
                        items: 8
                    }
                }
            });

            $('#hotdealScroll').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 2000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                stagePadding: 5,
                responsive: {
                    0: {
                        items: 2
                    },
                    480: {
                        items: 2
                    },
                    768: {
                        items: 4
                    },
                    1024: {
                        items: 5
                    }
                },
            });

            $('#banner').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 2000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                stagePadding: 0,
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    768: {
                        items: 1
                    },
                    1024: {
                        items: 1
                    }
                },
            });

            $('#desktopProduct').owlCarousel({
                loop: true,
                margin: 10,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplaySpeed: 2000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                stagePadding: 0,
                responsive: {
                    0: {
                        items: 5
                    },
                    480: {
                        items: 5
                    },
                    768: {
                        items: 5
                    },
                    1024: {
                        items: 5
                    }
                },
            });

            $(document).ready(function() {
                var owl = $('#phoneProduct');
                owl.owlCarousel({
                    loop: true,
                    margin: 10,
                    nav: false,
                    dots: false,
                    autoplay: true,
                    autoplayTimeout: 3000,
                    autoplaySpeed: 2000,
                    smartSpeed: 1000,
                    autoplayHoverPause: true,
                    stagePadding: 0,
                    responsive: {
                        0: {
                            items: 1
                        },
                        480: {
                            items: 1
                        },
                        768: {
                            items: 1
                        },
                        1024: {
                            items: 1
                        }
                    },
                    onInitialized: updateCounter,
                    onTranslated: updateCounter
                });

                function updateCounter(event) {
                    var element = event.target;
                    var items = event.item.count;
                    var item = event.item.index - event.relatedTarget._clones.length / 2;
                    if (item > items || item === 0) {
                        item = items;
                    }
                    $('#productCounter').text(item + ' / ' + items);
                }
            });

        });
    </script>

    <script>
        document.getElementById('categoryButton').addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>

    <script>
        // Multiple buttons by class
        const menuBtns = document.querySelectorAll('.mobileMenuBtn'); // note: class, not id
        const menu = document.getElementById('mobileMenu');
        const categoryCloseBtn = document.getElementById('closeCategorySidebar');

        function openMenu() {
            menu.style.transform = 'translateX(0)';
        }

        function closeMenu() {
            menu.style.transform = 'translateX(-100%)';
        }

        // Loop through all buttons and attach click
        menuBtns.forEach(btn => {
            btn.addEventListener('click', openMenu);
        });

        categoryCloseBtn.addEventListener('click', closeMenu);

        // Close menu if click outside
        document.addEventListener('click', function(event) {
            let clickedInsideMenuBtn = false;
            menuBtns.forEach(btn => {
                if (btn.contains(event.target)) clickedInsideMenuBtn = true;
            });

            if (!menu.contains(event.target) && !clickedInsideMenuBtn) {
                closeMenu();
            }
        });

        // Subcategory toggle
        function toggleSubcategory(icon) {
            const subList = icon.closest('li').querySelector('ul');
            if (!subList) return;

            if (subList.style.maxHeight && subList.style.maxHeight !== '0px') {
                // slide up
                subList.style.maxHeight = '0px';
                icon.classList.remove('ri-arrow-up-s-line');
                icon.classList.add('ri-arrow-down-s-line');
            } else {
                // slide down
                subList.style.maxHeight = subList.scrollHeight + 'px';
                icon.classList.remove('ri-arrow-down-s-line');
                icon.classList.add('ri-arrow-up-s-line');
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('ul > li > ul').forEach(ul => {
                ul.style.maxHeight = '0px';
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const timer = document.getElementById("hot-deal-timer");
            if (!timer) return;

            const endDate = new Date(timer.dataset.endDate).getTime();

            function updateTimer() {
                const now = new Date().getTime();
                const distance = endDate - now;

                if (distance <= 0) {
                    document.getElementById("hours").textContent = "00";
                    document.getElementById("minutes").textContent = "00";
                    document.getElementById("seconds").textContent = "00";
                    clearInterval(timerInterval);
                    return;
                }

                const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                document.getElementById("hours").textContent = String(hours).padStart(2, '0');
                document.getElementById("minutes").textContent = String(minutes).padStart(2, '0');
                document.getElementById("seconds").textContent = String(seconds).padStart(2, '0');
            }

            const timerInterval = setInterval(updateTimer, 1000);
            updateTimer();
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/@studio-freight/lenis@1.0.29/bundled/lenis.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const lenis = new Lenis({
                duration: 1.2,
                smooth: true
            });

            const searchBox = document.getElementById('searchBox');
            if (searchBox) {
                searchBox.addEventListener('wheel', (e) => {
                    e.stopPropagation();
                });
                searchBox.addEventListener('touchmove', (e) => {
                    e.stopPropagation();
                });
            }

            function raf(time) {
                lenis.raf(time);
                requestAnimationFrame(raf);
            }
            requestAnimationFrame(raf);
        });
    </script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast/dist/css/iziToast.min.css">
    <script src="https://cdn.jsdelivr.net/npm/izitoast/dist/js/iziToast.min.js"></script>

</body>

</html>
<?php /**PATH /home/allbdinc/public_html/resources/views/frontend/layouts/master.blade.php ENDPATH**/ ?>