
<?php $__env->startSection('title', $product->name); ?>
<?php $__env->startSection('content'); ?>
<?php $__env->startSection('meta'); ?>
    <?php
        $ogImage = $product->images->first()
            ? asset('public/uploads/products/' . $product->images->first()->image)
            : asset('public/' . $setting->icon);
    ?>

    <meta property="og:type" content="product">
    <meta property="og:title" content="<?php echo e($product->name); ?>">
    <meta property="og:description" content="<?php echo e(Str::limit(strip_tags($product->desc), 160)); ?>">
    <meta property="og:url" content="<?php echo e(route('product.details', $product->slug)); ?>">
    <meta property="og:image" content="<?php echo e($ogImage); ?>">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($product->name); ?>">
    <meta name="twitter:description" content="<?php echo e(Str::limit(strip_tags($product->desc), 160)); ?>">
    <meta name="twitter:image" content="<?php echo e($ogImage); ?>">
<?php $__env->stopSection(); ?>
<style>
    #mainImageContainer {
        position: relative;
    }

    #zoomResult {
        pointer-events: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }

    @media (max-width: 768px) {
        #zoomResult {
            display: none !important;
        }
    }
</style>

<div class="max-w-6xl mx-auto grid grid-cols-12 md:my-4 mb-4">
    <div class="border-b col-span-12 block md:hidden relative">
        <div id="phoneProduct" class="owl-carousel owl-theme flex items-center gap-2">
            <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $productPath = 'public/uploads/products/' . $image;
                    $variantPath = 'public/uploads/products/variants/' . $image;

                    if (file_exists($variantPath)) {
                        $finalPath = $variantPath;
                    } else {
                        $finalPath = $productPath;
                    }
                ?>
                <img loading="lazy" src="<?php echo e(asset($finalPath)); ?>" alt="<?php echo e($product->name); ?>"
                    class="w-full h-full max-h-auto object-initial">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div id="productCounter"
            class="absolute left-1/2 transform -translate-x-1/2 bottom-5 text-white text-sm bg-black/40 px-3 py-1 rounded z-20">
        </div>
    </div>

    <div class="md:col-span-4 col-span-12 flex flex-col gap-3 items-center justify-start bg-white flex">

        <div id="mainImageContainer"
            class="w-full border-b border-r border-gray-100 px-3 py-3 hidden md:block relative min-h-[300px]">

            <?php if($product->video_file || $product->video_url): ?>
                <div id="video_main_display" class="w-full h-full">
                    <?php if($product->video_file): ?>
                        <video id="mainVideoPlayer" controls autoplay muted loop playsinline
                            class="w-full h-full rounded shadow">
                            <source src="<?php echo e(asset('public/uploads/products/videos/' . $product->video_file)); ?>"
                                type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    <?php elseif($product->video_url): ?>
                        <?php
                            preg_match(
                                '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i',
                                $product->video_url,
                                $match,
                            );
                            $youtube_id = $match[1] ?? null;
                        ?>
                        <?php if($youtube_id): ?>
                            <iframe id="mainYoutubePlayer" class="w-full aspect-video rounded shadow"
                                src="https://www.youtube.com/embed/<?php echo e($youtube_id); ?>" frameborder="0"
                                allowfullscreen>
                            </iframe>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>

                <img loading="lazy" id="mainImage"
                    src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                    alt="<?php echo e($product->name); ?>" class="w-full h-auto object-cover hidden cursor-crosshair">
                <div id="zoomResult"
                    class="absolute top-0 left-full ml-4 w-[400px] h-[400px] border shadow-lg bg-no-repeat bg-white hidden z-[9999]">
                </div>
            <?php else: ?>
                <img loading="lazy" id="mainImage"
                    src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                    alt="<?php echo e($product->name); ?>" class="w-full h-auto object-cover cursor-crosshair">
                <div id="zoomResult"
                    class="absolute top-0 left-full ml-4 w-[400px] h-[400px] border shadow-lg bg-no-repeat bg-white hidden z-[9999]">
                </div>
            <?php endif; ?>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const container = document.getElementById('mainImageContainer');
                const img = document.getElementById('mainImage');
                const result = document.getElementById('zoomResult');

                container.addEventListener('mousemove', moveLens);
                container.addEventListener('mouseenter', showZoom);
                container.addEventListener('mouseleave', hideZoom);

                function showZoom() {
                    result.classList.remove('hidden');
                    result.style.backgroundImage = `url('${img.src}')`;
                    result.style.backgroundSize = `${img.width * 2}px ${img.height * 2}px`;
                }

                function hideZoom() {
                    result.classList.add('hidden');
                }

                function moveLens(e) {
                    const pos = getCursorPos(e);

                    let x = pos.x;
                    let y = pos.y;

                    let xPercent = (x / img.width) * 100;
                    let yPercent = (y / img.height) * 100;

                    result.style.backgroundPosition = `${xPercent}% ${yPercent}%`;
                }

                function getCursorPos(e) {
                    let a = img.getBoundingClientRect();
                    let x = e.pageX - a.left;
                    let y = e.pageY - a.top;
                    x = x - window.pageXOffset;
                    y = y - window.pageYOffset;
                    return {
                        x: x,
                        y: y
                    };
                }
            });
        </script>

        <div id="desktopProduct" class="owl-carousel owl-theme flex gap-2 pb-1 md:pb-3 md:pt-0 pt-2 px-3">

            <?php if($product->video_file || $product->video_url): ?>
                <div class="h-16 w-16 flex flex-col items-center justify-center bg-black rounded shadow cursor-pointer border-2 border-orange-500"
                    onclick="showVideo()">
                    <i class="ri-play-circle-fill text-white text-3xl"></i>
                    <span class="text-[10px] text-white font-bold">VIDEO</span>
                </div>
            <?php endif; ?>

            <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $productPath = 'public/uploads/products/' . $image;
                    $variantPath = 'public/uploads/products/variants/' . $image;
                    $finalPath = file_exists(base_path($variantPath)) ? $variantPath : $productPath;

                    $variantId = 0;
                    foreach ($variants as $variant) {
                        if (isset($variant['images']) && in_array($image, $variant['images'])) {
                            $variantId = $variant['id'];
                            break;
                        }
                    }
                ?>

                <img loading="lazy" src="<?php echo e(asset($finalPath)); ?>" alt="<?php echo e($product->name); ?>"
                    class="h-16 w-16 object-cover rounded shadow mx-auto cursor-pointer border transition duration-200 hover:border-orange-500"
                    data-variant-id="<?php echo e($variantId); ?>" onclick="changeToImage(this)">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <script>
        function changeToImage(element) {
            const mainImg = document.getElementById('mainImage');
            const videoDisplay = document.getElementById('video_main_display');

            if (videoDisplay) {
                videoDisplay.classList.add('hidden');
                const videoPlayer = document.getElementById('mainVideoPlayer');
                if (videoPlayer) videoPlayer.pause();

                const youtubePlayer = document.getElementById('mainYoutubePlayer');
                if (youtubePlayer) {
                    const src = youtubePlayer.src;
                    youtubePlayer.src = src;
                }
            }

            mainImg.classList.remove('hidden');
            mainImg.src = element.src;

            document.querySelectorAll('#desktopProduct img, #desktopProduct div').forEach(el => el.classList.remove(
                'border-orange-500'));
            element.classList.add('border-orange-500');
        }

        function showVideo() {
            const mainImg = document.getElementById('mainImage');
            const videoDisplay = document.getElementById('video_main_display');

            if (videoDisplay) {
                mainImg.classList.add('hidden');
                videoDisplay.classList.remove('hidden');
            }
        }
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const mainImage = document.getElementById("mainImage");
            const finalPriceEl = document.getElementById("finalPrice");
            const oldPriceEl = document.getElementById("oldPrice");
            const savePriceEl = document.getElementById("savePrice");
            const stockEl = document.getElementById('stockText');
            const quantity = document.querySelector('.quantity-input');

            const cartImage = document.getElementById("cartImage");
            const buyNowImage = document.getElementById("buyNowImage");

            const cartVariantId = document.getElementById("cartVariantId");
            const buyNowVariantId = document.getElementById("buyNowVariantId");

            const variants = <?php echo json_encode($variants, 15, 512) ?>;
            const container = document.getElementById("desktopProduct");

            function updateHiddenInputs(variantId = 0) {
                const currentSrc = mainImage?.getAttribute("src") ?? "";
                if (cartImage) cartImage.value = currentSrc;
                if (buyNowImage) buyNowImage.value = currentSrc;

                if (cartVariantId) cartVariantId.value = variantId;
                if (buyNowVariantId) buyNowVariantId.value = variantId;

                let variant = variants.find(v => v.id == variantId);
                const currentQty = quantity ? parseInt(quantity.value) : 1;

                let availableStock = 0;

                if (variant) {
                    finalPriceEl.textContent = `৳${variant.new_price.toFixed(2)}`;
                    finalPriceEl.dataset.basePrice = variant.new_price;

                    oldPriceEl.textContent = variant.old_price ? `৳${parseFloat(variant.old_price).toFixed(2)}` :
                        '';
                    savePriceEl.textContent = variant.old_price ?
                        `Save ৳${(parseFloat(variant.old_price) - variant.new_price).toFixed(2)}` : '';

                    availableStock = parseInt(variant.stock);
                } else {
                    finalPriceEl.textContent = `৳<?php echo e($product->new_price); ?>.00`;
                    finalPriceEl.dataset.basePrice = <?php echo e($product->new_price); ?>;
                    <?php if($product->old_price): ?>
                        oldPriceEl.textContent = `৳<?php echo e($product->old_price); ?>.00`;
                        savePriceEl.textContent = `Save ৳<?php echo e($product->old_price - $product->new_price); ?>.00`;
                    <?php endif; ?>
                    availableStock = <?php echo e($product->stock); ?>;
                }

                updateStockUI(availableStock);

                if (quantity) {
                    quantity.max = availableStock;
                    if (currentQty > availableStock) {
                        quantity.value = availableStock > 0 ? availableStock : 1;
                    }
                }
            }

            function updateStockUI(stockNumber) {
                if (!stockEl) return;

                if (stockNumber <= 0) {
                    stockEl.textContent = "Out of Stock";
                    stockEl.classList.remove("text-green-600");
                    stockEl.classList.add("text-red-600");
                } else {
                    stockEl.textContent = `${stockNumber} Available`;
                    stockEl.classList.remove("text-red-600");
                    stockEl.classList.add("text-green-600");
                }
            }

            if (container) {
                container.addEventListener("click", function(e) {
                    const target = e.target;
                    if (target.tagName === "IMG") {
                        mainImage.src = target.src;

                        container.querySelectorAll("img").forEach(img => {
                            img.classList.remove("border-2", "border-[<?php echo e($theme->theme_bg); ?>]");
                            img.classList.add("border", "border-gray-200");
                        });

                        target.classList.remove("border", "border-gray-200");
                        target.classList.add("border-2", "border-[<?php echo e($theme->theme_bg); ?>]");

                        const variantId = parseInt(target.getAttribute('data-variant-id')) || 0;
                        updateHiddenInputs(variantId);
                    }
                });
            }

            document.querySelectorAll("form").forEach(form => {
                form.addEventListener("submit", function(e) {
                    const selectedImage = container?.querySelector('img.border-2');
                    const variantId = selectedImage ? (parseInt(selectedImage.getAttribute(
                        'data-variant-id')) || 0) : 0;
                    updateHiddenInputs(variantId);
                });
            });

            window.addEventListener("load", () => {
                updateHiddenInputs();
            });
        });
    </script>

    <div class="md:col-span-5 col-span-12 bg-white px-4 py-2 flex flex-col justify-start">
        <h1 class="text-xl font-medium text-gray-800 leading-[1.4] line-clamp-2"><?php echo e($product->name); ?></h1>
        <div class="flex items-center gap-1 mb-1">
            <div class="flex items-left text-[14.5px]">
                <?php
                    $rating = $product->averageRating();
                    $fullStars = floor($rating);
                    $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                    $emptyStars = 5 - $fullStars - $halfStar;
                ?>
                <?php for($i = 0; $i < $fullStars; $i++): ?>
                    <i class="ri-star-fill text-yellow-400"></i>
                <?php endfor; ?>
                <?php if($halfStar): ?>
                    <i class="ri-star-half-line text-yellow-400"></i>
                <?php endif; ?>
                <?php for($i = 0; $i < $emptyStars; $i++): ?>
                    <i class="ri-star-line text-yellow-400"></i>
                <?php endfor; ?>
            </div>
            <span class="text-gray-600 text-sm">(<?php echo e($reviewsCount); ?> Reviews)</span>
        </div>

        <div class="flex items-center mb-3">
            <span class="font-medium text-gray-800 mr-2">Brand:</span>
            <span
                class="text-gray-600 bg-gray-100 px-3 py-1 rounded text-sm"><?php echo e($product->brand ? $product->brand : 'None'); ?></span>
        </div>

        <div class="flex items-center mb-2">
            <span class="font-medium text-gray-800 mr-2">Stock:</span>
            <span id="stockText"
                class="font-semibold stock <?php echo e($product->stock > 0 ? 'text-green-600' : 'text-red-600'); ?>">
                <?php echo e($product->stock > 0 ? $product->stock . ' Available' : 'Out of Stock'); ?>

            </span>
        </div>

        <?php
            $allAttributes = [];
            foreach ($variants as $variant) {
                foreach ($variant['attributes'] as $attr) {
                    $attrName = $attr['attribute_name'];
                    if (!isset($allAttributes[$attrName])) {
                        $allAttributes[$attrName] = [];
                    }
                    foreach ($attr['values'] as $val) {
                        if (!in_array($val, $allAttributes[$attrName])) {
                            $allAttributes[$attrName][] = $val;
                        }
                    }
                }
            }
        ?>

        <?php if(!empty($allAttributes)): ?>
            <div class="mb-4">
                <span class="font-medium text-gray-800 block mb-2">Choose Variant</span>
                <div class="flex flex-col gap-3">
                    <?php $__currentLoopData = $allAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributeName => $values): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex gap-2 items-center">
                            <span class="text-gray-700 text-sm"><?php echo e($attributeName); ?>:</span>
                            <?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div
                                    class="px-3 py-1 border rounded cursor-pointer text-sm variant-box hover:bg-[<?php echo e($theme->theme_bg); ?>] hover:text-white">
                                    <?php echo e($value); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="mb-4 flex items-center gap-3">
            <span class="text-gray-700 font-medium">Quantity:</span>
            <div class="flex items-center border border-gray-300 rounded overflow-hidden">
                <button type="button"
                    class="px-3 py-1 bg-gray-100 hover:bg-gray-200 text-gray-700 font-semibold quantity-decrease">-</button>
                <input type="number" min="1" value="1"
                    class="w-16 text-center border-gray-300 focus:outline-none quantity-input">
                <button type="button"
                    class="px-3 py-1 bg-gray-100 hover:bg-gray-200 text-gray-700 font-semibold quantity-increase">+</button>
            </div>
        </div>

        <div class="mb-4">
            <div class="flex items-center gap-3">
                <span class="text-2xl font-bold text-[<?php echo e($theme->theme_bg); ?>]"
                    data-base-price="<?php echo e($product->new_price); ?>" id="finalPrice">৳<?php echo e($product->new_price); ?>.00</span>
                <?php if($product->old_price): ?>
                    <span class="text-gray-400 line-through text-lg" data-old-price="<?php echo e($product->old_price); ?>"
                        id="oldPrice">৳<?php echo e($product->old_price); ?>.00</span>
                <?php endif; ?>
                <?php if($product->old_price && $product->new_price < $product->old_price): ?>
                    <span class="text-sm text-green-600 font-medium px-2 py-1 rounded bg-green-100 animate-pulse"
                        id="savePrice">
                        Save ৳-<?php echo e($product->old_price - $product->new_price); ?>.00
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <div class="flex flex-row gap-3 mb-1">
            <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="w-full sm:w-1/2">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="image" id="cartImage">
                <input type="hidden" name="variant[]" class="cart-variant">
                <input type="hidden" id="cartVariantId" name="cartVariantId">
                <input id="quantity" type="hidden" name="quantity" value="1" class="quantity-input">
                <button type="submit" id="addToCartBtn"
                    class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-white font-semibold py-2.5 rounded transition duration-200">
                    <i class="ri-shopping-cart-line"></i>
                    কার্টে রাখুন
                </button>
            </form>

            <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>" class="w-full sm:w-1/2">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="image" id="buyNowImage">
                <input type="hidden" id="buyNowVariantId" name="buyNowVariantId">
                <input type="hidden" name="variant[]" class="buy-now-variant">
                <input id="quantity" type="hidden" name="quantity" value="1" class="quantity-input">
                <button type="submit"
                    class="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-2.5 rounded transition duration-200">
                    <i class="ri-shopping-bag-line"></i>
                    অর্ডার করুন
                </button>
            </form>
        </div>
    </div>

    <?php if(isset($product)): ?>
        <script>
            (function() {

                var value = <?php echo e($product->new_price); ?>;
                var ids = ['<?php echo e($product->id); ?>'];
                var quantity = 1;

                // --- GTM ---
                if (window.dataLayer) {
                    dataLayer.push({
                        event: 'ViewContent',
                        content_ids: ids,
                        content_name: '<?php echo e($product->name); ?>',
                        content_type: 'product',
                        value: value,
                        currency: 'BDT',
                        quantity: quantity
                    });
                }

                // --- Pixel ---
                if (typeof fbq === 'function') {
                    fbq('track', 'ViewContent', {
                        content_ids: ids,
                        content_name: '<?php echo e($product->name); ?>',
                        content_type: 'product',
                        value: value,
                        currency: 'BDT',
                        quantity: quantity
                    });
                }
            })();
        </script>
    <?php endif; ?>

    <?php if(isset($product)): ?>
        <script>
            document.getElementById('addToCartBtn').addEventListener('click', function() {

                var qty = parseInt(document.querySelector('.quantity-input').value) || 1;
                var value = <?php echo e($product->new_price); ?> * qty;

                // --- GTM ---
                if (window.dataLayer) {
                    dataLayer.push({
                        event: 'AddToCart',
                        content_ids: ['<?php echo e($product->id); ?>'],
                        content_name: '<?php echo e($product->name); ?>',
                        content_type: 'product',
                        value: value,
                        currency: 'BDT',
                        quantity: qty
                    });
                }

                // --- Pixel ---
                if (typeof fbq === 'function') {
                    fbq('track', 'AddToCart', {
                        content_ids: ['<?php echo e($product->id); ?>'],
                        content_name: '<?php echo e($product->name); ?>',
                        content_type: 'product',
                        value: value,
                        currency: 'BDT',
                        quantity: qty
                    });
                }
            });
        </script>
    <?php endif; ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const variantBoxes = document.querySelectorAll('.variant-box');

            variantBoxes.forEach(box => {
                box.addEventListener('click', () => {
                    const attrName = box.parentElement.querySelector('span').innerText.replace(':',
                        '').trim();

                    box.parentElement.querySelectorAll('.variant-box').forEach(b => {
                        b.classList.remove('bg-[<?php echo e($theme->theme_bg); ?>]', 'text-white');
                    });

                    box.classList.add('bg-[<?php echo e($theme->theme_bg); ?>]', 'text-white');

                    const value = box.innerText.trim();

                    const cartForm = document.querySelector('form .cart-variant')?.closest('form');
                    if (cartForm) {
                        let input = cartForm.querySelector(`input[name="variant[${attrName}]"]`);
                        if (!input) {
                            input = document.createElement('input');
                            input.type = 'hidden';
                            input.name = `variant[${attrName}]`;
                            cartForm.appendChild(input);
                        }
                        input.value = value;
                    }

                    const buyNowForm = document.querySelector('form .buy-now-variant')?.closest(
                        'form');
                    if (buyNowForm) {
                        let input = buyNowForm.querySelector(`input[name="variant[${attrName}]"]`);
                        if (!input) {
                            input = document.createElement('input');
                            input.type = 'hidden';
                            input.name = `variant[${attrName}]`;
                            buyNowForm.appendChild(input);
                        }
                        input.value = value;
                    }
                });
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const quantityInput = document.querySelector('.quantity-input[type="number"]');
            const decreaseBtn = document.querySelector('.quantity-decrease');
            const increaseBtn = document.querySelector('.quantity-increase');

            const finalPriceEl = document.getElementById('finalPrice');
            const oldPriceEl = document.getElementById('oldPrice');
            const savePriceEl = document.getElementById('savePrice');

            function getCurrentStock() {
                const stockEl = document.querySelector('.stock');
                if (!stockEl) return 0;

                const stockText = stockEl.textContent || '';
                const match = stockText.match(/\d+/);
                return match ? parseInt(match[0]) : 0;
            }

            function updateFormQuantity(value) {
                document.querySelectorAll('form input.quantity-input[type="hidden"]').forEach(hidden => {
                    hidden.value = value;
                });
                updatePriceDisplay(value);
            }

            function updatePriceDisplay(qty) {
                const basePrice = parseFloat(finalPriceEl.getAttribute('data-base-price')) || 0;
                const oldPrice = parseFloat(oldPriceEl.getAttribute('data-old-price')) || 0;

                const totalPrice = basePrice * qty;
                finalPriceEl.textContent = `৳${totalPrice.toFixed(2)}`;

                if (oldPrice > 0 && oldPrice > basePrice) {
                    oldPriceEl.textContent = `৳${(oldPrice * qty).toFixed(2)}`;
                    savePriceEl.textContent = `Save ৳-${((oldPrice - basePrice) * qty).toFixed(2)}`;
                }
            }

            function syncQuantityInput() {
                const maxStock = getCurrentStock();
                let val = parseInt(quantityInput.value) || 1;
                if (val > maxStock) val = maxStock;
                if (val < 1) val = 1;
                quantityInput.value = val;
                updateFormQuantity(val);
            }

            decreaseBtn.addEventListener('click', () => {
                let val = parseInt(quantityInput.value) || 1;
                if (val > 1) val--;
                quantityInput.value = val;
                updateFormQuantity(val);
            });

            increaseBtn.addEventListener('click', () => {
                const maxStock = getCurrentStock();
                let val = parseInt(quantityInput.value) || 1;
                if (val < maxStock) val++;
                quantityInput.value = val;
                updateFormQuantity(val);
            });

            quantityInput.addEventListener('input', () => {
                syncQuantityInput();
            });

            const variantContainer = document.getElementById('desktopProduct');
            variantContainer.addEventListener('click', (e) => {
                if (e.target.tagName === 'IMG') {
                    setTimeout(syncQuantityInput, 50);
                }
            });

            syncQuantityInput();
        });
    </script>

    <div class="md:col-span-3 col-span-12 bg-white flex flex-col border-l border-gray-100">

        <div class="p-4 border-b border-gray-100">
            <div class="flex justify-between items-start mb-3">
                <h2 class="text-sm font-medium text-gray-500">Delivery Options</h2>
                <i class="ri-information-line text-gray-400 text-lg cursor-pointer"></i>
            </div>

            <div class="flex gap-3 items-start">
                <i class="ri-map-pin-line text-xl text-gray-600"></i>
                <div class="flex-1">
                    <p class="text-sm text-gray-800 leading-tight">
                        <?php if(Auth::guard('customer')->check() && !empty(Auth::guard('customer')->user()->address)): ?>
                            <?php echo e(Auth::guard('customer')->user()->address); ?>

                        <?php else: ?>
                            Dhaka, Dhaka North, Banani Road No. 12 - 19
                        <?php endif; ?>
                    </p>
                </div>
                <a href="<?php echo e(route('customer.account')); ?>"
                    class="text-blue-500 text-sm font-medium hover:underline uppercase">Change</a>
            </div>

            <div class="mt-5 flex gap-3 items-center">
                <i class="ri-truck-line text-xl text-gray-600"></i>
                <p class="text-sm text-gray-800 font-normal">Seller's Own Fleet</p>
            </div>
        </div>

        <div class="p-4 border-b border-gray-100">
            <div class="flex justify-between items-start mb-4">
                <h2 class="text-sm font-medium text-gray-500">Return & Warranty</h2>
                <i class="ri-information-line text-gray-400 text-lg cursor-pointer"></i>
            </div>

            <div class="space-y-4">
                <div class="flex gap-3 items-center">
                    <div class="relative">
                        <i class="ri-refresh-line text-xl text-gray-600"></i>
                        <span
                            class="absolute -top-1 -right-1 text-[8px] font-bold bg-gray-600 text-white rounded-full w-3 h-3 flex items-center justify-center">14</span>
                    </div>
                    <p class="text-sm text-gray-800">14 days easy return</p>
                </div>

                <div class="flex gap-3 items-center">
                    <i class="ri-shield-check-line text-xl text-gray-600"></i>
                    <p class="text-sm text-gray-800">Upto 10 Years Brand Warranty</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="max-w-6xl mx-auto my-4">
    <div class="w-full bg-white px-6 pb-6 shadow-sm rounded-lg overflow-hidden">
        <div class="border-b py-4 mb-2">
            <h2 class="text-xl font-semibold text-gray-800">Description</h2>
        </div>

        <?php if(!empty($product->desc)): ?>
            <div class="text-gray-700 text-sm break-words whitespace-normal overflow-hidden">
                <?php echo $product->desc; ?>

            </div>
        <?php else: ?>
            <p class="text-gray-500 text-sm">No description available for this product.</p>
        <?php endif; ?>
    </div>
</div>

<div class="max-w-6xl mx-auto my-4">
    <div class="w-full bg-white px-6 pb-6 pt-6">
        <?php if(Auth::guard('customer')->check()): ?>
            <div class="mt-6">
                <form action="<?php echo e(route('customer.review')); ?>" method="POST"
                    class="flex flex-col border rounded-xl border-gray-200 bg-white p-6 shadow-sm gap-5">
                    <?php echo csrf_field(); ?>

                    <h3 class="text-xl font-bold text-gray-800 border-b pb-2">Write a Review</h3>

                    <div class="flex flex-col gap-1">
                        <label for="title" class="text-sm font-medium text-gray-700">Review Title</label>
                        <input type="text" name="title" id="title"
                            placeholder="Example: Excellent Quality!"
                            class="w-full p-2.5 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent outline-none transition-all text-gray-700"
                            required>
                    </div>

                    <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-gray-700">Your Rating</label>

                        <input type="number" name="rating" id="rating_value" value="5" min="1"
                            max="5" class="hidden">

                        <div class="flex items-center gap-1">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <button type="button" onclick="setRating(<?php echo e($i); ?>)"
                                    class="star-btn transition-all duration-200 transform hover:scale-110"
                                    data-value="<?php echo e($i); ?>">
                                    <svg id="star_<?php echo e($i); ?>" xmlns="http://www.w3.org/2000/svg"
                                        class="h-8 w-8 text-yellow-400 fill-current" viewBox="0 0 20 20">
                                        <path
                                            d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                    </svg>
                                </button>
                            <?php endfor; ?>
                            <span id="rating_text" class="ml-3 text-sm font-semibold text-gray-500">Excellent!</span>
                        </div>
                    </div>

                    <div class="flex flex-col gap-1">
                        <label for="review" class="text-sm font-medium text-gray-700">Description</label>
                        <textarea name="review" id="review" rows="4" placeholder="Tell us more about your experience..."
                            class="w-full p-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent outline-none transition-all resize-none text-gray-700"
                            required></textarea>
                    </div>

                    <input type="hidden" value="<?php echo e($product->id); ?>" name="product_id">
                    <input type="hidden" value="1" name="status">

                    <button type="submit"
                        class="w-full bg-[<?php echo e($theme->theme_bg); ?>] text-white font-bold py-3 rounded-lg hover:brightness-110 transition-all shadow-md active:scale-[0.98]">
                        Submit Review
                    </button>

                </form>
            </div>
        <?php else: ?>
            <div class="bg-orange-50 w-full flex items-center justify-center px-8 py-8 rounded">
                <button class="loginBtn px-4 py-2 rounded bg-[<?php echo e($theme->theme_bg); ?>] text-white">Login Now</button>
            </div>
        <?php endif; ?>

        <div class="border-b py-4 mb-4">
            <h2 class="text-xl font-semibold text-gray-800">Customer Reviews</h2>
        </div>

        <?php if($reviews->isEmpty()): ?>
            <div class="text-center py-8 bg-gray-50 rounded-lg shadow-sm">
                <i class="ri-chat-smile-2-line text-4xl text-gray-400 mb-2"></i>
                <p class="text-gray-600 text-lg font-medium">No reviews yet</p>
                <p class="text-gray-500 text-sm">Be the first to share your experience!</p>
            </div>
        <?php else: ?>
            <div class="space-y-6">
                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-start space-x-4 p-4 bg-gray-50 rounded-lg shadow-sm">
                        <div class="flex-shrink-0">
                            <img loading="lazy" class="w-12 h-12 rounded-full object-cover"
                                src="<?php echo e(asset('public/upload/user/219969.png')); ?>" alt="Reviewer">
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-2">
                                <div class="flex items-center gap-1">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <?php if($i <= floor($review->rating)): ?>
                                            <i class="ri-star-fill text-yellow-400"></i>
                                        <?php elseif($i == ceil($review->rating) && $review->rating != floor($review->rating)): ?>
                                            <i class="ri-star-half-line text-yellow-400"></i>
                                        <?php else: ?>
                                            <i class="ri-star-line text-yellow-400"></i>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                </div>
                                <span class="text-sm text-gray-600"><?php echo e($review->created_at->diffForHumans()); ?></span>
                            </div>

                            <div>
                                <h3 class="text-md font-medium text-gray-800"><?php echo e($review->title); ?></h3>
                                <p id="description-<?php echo e($review->id); ?>" class="text-gray-700 text-sm truncate-lines">
                                    <?php echo e($review->review); ?>

                                </p>
                                <?php if(strlen($review->review) > 200): ?>
                                    <button id="seeMoreBtn-<?php echo e($review->id); ?>"
                                        class="text-[<?php echo e($theme->theme_bg); ?>] font-semibold text-sm"
                                        onclick="toggleDescription(<?php echo e($review->id); ?>)">
                                        See More
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    function setRating(value) {
        // Update hidden input value
        document.getElementById('rating_value').value = value;

        // Update Star Colors
        const stars = document.querySelectorAll('.star-btn svg');
        const ratingText = document.getElementById('rating_text');

        const labels = {
            1: 'Poor',
            2: 'Fair',
            3: 'Good',
            4: 'Very Good',
            5: 'Excellent!'
        };

        stars.forEach((star, index) => {
            if (index < value) {
                star.classList.remove('text-gray-300');
                star.classList.add('text-yellow-400');
            } else {
                star.classList.remove('text-yellow-400');
                star.classList.add('text-gray-300');
            }
        });

        // Update status text
        ratingText.innerText = labels[value];
    }
</script>

<div class="bg-white py-4 mb-6">
    <div class="max-w-6xl mx-auto px-2">
        <h2 class="text-lg font-semibold text-gray-800 mb-3">Related Products</h2>
        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-md overflow-hidden relative border cursor-pointer group"
                    onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'">
                    <?php if($product->old_price && $product->new_price): ?>
                        <?php
                            if ($product->old_price > $product->new_price) {
                                $discount = round(
                                    (($product->old_price - $product->new_price) / $product->old_price) * 100,
                                );
                                $badgeText = "-{$discount}%";
                                $badgeColor = 'bg-red-500';
                            } elseif ($product->old_price < $product->new_price) {
                                $discount = round(
                                    (($product->new_price - $product->old_price) / $product->old_price) * 100,
                                );
                                $badgeText = "+{$discount}%";
                                $badgeColor = 'bg-green-500';
                            } else {
                                $badgeText = null;
                            }
                        ?>
                        <?php if($badgeText): ?>
                            <span
                                class="absolute top-2 right-2 <?php echo e($badgeColor); ?> text-white text-xs font-semibold px-2 py-0.5 rounded z-20"><?php echo e($badgeText); ?></span>
                        <?php endif; ?>
                    <?php endif; ?>

                    <div class="w-full h-48 overflow-hidden relative">
                        <img loading="lazy"
                            src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                            alt="<?php echo e($product->name); ?>"
                            class="w-full h-full object-cover transform hover:scale-105 transition duration-300">

                        <button
                            onclick="event.stopPropagation(); document.getElementById('add_cart_<?php echo e($product->id); ?>').submit();"
                            class="absolute bottom-2 left-2 bg-[<?php echo e($theme->theme_bg); ?>] text-white w-9 h-9 flex items-center justify-center rounded-full 
                                opacity-0 scale-0 translate-y-3 
                                group-hover:opacity-100 group-hover:scale-100 group-hover:translate-y-0 
                                transition-all duration-300 ease-out shadow-md">
                            <i class="ri-shopping-cart-line text-md"></i>
                        </button>
                    </div>

                    <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="hidden"
                        id="add_cart_<?php echo e($product->id); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="quantity" value="1">
                        <input type="hidden" name="image"
                            value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                    </form>

                    <div class="px-2.5 py-1 pb-2.5 flex flex-col items-left">
                        <h3 class="text-gray-700 font-medium text-left text-[14.5px] line-clamp-2">
                            <?php echo e($product->name); ?></h3>
                        <div class="flex items-center text-[14.5px]">
                            <?php
                                $rating = $product->averageRating();
                                $fullStars = floor($rating);
                                $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                                $emptyStars = 5 - $fullStars - $halfStar;
                            ?>
                            <?php for($i = 0; $i < $fullStars; $i++): ?>
                                <i class="ri-star-fill text-yellow-400"></i>
                            <?php endfor; ?>
                            <?php if($halfStar): ?>
                                <i class="ri-star-half-line text-yellow-400"></i>
                            <?php endif; ?>
                            <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                <i class="ri-star-line text-yellow-400"></i>
                            <?php endfor; ?>
                        </div>
                        <p class="text-[<?php echo e($theme->theme_bg); ?>] font-bold mb-2 text-left text-[14.5px]">
                            &#2547;<?php echo e($product->new_price); ?>

                            <?php if($product->old_price): ?>
                                <span
                                    class="line-through text-gray-400 text-[14px]">&#2547;<?php echo e($product->old_price); ?></span>
                            <?php endif; ?>
                        </p>
                        <div class="flex flex-row gap-1 w-full">
                            <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>"
                                class="flex-1">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="quantity" value="1">
                                <input type="hidden" name="image"
                                    value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                <button type="submit" onclick="event.stopPropagation();"
                                    class="bg-[<?php echo e($theme->theme_bg); ?>]/90 hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] px-2 py-2 rounded w-full text-[14.5px]">
                                    <i class="ri-shopping-bag-line"></i>
                                    অর্ডার করুন
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<script>
    function toggleDescription() {
        const description = document.getElementById('description');
        const seeMoreBtn = document.getElementById('seeMoreBtn');

        description.classList.toggle('truncate-lines');

        if (description.classList.contains('truncate-lines')) {
            seeMoreBtn.textContent = 'See More';
        } else {
            seeMoreBtn.textContent = 'See Less';
        }
    }
</script>

<style>
    .truncate-lines {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/frontend/product-details.blade.php ENDPATH**/ ?>