<?php $__env->startSection('title', 'My Account'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-[#f8fafc] min-h-screen py-10 py-4 md:py-16">
    <div class="max-w-6xl mx-auto px-4">
        
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-4">
            
            <div class="lg:col-span-4">
                <div class="bg-white rounded-xl p-8 shadow-[0_20px_50px_rgba(0,0,0,0.04)] border border-gray-100 sticky top-24">
                    <div class="flex flex-col items-center">
                        <div class="relative p-1.5 rounded-full bg-gradient-to-tr from-[<?php echo e($theme->theme_bg); ?>] to-purple-500 shadow-xl">
                            <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::guard('customer')->user()->name); ?>&background=white&color=<?php echo e(str_replace('#', '', $theme->theme_bg)); ?>&bold=true&size=128" 
                                 class="w-28 h-28 rounded-full border-4 border-white object-cover">
                        </div>
                        
                        <div class="mt-5 text-center">
                            <h3 class="text-2xl font-extrabold text-gray-900 tracking-tight"><?php echo e(Auth::guard('customer')->user()->name); ?></h3>
                            <span class="inline-block mt-1 px-3 py-1 bg-[<?php echo e($theme->theme_bg); ?>]/10 text-[<?php echo e($theme->theme_bg); ?>] text-[10px] font-black uppercase tracking-[2px] rounded-full">
                                Premium Member
                            </span>
                        </div>
                    </div>

                    <div class="mt-10 space-y-2">
                        <button onclick="switchTab('view-data', this)" class="tab-btn active w-full flex items-center justify-between p-4 rounded-2xl bg-gray-900 text-white transition-all duration-300 font-bold group">
                            <div class="flex items-center gap-4">
                                <i class="ri-user-6-line text-xl"></i>
                                <span class="text-sm">Account Overview</span>
                            </div>
                            <i class="ri-arrow-right-s-line opacity-50 group-hover:translate-x-1 transition-transform"></i>
                        </button>

                        <button onclick="switchTab('edit-data', this)" class="tab-btn w-full flex items-center justify-between p-4 rounded-2xl text-gray-500 hover:bg-gray-50 transition-all duration-300 font-bold group">
                            <div class="flex items-center gap-4">
                                <i class="ri-settings-3-line text-xl"></i>
                                <span class="text-sm">Profile Settings</span>
                            </div>
                            <i class="ri-arrow-right-s-line opacity-0 group-hover:opacity-100 group-hover:translate-x-1 transition-all"></i>
                        </button>

                        <a href="<?php echo e(route('customer.orders')); ?>" class="w-full flex items-center justify-between p-4 rounded-2xl text-gray-500 hover:bg-gray-50 transition-all duration-300 font-bold group">
                            <div class="flex items-center gap-4">
                                <i class="ri-shopping-basket-2-line text-xl"></i>
                                <span class="text-sm">Order History</span>
                            </div>
                            <i class="ri-arrow-right-s-line opacity-0 group-hover:opacity-100 group-hover:translate-x-1 transition-all"></i>
                        </a>
                    </div>

                    <div class="mt-8 pt-8 border-t border-gray-50">
                        <form method="POST" action="<?php echo e(route('customer.logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full flex items-center justify-center gap-3 p-4 rounded-2xl bg-red-50 text-red-500 font-bold text-sm hover:bg-red-500 hover:text-white transition-all duration-300 shadow-sm">
                                <i class="ri-logout-circle-line text-lg"></i> Logout Account
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-8">
                <div id="view-data" class="content-section animate-in fade-in slide-in-from-right-10 duration-500">
    <div class="bg-white rounded-xl p-8 md:p-10 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100 mb-8">
        <div class="flex items-center justify-between mb-10">
            <div>
                <h4 class="text-3xl font-black text-gray-900 tracking-tight">Account Overview</h4>
                <p class="text-gray-400 text-xs font-bold uppercase tracking-widest mt-1">Verified Personal Details</p>
            </div>
            <div class="h-14 w-14 rounded-2xl bg-gray-50 flex items-center justify-center text-[<?php echo e($theme->theme_bg); ?>] shadow-inner">
                <i class="ri-shield-user-line text-2xl"></i>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="flex items-center gap-4 p-4 rounded-3xl bg-gray-50/50 border border-transparent hover:border-[<?php echo e($theme->theme_bg); ?>]/20 hover:bg-white transition-all group">
                <div class="h-12 w-12 rounded-2xl bg-white shadow-sm flex items-center justify-center text-gray-400 group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors">
                    <i class="ri-user-smile-line text-xl"></i>
                </div>
                <div>
                    <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest">Full Name</p>
                    <p class="text-gray-900 font-extrabold"><?php echo e(Auth::guard('customer')->user()->name); ?></p>
                </div>
            </div>

            <div class="flex items-center gap-4 p-4 rounded-3xl bg-gray-50/50 border border-transparent hover:border-[<?php echo e($theme->theme_bg); ?>]/20 hover:bg-white transition-all group">
                <div class="h-12 w-12 rounded-2xl bg-white shadow-sm flex items-center justify-center text-gray-400 group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors">
                    <i class="ri-mail-send-line text-xl"></i>
                </div>
                <div class="overflow-hidden">
                    <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest">Email Address</p>
                    <p class="text-gray-900 font-extrabold truncate"><?php echo e(Auth::guard('customer')->user()->email); ?></p>
                </div>
            </div>

            <div class="flex items-center gap-4 p-4 rounded-3xl bg-gray-50/50 border border-transparent hover:border-[<?php echo e($theme->theme_bg); ?>]/20 hover:bg-white transition-all group">
                <div class="h-12 w-12 rounded-2xl bg-white shadow-sm flex items-center justify-center text-gray-400 group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors">
                    <i class="ri-phone-line text-xl"></i>
                </div>
                <div>
                    <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest">Contact Number</p>
                    <p class="text-gray-900 font-extrabold">+88 <?php echo e(Auth::guard('customer')->user()->phone); ?></p>
                </div>
            </div>

            <div class="flex items-center gap-4 p-4 rounded-3xl bg-gray-50/50 border border-transparent hover:border-[<?php echo e($theme->theme_bg); ?>]/20 hover:bg-white transition-all group">
                <div class="h-12 w-12 rounded-2xl bg-white shadow-sm flex items-center justify-center text-gray-400 group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors">
                    <i class="ri-qr-code-line text-xl"></i>
                </div>
                <div>
                    <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest">Customer ID</p>
                    <p class="text-gray-900 font-extrabold">#CS-<?php echo e(1000 + Auth::guard('customer')->user()->id); ?></p>
                </div>
            </div>
        </div>

        <div class="mt-6 p-5 rounded-3xl bg-gray-900 text-white flex items-start gap-4 shadow-xl shadow-gray-200">
            <div class="h-10 w-10 rounded-xl bg-white/10 flex items-center justify-center flex-shrink-0">
                <i class="ri-map-pin-2-line text-xl text-[<?php echo e($theme->theme_bg); ?>]"></i>
            </div>
            <div>
                <p class="text-[10px] font-black uppercase tracking-[2px] text-white/40">Primary Shipping Address</p>
                <p class="text-sm font-medium mt-1 leading-relaxed"><?php echo e(Auth::guard('customer')->user()->address ?? 'No address provided yet.'); ?></p>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <?php
            $allOrders = App\Models\Order::where('customer_id', Auth::guard('customer')->id())->get();
            $stats = [
                ['label' => 'Total Orders', 'count' => $allOrders->count(), 'icon' => 'ri-shopping-bag-line', 'color' => $theme->theme_bg],
                ['label' => 'Pending', 'count' => $allOrders->where('order_status', 'pending')->count(), 'icon' => 'ri-time-line', 'color' => '#f59e0b'],
                ['label' => 'Shipped', 'count' => $allOrders->where('order_status', 'shipped')->count(), 'icon' => 'ri-truck-line', 'color' => '#6366f1'],
                ['label' => 'Completed', 'count' => $allOrders->where('order_status', 'delivered')->count(), 'icon' => 'ri-checkbox-circle-line', 'color' => '#10b981'],
            ];
        ?>

        <?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-[0_10px_30px_rgba(0,0,0,0.02)] flex flex-col items-center text-center group hover:-translate-y-1 transition-all duration-300">
            <div class="h-12 w-12 rounded-2xl mb-4 flex items-center justify-center text-white shadow-lg" style="background-color: <?php echo e($stat['color']); ?>">
                <i class="<?php echo e($stat['icon']); ?> text-xl"></i>
            </div>
            <h5 class="text-2xl font-black text-gray-900 leading-none"><?php echo e($stat['count']); ?></h5>
            <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest mt-2"><?php echo e($stat['label']); ?></p>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

                <div id="edit-data" class="content-section hidden animate-in fade-in slide-in-from-right-10 duration-500">
                    <form action="<?php echo e(route('customer.account.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="bg-white rounded-xl p-10 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100">
                            <h4 class="text-3xl font-black text-gray-900 tracking-tight mb-8">Edit Details</h4>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2">
                                    <label class="text-xs font-black text-gray-400 uppercase tracking-widest ml-2">Name</label>
                                    <input type="text" name="name" value="<?php echo e(Auth::guard('customer')->user()->name); ?>" class="w-full bg-gray-50 border-2 border-transparent focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold text-gray-800">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-xs font-black text-gray-400 uppercase tracking-widest ml-2">Email</label>
                                    <input type="email" name="email" value="<?php echo e(Auth::guard('customer')->user()->email); ?>" class="w-full bg-gray-50 border-2 border-transparent focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold text-gray-800">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-xs font-black text-gray-400 uppercase tracking-widest ml-2">Phone</label>
                                    <input type="text" name="phone" value="<?php echo e(Auth::guard('customer')->user()->phone); ?>" class="w-full bg-gray-50 border-2 border-transparent focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold text-gray-800">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-xs font-black text-gray-400 uppercase tracking-widest ml-2">Address</label>
                                    <input type="text" name="address" value="<?php echo e(Auth::guard('customer')->user()->address); ?>" class="w-full bg-gray-50 border-2 border-transparent focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold text-gray-800">
                                </div>
                            </div>
                        </div>

                        <div class="bg-white rounded-xl p-10 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100">
                            <h4 class="text-xl font-black text-gray-900 tracking-tight mb-8">Update Security</h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <input type="password" name="current_password" placeholder="Old Password" class="w-full bg-gray-50 border-2 border-transparent focus:border-red-400 focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold">
                                <input type="password" name="new_password" placeholder="New Password" class="w-full bg-gray-50 border-2 border-transparent focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold">
                                <input type="password" name="new_password_confirmation" placeholder="Confirm" class="w-full bg-gray-50 border-2 border-transparent focus:border-[<?php echo e($theme->theme_bg); ?>] focus:bg-white rounded-2xl px-6 py-4 transition-all outline-none font-bold">
                            </div>

                            <button type="submit" class="mt-10 w-full bg-gray-900 text-white font-black py-5 rounded-[2rem] hover:bg-[<?php echo e($theme->theme_bg); ?>] hover:scale-[1.01] transition-all duration-300 shadow-2xl shadow-gray-200 uppercase tracking-[3px] text-xs">
                                Confirm & Save Changes
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function switchTab(tabId, el) {
        document.querySelectorAll('.content-section').forEach(section => section.classList.add('hidden'));
        
        document.getElementById(tabId).classList.remove('hidden');

        document.querySelectorAll('.tab-btn').forEach(btn => {
            btn.classList.remove('bg-gray-900', 'text-white', 'shadow-xl');
            btn.classList.add('text-gray-500', 'hover:bg-gray-50');
        });

        el.classList.add('bg-gray-900', 'text-white', 'shadow-xl');
        el.classList.remove('text-gray-500', 'hover:bg-gray-50');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/customer/dashboard.blade.php ENDPATH**/ ?>