
<?php $__env->startSection('title', 'Navbar Theme'); ?>
<?php $__env->startSection('content'); ?>

    <style>
        .color-input {
            width: 100%;
            height: 42px;
            border-radius: 4px;
            border: none;
            padding: 0;
            cursor: pointer;
            appearance: none;
            -webkit-appearance: none;
            overflow: hidden;
            background: transparent;
        }

        /* Remove default color UI completely */
        .color-input::-webkit-color-swatch-wrapper {
            padding: 0;
            border: none;
        }

        .color-input::-webkit-color-swatch {
            border: none;
            border-radius: 4px;
        }

        .color-input::-moz-color-swatch {
            border: none;
            border-radius: 4px;
        }
    </style>

    <div class="w-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Theme Customize </h2>
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] px-4 py-2 rounded font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    Dashboard
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Home</a> /
                    Theme / Navbar
                </p>
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] px-4 py-2 rounded text-base font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    Dashboard
                </a>
            </div>
        </div>

        <form action="<?php echo e(route('admin.navbar.theme.update')); ?>" method="POST"
            class="bg-white p-6 rounded-lg shadow-lg space-y-6">
            <?php echo csrf_field(); ?>

            <!-- Theme Background Color -->
            <div class="flex flex-col gap-2 bg-gray-50 p-4 rounded-lg shadow-inner">
                <label class="text-gray-700 font-medium">Navbar Background</label>
                <input type="color" id="nav_bg" name="nav_bg" value="<?php echo e($theme->nav_bg ?? '#f5f5f5'); ?>"
                    class="color-input">
            </div>

            <!-- Text Color -->
            <div class="flex flex-col gap-2 bg-gray-50 p-4 rounded-lg shadow-inner">
                <label class="text-gray-700 font-medium">Navbar Text</label>
                <input type="color" id="nav_text" name="nav_text" value="<?php echo e($theme->nav_text ?? '#333333'); ?>"
                    class="color-input">
            </div>

            <div class="text-left">
                <button type="submit"
                    class="bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] px-6 py-2.5 w-full rounded-md transition duration-300 font-medium">
                    Save Theme
                </button>
            </div>

        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/backend/themes/navbar.blade.php ENDPATH**/ ?>