<?php $__env->startSection('title', $setting->meta_title); ?>
<?php $__env->startSection('content'); ?>
<?php
$randomCategories = $allcategories->shuffle()->take(9);
?>

<style>
    @keyframes cardFadeUp {
        0% {
            opacity: 0;
            transform: translateY(20px) scale(0.98);
        }

        100% {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }

    .product-card {
        opacity: 0;
        animation: cardFadeUp 0.6s ease forwards;
    }
</style>

<?php
$favicon = $setting->favicon;
$logo = $setting->icon;
?>

<div class="w-full md:mt-4">
    <div class="max-w-6xl mx-auto grid grid-cols-12 bg-white">
        <div class="col-span-3 bg-white relative hidden md:block rounded-l-md border">
            <ul id="categoryList" class="grid grid-cols-1 max-h-[330px]">
                <?php $__currentLoopData = $randomCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="group relative">
                    <div onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'"
                        class="flex items-center font-medium justify-between px-4 py-1 hover:bg-gray-100 cursor-pointer transition">
                        <span class="text-gray-700 text-[14px] capitalize"><?php echo e($category->name); ?></span>
                        <i class="ri-arrow-right-s-line text-gray-400 text-lg font-normal"></i>
                    </div>
                    <?php if($category->subcategories->count() > 0): ?>
                    <ul class="absolute top-0 left-full hidden group-hover:block bg-white w-[220px] z-20">
                        <div class="bg-white">
                            <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li onclick="window.location.href='<?php echo e(route('subcategory.product', $subcategory->slug)); ?>'"
                                class="px-4 py-1 hover:bg-gray-100 text-sm text-gray-700 cursor-pointer capitalize">
                                <?php echo e($subcategory->name); ?>

                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </ul>
                    <?php endif; ?>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>

        <div class="md:col-span-9 col-span-12 overflow-hidden shadow-md relative">
            <div id="banner"
                class="owl-carousel owl-theme w-full md:h-[330px] h-auto bg-gray-100 overflow-hidden flex items-center md:rounded-r-md">
                <?php $__currentLoopData = $mainBanner; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img loading="lazy" src="<?php echo e(asset('public/' . $banner->image)); ?>" alt="Banner"
                    class="w-full h-full object-cover">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<div class="max-w-6xl mx-auto px-2 md:px-0 md:my-3 my-0 overflow-hidden">
    <div class="py-2">
<div id="service" class="flex gap-2 owl-carousel owl-theme">
    
    <div class="h-auto">
        <div class="bg-white rounded-[24px] px-3 py-1.5 flex items-center gap-2 border border-gray-100 shadow-[0_3px_10px_rgb(0,0,0,0.02)] duration-300 h-full">
            <div class="w-8 h-8 flex-shrink-0 flex items-center justify-center rounded-2xl bg-orange-50 text-orange-500">
                <i class="ri-truck-fill text-base"></i>
            </div>
            <div class="overflow-hidden leading-tight">
                <h4 class="text-[11px] font-bold text-gray-800 truncate">দ্রুত ডেলিভারি</h4>
                <p class="text-[9px] text-gray-400 truncate">সারা বাংলাদেশে</p>
            </div>
        </div>
    </div>

    <div class="h-auto">
        <div class="bg-white rounded-[24px] px-3 py-1.5 flex items-center gap-2 border border-gray-100 shadow-[0_3px_10px_rgb(0,0,0,0.02)] duration-300 h-full">
            <div class="w-8 h-8 flex-shrink-0 flex items-center justify-center rounded-2xl bg-blue-50 text-blue-500">
                <i class="ri-loop-left-line text-base"></i>
            </div>
            <div class="overflow-hidden leading-tight">
                <h4 class="text-[11px] font-bold text-gray-800 truncate">সহজ রিটার্ন</h4>
                <p class="text-[9px] text-gray-400 truncate">৭ দিনের গ্যারান্টি</p>
            </div>
        </div>
    </div>

    <div class="h-auto">
        <div class="bg-white rounded-[24px] px-3 py-1.5 flex items-center gap-2 border border-gray-100 shadow-[0_3px_10px_rgb(0,0,0,0.02)] duration-300 h-full">
            <div class="w-8 h-8 flex-shrink-0 flex items-center justify-center rounded-2xl bg-emerald-50 text-emerald-500">
                <i class="ri-shield-check-fill text-base"></i>
            </div>
            <div class="overflow-hidden leading-tight">
                <h4 class="text-[11px] font-bold text-gray-800 truncate">নিরাপদ পেমেন্ট</h4>
                <p class="text-[9px] text-gray-400 truncate">১০০% সিকিউরড</p>
            </div>
        </div>
    </div>

    <div class="h-auto">
        <div class="bg-white rounded-[24px] px-3 py-1.5 flex items-center gap-2 border border-gray-100 shadow-[0_3px_10px_rgb(0,0,0,0.02)] duration-300 h-full">
            <div class="w-8 h-8 flex-shrink-0 flex items-center justify-center rounded-2xl bg-purple-50 text-purple-500">
                <i class="ri-customer-service-2-fill text-base"></i>
            </div>
            <div class="overflow-hidden leading-tight">
                <h4 class="text-[11px] font-bold text-gray-800 truncate">সাপোর্ট সেন্টার</h4>
                <p class="text-[9px] text-gray-400 truncate">২৪/৭ অনলাইন সেবা</p>
            </div>
        </div>
    </div>

</div>
    </div>
</div>



<div class="bg-white py-4 mb-6 md:block hidden">
    <div class="max-w-6xl mx-auto px-2">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Shop by Category</h2>

        <div class="grid grid-cols-6 overflow-hidden" style="max-height: 220px;">
            <?php $__currentLoopData = $allcategories->shuffle()->take(12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'"
                class="flex flex-col items-center justify-start py-3 hover:shadow transition cursor-pointer">
                <img loading="lazy" src="<?php echo e(asset('public/' . $category->image)); ?>" alt="<?php echo e($category->name); ?>"
                    class="w-14 h-14 mb-2 border border-gray-50 rounded-full">
                <span class="text-sm font-medium capitalize text-gray-700 text-center line-clamp-2">
                    <?php echo e($category->name); ?>

                </span>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<div class="bg-white py-4 mb-6 block md:hidden">
    <div class="max-w-6xl mx-auto px-2">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Shop by Category</h2>

        <div class="grid grid-cols-4 overflow-hidden" style="max-height: 230px;">
            <?php $__currentLoopData = $allcategories->shuffle()->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div onclick="window.location.href='<?php echo e(route('category.product', $category->slug)); ?>'"
                class="flex flex-col items-center justify-start py-3 hover:shadow transition cursor-pointer">
                <img loading="lazy" src="<?php echo e(asset('public/' . $category->image)); ?>" alt="<?php echo e($category->name); ?>"
                    class="w-14 h-14 mb-2 border border-gray-50 rounded-full">
                <span class="text-xs font-medium capitalize text-gray-700 text-center line-clamp-2">
                    <?php echo e($category->name); ?>

                </span>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<div class="bg-white py-6">
    <div class="max-w-6xl mx-auto">
<div class="border-b pb-4 mb-6 px-2 flex flex-wrap items-center justify-between gap-4">
            <h2 class="text-lg font-bold text-gray-800 flex items-center gap-2">
                <i class="ri-fire-fill text-[<?php echo e($theme->theme_bg); ?>] animate-pulse"></i> Hot Deals
            </h2>
            
            <?php
                $hotDealsDate = $setting->hot_deals ?? null;
            ?>
            
            <?php if($hotDealsDate): ?>
            <div class="flex gap-3 items-center" id="hot-deal-timer" data-end-date="<?php echo e($hotDealsDate); ?>">
                <div class="flex flex-col items-center">
                    <div id="hours" class="w-9 h-9 text-base flex items-center justify-center rounded-lg bg-[<?php echo e($theme->theme_bg); ?>] text-white font-bold shadow-sm">00</div>
                    <span class="text-[10px] uppercase font-semibold text-gray-500 mt-1">Hrs</span>
                </div>
                <div class="font-bold text-gray-400 mb-5">:</div>
                <div class="flex flex-col items-center">
                    <div id="minutes" class="w-9 h-9 text-base flex items-center justify-center rounded-lg bg-[<?php echo e($theme->theme_bg); ?>] text-white font-bold shadow-sm">00</div>
                    <span class="text-[10px] uppercase font-semibold text-gray-500 mt-1">Min</span>
                </div>
                <div class="font-bold text-gray-400 mb-5">:</div>
                <div class="flex flex-col items-center">
                    <div id="seconds" class="w-9 h-9 text-base flex items-center justify-center rounded-lg bg-[<?php echo e($theme->theme_bg); ?>] text-white font-bold shadow-sm">00</div>
                    <span class="text-[10px] uppercase font-semibold text-gray-500 mt-1">Sec</span>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <div id="hotdealScroll" class="owl-carousel owl-theme">
            <?php $__currentLoopData = $hotDeals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div onclick="window.location='<?php echo e(route('product.details', $product->slug)); ?>'"
                class="group relative bg-white rounded-xl border border-gray-100 p-3 flex flex-col items-start transition-all duration-300 cursor-pointer hover:shadow-[0_10px_20px_rgba(0,0,0,0.08)] hover:-translate-y-1">

                <?php if($product->old_price && $product->new_price): ?>
                <?php
                $badgeText = null;
                if ($product->old_price > $product->new_price) {
                $discount = round((($product->old_price - $product->new_price) / $product->old_price) * 100);
                $badgeText = "-{$discount}%";
                $badgeColor = 'bg-red-500';
                } elseif ($product->old_price < $product->new_price) {
                    $discount = round((($product->new_price - $product->old_price) / $product->old_price) * 100);
                    $badgeText = "+{$discount}%";
                    $badgeColor = 'bg-green-500';
                    }
                    ?>
                    <?php if($badgeText): ?>
                    <span
                        class="absolute top-6 left-6 <?php echo e($badgeColor); ?> text-white text-[11px] font-bold px-2 py-0.5 rounded-full z-20 shadow-sm">
                        <?php echo e($badgeText); ?>

                    </span>
                    <?php endif; ?>
                    <?php endif; ?>

                    <div class="w-full h-44 mb-3 overflow-hidden rounded-lg bg-gray-50 relative">
                        <img loading="lazy"
                            src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                            alt="<?php echo e($product->name); ?>"
                            class="w-full h-full mix-blend-multiply transform group-hover:scale-110 transition duration-500">
                    </div>

                    <div class="w-full flex-1">
                        <h3
                            class="text-gray-800 font-medium text-left capitalize text-[15px] line-clamp-2 mb-1 group-hover:text-[<?php echo e($theme->theme_bg); ?>] transition-colors">
                            <?php echo e($product->name); ?>

                        </h3>

                        <div class="flex items-center gap-0.5">
                            <?php
                            $rating = $product->averageRating();
                            $fullStars = floor($rating);
                            $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;
                            ?>
                            <?php for($i = 0; $i < $fullStars; $i++): ?> <i class="ri-star-fill text-orange-400 text-xs"></i>
                                <?php endfor; ?>
                                <?php if($halfStar): ?>
                                <i class="ri-star-half-line text-orange-400 text-xs"></i>
                                <?php endif; ?>
                                <?php for($i = 0; $i < (5 - $fullStars - $halfStar); $i++): ?> <i
                                    class="ri-star-line text-gray-300 text-xs"></i>
                                    <?php endfor; ?>
                                    <span class="text-[11px] text-gray-400 ml-1">(<?php echo e($product->reviews_count ?? 0); ?>)</span>
                        </div>

                        <div class="mb-2">
                            <span class="text-[<?php echo e($theme->theme_bg); ?>] font-bold text-lg">
                                ৳<?php echo e(number_format($product->new_price)); ?>

                            </span>
                            <?php if($product->old_price): ?>
                            <span class="line-through text-gray-400 text-xs ml-1">
                                ৳<?php echo e(number_format($product->old_price)); ?>

                            </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="flex flex-col gap-2 w-full mt-auto">
                        <form method="POST" action="<?php echo e(route('checkout.buy-now', $product->id)); ?>" class="w-full">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="quantity" value="1">
                            <input type="hidden" name="image"
                                value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                            <button type="submit" onclick="event.stopPropagation();"
                                class="flex items-center justify-center gap-2 bg-[<?php echo e($theme->nav_bg); ?>] hover:opacity-90 text-[<?php echo e($theme->nav_text); ?>] py-2 rounded-lg w-full text-sm font-semibold transition-all">
                                <i class="ri-flashlight-fill"></i> অর্ডার করুন
                            </button>
                        </form>

                        <form method="POST" action="<?php echo e(route('cart.add', $product->id)); ?>" class="w-full">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="quantity" value="1">
                            <input type="hidden" name="image"
                                value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                            <button type="submit" onclick="event.stopPropagation();"
                                class="flex items-center justify-center gap-2 border-2 border-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_bg); ?>] hover:text-white py-1.5 rounded-lg w-full text-sm font-semibold transition-all">
                                <i class="ri-shopping-cart-2-line"></i> কার্টে রাখুন
                            </button>
                        </form>
                    </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<div class="bg-gray-50 pt-4">
    <div class="max-w-6xl mx-auto md:px-0 px-2 sm:px-6">
        <div class="flex items-center justify-between border-b border-gray-200 pb-4 mb-6">
            <h2 class="text-lg font-semibold text-gray-800 flex items-center gap-2 mt-1">
                <i class="ri-fire-fill text-[<?php echo e($theme->theme_bg); ?>]"></i>
                All Brands
            </h2>
    <a href="<?php echo e(route('shop')); ?>" 
       class="flex items-center gap-1 text-[<?php echo e($theme->theme_bg); ?>] text-sm font-bold hover:opacity-80 transition-opacity uppercase tracking-wide">
        <span>আরও দেখুন</span>
        <i class="ri-arrow-right-s-line text-lg"></i>
    </a>
        </div>

        <div class="grid grid-cols-4 md:grid-cols-5 lg:grid-cols-6">
            <?php $__currentLoopData = $brands->shuffle()->take(12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('brand.product', $brand->slug)); ?>" 
                   class="group bg-white p-4 shadow-sm border border-gray-100 flex flex-col items-center justify-center transition-all duration-300">
                    
                    <div class="w-full flex items-center justify-center mb-3">
                        <img loading="lazy" 
                             src="<?php echo e(asset('public/' . $brand->image)); ?>" 
                             alt="<?php echo e($brand->name); ?>"
                             class="max-w-full max-h-full filter transition-all duration-500">
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
    
    
<div class="py-6 mb-2 bg-gray-50/50">
    <div class="max-w-6xl mx-auto px-2">
<div class="flex items-center justify-between mb-3 py-3 px-2 rounded-t-lg border-b border-gray-100">
    <div class="flex items-center gap-3">
                <h2 class="text-lg font-semibold text-gray-800 flex items-center gap-2 mt-1">
                    <i class="ri-fire-fill text-[<?php echo e($theme->theme_bg); ?>]"></i> Available Products
                </h2>
    </div>

    <a href="<?php echo e(route('shop')); ?>" 
       class="flex items-center gap-1 text-[<?php echo e($theme->theme_bg); ?>] text-sm font-bold hover:opacity-80 transition-opacity uppercase tracking-wide">
        <span>আরও দেখুন</span>
        <i class="ri-arrow-right-s-line text-lg"></i>
    </a>
</div>

        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-y-3 gap-x-2">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make('frontend.products.index', ['product' => $product], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="bg-white py-4 mb-6">
    <div class="max-w-6xl mx-auto px-2">
        <h2 class="text-lg font-semibold text-gray-800 mb-4"><?php echo e($category->name); ?></h2>
        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-y-3 gap-x-2">
            <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make('frontend.products.index', ['product' => $product], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

- <div class="bg-white md:py-8 py-4">
    <div
        class="max-w-6xl mx-auto md:px-0 px-4 flex flex-col md:flex-row items-center md:items-center justify-between gap-6">
        <div class="flex flex-col items-center md:items-start md:w-1/3 text-center md:text-left">
            <img src="<?php echo e(asset('public/' . $logo)); ?>" alt="App Logo" class="max-h-[60px] object-contain mb-3">
            <h3 class="text-lg font-semibold text-gray-800">
                এখনই ডাউনলোড করুন আমাদের মোবাইল অ্যাপ
            </h3>
            <p class="text-[13px] text-gray-600 mt-1">
                আরও দ্রুত & সহজ শপিংয়ের জন্য
            </p>
        </div>

        <div id="qrcodes" class="w-32 h-32 bg-gray-50 border rounded-xl flex items-center justify-center shadow-md">
        </div>

        <div class="flex flex-col items-center md:items-end md:w-1/3 text-center md:text-right gap-2">
            <p class="text-[12px] text-indigo-600 font-semibold">
                স্ক্যান করুন এবং অ্যাপ ডাউনলোড করুন
            </p>
            <div class="flex gap-3 mt-1 justify-center md:justify-end">
                <img src="https://icon-library.com/images/android-app-icon-download/android-app-icon-download-11.jpg"
                    class="h-12 object-contain">
                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/9/91/Download_on_the_App_Store_RGB_blk.svg/1024px-Download_on_the_App_Store_RGB_blk.svg.png"
                    class="h-10 object-contain">
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
    var apkLink = "<?php echo e(url('/app.apk')); ?>";
    new QRCode(document.getElementById("qrcodes"), {
        text: apkLink,
        width: 130,
        height: 130,
        colorDark: "#000000",
        colorLight: "#ffffff",
        correctLevel: QRCode.CorrectLevel.H
    });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const cards = document.querySelectorAll(".product-card");

        cards.forEach((card, index) => {
            card.style.animationDelay = (index * 0.3) + "s";
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/frontend/welcome.blade.php ENDPATH**/ ?>